/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPMessage;
import weblogic.jws.MessageBuffer;
import weblogic.wsee.buffer.ServerBufferingHandler;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.conversation.ConversationServerHandler;
import weblogic.wsee.conversation.StartHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlOperation;

public class Wlw81CompatBufferingHandler
extends ConversationServerHandler {
    private static final boolean verbose = Verbose.isVerbose(Wlw81CompatBufferingHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        MessageBuffer messageBuffer = ServerBufferingHandler.getMessageBufferConfig(wlMessageContext);
        if (messageBuffer != null) {
            if (verbose) {
                Verbose.log("Upgraded JWS Method is buffered.  Overriding ONEWAY requirement.");
            }
            wlMessageContext.setProperty("weblogic.wsee.handler.wlw81BufferCompatFlat", Boolean.TRUE);
            ConversationPhase conversationPhase = this.getConversationPhase(wlMessageContext);
            if (conversationPhase == ConversationPhase.START) {
                if (verbose) {
                    Verbose.log("Upgraded JWS Method is buffered and conversational.");
                }
                if (messageContext.getProperty("weblogic.wsee.conversation.ConversationId") == null) {
                    MsgHeaders msgHeaders = wlMessageContext.getHeaders();
                    StartHeader startHeader = (StartHeader)msgHeaders.getHeader(StartHeader.TYPE);
                    if (verbose && startHeader != null) {
                        Verbose.log("WLW Buffering Compat Handler Received StartHeader " + startHeader);
                    }
                    if (startHeader == null || StringUtil.isEmpty(startHeader.getConversationId())) {
                        if (verbose) {
                            Verbose.log("Inserting conversation Id for upgraded buffered method before buffering.");
                        }
                        String string = Guid.generateGuid();
                        if (verbose) {
                            Verbose.log("Inserting conversation Id " + string);
                        }
                        if (startHeader == null) {
                            wlMessageContext.getHeaders().addHeader(new StartHeader(string));
                        } else {
                            startHeader.setConversationId(string);
                        }
                        messageContext.setProperty("weblogic.wsee.conversation.IsServerAssigned", (Object)Boolean.TRUE);
                        messageContext.setProperty("weblogic.wsee.conversation.ConversationId", (Object)string);
                        messageContext.setProperty("weblogic.wsee.conversation.ConversationPhase", (Object)conversationPhase);
                    }
                }
            }
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if (wlMessageContext.containsProperty("weblogic.wsee.handler.wlw81BufferCompatFlat")) {
            Object object;
            if (verbose) {
                Verbose.log("Upgraded JWS Method is buffered.  Creating null response.");
            }
            QName qName = null;
            WsdlOperation wsdlOperation = wlMessageContext.getDispatcher().getOperation();
            if (wsdlOperation != null && (object = wsdlOperation.getOutput()) != null) {
                qName = object.getName();
            }
            if (verbose) {
                Verbose.log("QName of returnElement:" + qName);
            }
            if (messageContext instanceof SOAPMessageContext) {
                object = (SOAPMessageContext)messageContext;
                object.setMessage(this.createWlw81Response((SOAPMessageContext)object, qName));
            }
            if ((object = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase")) == ConversationPhase.START) {
                if (verbose) {
                    Verbose.log("Upgraded JWS Method is buffered and conversational.  Adding conv header. Id = " + wlMessageContext.getProperty("weblogic.wsee.conversation.ConversationId"));
                }
                this.addContinueHeader(wlMessageContext);
            }
        }
        return true;
    }

    private SOAPMessage createWlw81Response(SOAPMessageContext sOAPMessageContext, QName qName) {
        SOAPMessage sOAPMessage = null;
        try {
            Name name;
            sOAPMessage = ((SoapMessageContext)sOAPMessageContext).getMessageFactory().createMessage();
            if (sOAPMessage == null) {
                throw new JAXRPCException("Could not construct message using message factory.");
            }
            if (qName != null && (name = sOAPMessage.getSOAPPart().getEnvelope().createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI())) != null) {
                sOAPMessage.getSOAPPart().getEnvelope().getBody().addBodyElement(name);
            }
        }
        catch (Exception exception) {
            if (exception instanceof JAXRPCException) {
                throw (JAXRPCException)((Object)exception);
            }
            throw new JAXRPCException("Could not construct valid SOAP response", (Throwable)exception);
        }
        return sOAPMessage;
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleClosure(MessageContext messageContext) {
        return true;
    }
}

