/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.api.common;

import com.sun.xml.ws.addressing.WsaPropertyBag;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.buffer2.exception.BufferingException;
import weblogic.wsee.jaxws.client.async.AsyncTransportProvider;
import weblogic.wsee.jaxws.persistence.PersistentContext;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.jaxws.persistence.PersistentObject;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.UnknownDestinationSequenceException;

public abstract class BufferingDispatch {
    protected static final Logger LOGGER = Logger.getLogger(BufferingDispatch.class.getName());
    private WSEndpoint _endpoint;
    private TubelineSpliceFactory.DispatchFactory _dispatchFactory;

    public void setWSEndpoint(WSEndpoint wSEndpoint) {
        this._endpoint = wSEndpoint;
    }

    public void setDispatchFactory(TubelineSpliceFactory.DispatchFactory dispatchFactory) {
        this._dispatchFactory = dispatchFactory;
    }

    public void onMessage(Message message, boolean bl, BufferingFeature bufferingFeature) {
        try {
            if (!(message instanceof ObjectMessage)) {
                throw new BufferingException("Wrong message type, only allow object message");
            }
            Serializable serializable = ((ObjectMessage)message).getObject();
            if (!(serializable instanceof PersistentMessage) && !(serializable instanceof PersistentObject)) {
                throw new BufferingException("Wrong object message received, expected type: weblogic.wsee.jaxws.persistence.PersistentMessage or weblogic.wsee.jaxws.persistence.PersistentObject: " + (serializable != null ? serializable.getClass().getName() : null));
            }
            PersistentContext persistentContext = serializable instanceof PersistentMessage ? ((PersistentMessage)serializable).getContext() : ((PersistentObject)serializable).getContext();
            try {
                int n = message.getIntProperty("JMSXDeliveryCount");
                persistentContext.getPropertyMap().put("weblogic.wsee.buffer.BufferedMessageJmsDeliveryCount", Integer.valueOf(n));
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, exception.toString(), exception);
                }
                exception.printStackTrace();
            }
            this.executeDeliverPlatform(serializable, bl, bufferingFeature);
        }
        catch (Exception exception) {
            String string = "Error processing message off buffer queue for endpoint " + this._endpoint.getEndpointId() + ": " + exception.toString();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, string, exception);
            }
            WseeCoreLogger.logUnexpectedException((String)string, (Throwable)exception);
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    protected void deliver(PersistentMessage persistentMessage, boolean bl, BufferingFeature bufferingFeature) {
        try {
            Dispatch<Packet> dispatch;
            Object object;
            Packet packet = new Packet();
            PersistentMessageFactory.getInstance().setMessageIntoPacket(persistentMessage, packet);
            PreDispatch preDispatch = this.getPreDispatch(bufferingFeature.getBufferingFeatureUser(), packet);
            boolean bl2 = preDispatch.execute(packet, bl);
            AddressingVersion addressingVersion = preDispatch.getAddressingVersion();
            SOAPVersion sOAPVersion = preDispatch.getSOAPVersion();
            if (persistentMessage == null || packet.getMessage() == null) {
                throw new IllegalArgumentException("Null message for preDispatch: " + preDispatch);
            }
            String string = packet.getMessage().getHeaders().getMessageID(addressingVersion, sOAPVersion);
            if (!bl2) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** deliver(): bypassing the processing for message " + string + " after PreDispatch told us to.");
                }
                return;
            }
            if (bl) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** deliver(): process Response with msgId " + string);
                }
                if ((object = this._endpoint.getBinding().getAddressingVersion()) == null) {
                    object = preDispatch.getAddressingVersion();
                }
                WSEndpointReference wSEndpointReference = object.anonymousEpr;
                dispatch = this._dispatchFactory.createResponseDispatch(wSEndpointReference, Packet.class, Service.Mode.MESSAGE);
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** deliver(): process Request with msgId " + string);
                }
                dispatch = this._dispatchFactory.createDispatch(Packet.class, Service.Mode.MESSAGE);
            }
            packet.endpoint = this._endpoint;
            dispatch.getRequestContext().put("weblogic.wsee.jaxws.async.PersistentContext", packet.persistentContext);
            if (LOGGER.isLoggable(Level.FINE)) {
                object = AsyncTransportProvider.dumpPersistentContextContextProps((Map)dispatch.getRequestContext().get("weblogic.wsee.jaxws.async.PersistentContext"));
                LOGGER.fine("** deliver(): Set RequestContext's persistent context for msgID=" + string + " " + (bl ? "*response* " : " ") + " persistentContext: " + (String)object);
            }
            object = (Packet)dispatch.invoke((Object)packet);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** deliver(): completed dispatch.invoke for msgId=" + string + ".  ");
                LOGGER.fine(object == null ? "** deliver(): response is NULL" : (object.getMessage() == null ? "** deliver(): response.message is NULL" : "** deliver(): response.message is NOT NULL"));
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** deliver(): deliver() complete for msgId=" + string + ".  returning ");
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    public abstract String getMDBClassName();

    protected abstract void executeDeliverPlatform(Object var1, boolean var2, BufferingFeature var3);

    private PreDispatch getPreDispatch(BufferingFeature.BufferingFeatureUsers bufferingFeatureUsers, Packet packet) throws Exception {
        if (bufferingFeatureUsers.equals((Object)BufferingFeature.BufferingFeatureUsers.WSRM)) {
            return new PreDispatch_WSRM(packet, this._endpoint);
        }
        return new PreDispatch_NONE();
    }

    protected static class NullObject {
        protected NullObject() {
        }
    }

    static class PreDispatch_WSRM
    extends PreDispatch {
        private static final Logger LOGGER = Logger.getLogger(PreDispatch_WSRM.class.getName());
        private Packet _packet;
        private WSEndpoint _endpoint;
        private WsrmPropertyBag _rmProps;
        private DestinationMessageInfo _msgInfo;

        protected PreDispatch_WSRM(Packet packet, WSEndpoint wSEndpoint) throws Exception {
            this._packet = packet;
            this._endpoint = wSEndpoint;
            this._rmProps = WsrmPropertyBag.propertySetRetriever.getFromPacket(this._packet);
            this._msgInfo = this._rmProps.getDestMessageInfoFromRequest();
            if (this._msgInfo == null) {
                String string = "Null MessageInfo in BufferingDispatch!!. Inbound msgId: " + this._rmProps.getInboundMessageId() + " Inbound endpointAddress: " + this._rmProps.getInboundEndpointAddress();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info(string);
                }
                throw new IllegalStateException(string);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** BufferingDispatch$PreDispatch_WSRM.execute: Beginning to process buffered message with msg id " + this._msgInfo.getMessageId() + " seq " + this._msgInfo.getSequenceId() + " and message number " + this._msgInfo.getMessageNum());
            }
            this._rmProps.restorePersistentPropsIntoJaxWsRi(this.getAddressingVersion(), this.getSOAPVersion());
        }

        boolean execute(Packet packet, boolean bl) throws Exception {
            boolean bl2;
            block9: {
                DestinationSequence destinationSequence;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** BufferingDispatch_WSRM is processing message id " + this._msgInfo.getMessageId() + " from seq " + this._msgInfo.getSequenceId() + " and msg num " + this._msgInfo.getMessageNum());
                }
                DestinationMessageInfo destinationMessageInfo = (destinationSequence = DestinationSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), this._msgInfo.getSequenceId(), true)) != null ? (DestinationMessageInfo)destinationSequence.getRequest(this._msgInfo.getMessageNum()) : null;
                bl2 = true;
                String string = "IN PROCESS";
                if (this._msgInfo.isEmptyLastMessage()) {
                    bl2 = false;
                    string = "LastMessage NO_RESPONSE";
                    this._msgInfo.setNoResponse();
                    if (destinationMessageInfo != null) {
                        destinationMessageInfo.setNoResponse();
                    }
                } else {
                    this._msgInfo.setInProcess();
                    if (destinationMessageInfo != null) {
                        destinationMessageInfo.setInProcess();
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** BufferingDispatch$PreDispatch_WSRM.execute: Writing " + string + " destination message info for msg " + this._msgInfo.getMessageId() + " seq " + this._msgInfo.getSequenceId() + " and message number " + this._msgInfo.getMessageNum());
                }
                if (destinationSequence != null) {
                    try {
                        DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
                    }
                    catch (UnknownDestinationSequenceException unknownDestinationSequenceException) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block9;
                        LOGGER.fine("Destination sequence " + destinationSequence.getId() + " was terminated before we could register NoResponse/InProcess on incoming request msg " + this._msgInfo.getMessageId() + " msg num " + this._msgInfo.getMessageNum());
                    }
                }
            }
            packet.addSatellite((PropertySet)new WsaPropertyBag(this.getAddressingVersion(), this.getSOAPVersion(), packet));
            packet.endpointAddress = new EndpointAddress(this._rmProps.getInboundEndpointAddress());
            return bl2;
        }

        AddressingVersion getAddressingVersion() {
            AddressingVersion addressingVersion = this._endpoint.getBinding().getAddressingVersion();
            if (addressingVersion == null) {
                addressingVersion = AddressingVersion.W3C;
            }
            return addressingVersion;
        }

        SOAPVersion getSOAPVersion() {
            return this._endpoint.getBinding().getSOAPVersion();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" msgId=").append(this._msgInfo.getMessageId());
            stringBuffer.append(" msgInfo=").append(this._msgInfo);
            return stringBuffer.toString();
        }
    }

    static class PreDispatch_NONE
    extends PreDispatch {
        PreDispatch_NONE() {
        }

        boolean execute(Packet packet, boolean bl) throws Exception {
            return true;
        }

        AddressingVersion getAddressingVersion() {
            return null;
        }

        SOAPVersion getSOAPVersion() {
            return null;
        }
    }

    static abstract class PreDispatch {
        PreDispatch() {
        }

        abstract boolean execute(Packet var1, boolean var2) throws Exception;

        abstract AddressingVersion getAddressingVersion();

        abstract SOAPVersion getSOAPVersion();
    }
}

