/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.api.common;

import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceFeature;
import weblogic.wsee.buffer2.api.common.BufferingDispatch;
import weblogic.wsee.buffer2.api.common.BufferingManager;
import weblogic.wsee.buffer2.exception.BufferingException;
import weblogic.wsee.buffer2.spi.BufferingProviderManager;
import weblogic.wsee.buffer2.utils.BufferingConstants;
import weblogic.wsee.jaxws.buffer.BufferingConfig;
import weblogic.wsee.reliability2.saf.BufferUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferingFeature
extends WebServiceFeature {
    private static final Logger LOGGER;
    private static final String ID = "Buffering Feature";
    private static final ConcurrentMap<String, BufferingFeature> _registry;
    private static final Map<String, BufferingFeature> _targetURIMap;
    private static final Map<String, Object> _queueToDynamicMDBMap;
    private static volatile BufferingManager _bufferingManager;
    private String _bufferingFeatureId;
    private final Set<String> _targetURIs;
    private volatile Map<String, ConcurrentHashMap<String, Long>> retryDelays;
    private final BufferingConfig.Queue _requestQueue;
    private final BufferingConfig.Queue _responseQueue;
    private final int _retryCount;
    private final String _retryDelay;
    private BufferingConstants.MsgDirection _direction;
    private volatile BufferingDispatch _bufferingDispatch;
    private final BufferingFeatureUsers _bufferingFeatureUser;

    public static BufferingFeature newBufferingFeature(BufferingFeatureUsers bufferingFeatureUsers, ServerTubeAssemblerContext serverTubeAssemblerContext) throws BufferingException {
        BufferingFeature bufferingFeature = new BufferingFeature(bufferingFeatureUsers, serverTubeAssemblerContext);
        bufferingFeature.setBufferingFeatureId(BufferingFeature.registerFeature(bufferingFeature));
        return bufferingFeature;
    }

    public static BufferingFeature newBufferingFeature(BufferingFeatureUsers bufferingFeatureUsers, ClientTubeAssemblerContext clientTubeAssemblerContext) throws BufferingException {
        BufferingFeature bufferingFeature = new BufferingFeature(bufferingFeatureUsers, clientTubeAssemblerContext);
        bufferingFeature.setBufferingFeatureId(BufferingFeature.registerFeature(bufferingFeature));
        return bufferingFeature;
    }

    private BufferingFeature(BufferingFeatureUsers bufferingFeatureUsers, ServerTubeAssemblerContext serverTubeAssemblerContext) throws BufferingException {
        this(bufferingFeatureUsers, BufferingConfig.getServiceConfig(serverTubeAssemblerContext));
    }

    private BufferingFeature(BufferingFeatureUsers bufferingFeatureUsers, ClientTubeAssemblerContext clientTubeAssemblerContext) throws BufferingException {
        this(bufferingFeatureUsers, BufferingConfig.getServiceConfig(clientTubeAssemblerContext));
    }

    private BufferingFeature(BufferingFeatureUsers bufferingFeatureUsers, BufferingConfig.Service service2) throws BufferingException {
        try {
            this.enabled = true;
            this._retryCount = service2.getRetryCount();
            this._retryDelay = service2.getRetryDelay();
            this._requestQueue = service2.getRequestQueue();
            this._responseQueue = service2.getResponseQueue();
            this._direction = BufferingConstants.MsgDirection.REQUEST;
            this._bufferingFeatureUser = bufferingFeatureUsers;
            _bufferingManager = BufferingProviderManager.getBufferingProvider().getBufferingManager();
            this._targetURIs = new ConcurrentSkipListSet<String>();
        }
        catch (Exception exception) {
            throw new BufferingException(exception);
        }
    }

    public String getID() {
        return ID;
    }

    public int getDeployedRetryCount() {
        return this._retryCount;
    }

    public String getDeployedRetryDelay() {
        return this._retryDelay;
    }

    public BufferingConstants.MsgDirection getDirection() {
        return this._direction;
    }

    public void setDirection(BufferingConstants.MsgDirection msgDirection) {
        this._direction = msgDirection;
    }

    public String getBufferingFeatureId() {
        return this._bufferingFeatureId;
    }

    void setBufferingFeatureId(String string) {
        this._bufferingFeatureId = string;
    }

    public BufferingDispatch getBufferDispatch() {
        return this._bufferingDispatch;
    }

    public void setBufferDispatch(BufferingDispatch bufferingDispatch) {
        this._bufferingDispatch = bufferingDispatch;
    }

    public BufferingFeatureUsers getBufferingFeatureUser() {
        return this._bufferingFeatureUser;
    }

    private void addTargetURI(String string) {
        this.getTargetURIs().add(string);
    }

    public Set<String> getTargetURIs() {
        return this._targetURIs;
    }

    public void putRetryDelay(String string, String string2, long l) {
        ConcurrentHashMap<String, Long> concurrentHashMap = this.getRetryDelays().get(string);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap();
            this.retryDelays.put(string, concurrentHashMap);
        }
        concurrentHashMap.put(string2, l);
    }

    public long getRetryDelay(String string, String string2) {
        ConcurrentHashMap<String, Long> concurrentHashMap = this.getRetryDelays().get(string);
        if (concurrentHashMap == null) {
            return -1L;
        }
        Long l = concurrentHashMap.get(string2);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public void removeRetryDelay(String string) {
        this.getRetryDelays().remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ConcurrentHashMap<String, Long>> getRetryDelays() {
        Map<String, ConcurrentHashMap<String, Long>> map = this.retryDelays;
        if (map == null) {
            BufferingFeature bufferingFeature = this;
            synchronized (bufferingFeature) {
                map = this.retryDelays;
                if (map == null) {
                    this.retryDelays = map = new ConcurrentHashMap<String, ConcurrentHashMap<String, Long>>();
                }
            }
        }
        return map;
    }

    public String getQueueJndiName() {
        switch (this.getDirection()) {
            default: {
                return this._requestQueue.getJndiName();
            }
            case RESPONSE: 
        }
        return this._responseQueue.getJndiName() != null ? this._responseQueue.getJndiName() : this._requestQueue.getJndiName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBufferingFeatureRegistered(String string) {
        Class<BufferingFeature> clazz = BufferingFeature.class;
        synchronized (BufferingFeature.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _targetURIMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferingFeature getBufferingFeature(String string) throws BufferingException {
        BufferingFeature bufferingFeature = null;
        Class<BufferingFeature> clazz = BufferingFeature.class;
        synchronized (BufferingFeature.class) {
            bufferingFeature = _targetURIMap.get(string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (bufferingFeature == null) {
                throw new BufferingException("No BufferingFeature registered for targetUri='" + string + "'");
            }
            return bufferingFeature;
        }
    }

    public static BufferingManager getBufferingManager() {
        return _bufferingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTargetURI(String string, BufferingFeature bufferingFeature) throws BufferingException {
        Class<BufferingFeature> clazz = BufferingFeature.class;
        synchronized (BufferingFeature.class) {
            BufferingFeature bufferingFeature2 = _targetURIMap.get(string);
            if (bufferingFeature2 != null && !bufferingFeature2.getBufferingFeatureId().equals(bufferingFeature.getBufferingFeatureId())) {
                throw new BufferingException("Attempt to register targetURI='" + string + "' current associated with BufferingFeature='" + bufferingFeature2.getBufferingFeatureId() + "' with a DIFFERENT BufferingFeature='" + bufferingFeature.getBufferingFeatureId() + "'.  This is not allowed because a given targetURI MUST be routed to a unique BufferingFeature instance.");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BufferingFeature addTargetURI for targetURI='" + (string == null ? "NULL" : string) + "'" + " and BufferingFeature with bufferingFeatureId='" + (bufferingFeature == null ? "NULL" : bufferingFeature.getBufferingFeatureId()));
            }
            _targetURIMap.put(string, bufferingFeature);
            bufferingFeature.addTargetURI(string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static BufferingDispatch getBufferDispatch(String string) throws BufferingException {
        BufferingFeature bufferingFeature = BufferingFeature.getBufferingFeature(string);
        return bufferingFeature.getBufferDispatch();
    }

    public static BufferingFeatureUsers getBufferingFeatureUser(String string) throws BufferingException {
        BufferingFeature bufferingFeature = BufferingFeature.getBufferingFeature(string);
        return bufferingFeature.getBufferingFeatureUser();
    }

    public static String getQueueJndiName(String string) throws BufferingException {
        BufferingFeature bufferingFeature = BufferingFeature.getBufferingFeature(string);
        return bufferingFeature.getQueueJndiName();
    }

    public static void registerQueue(String string, Object object) {
        _queueToDynamicMDBMap.put(string, object);
    }

    public static boolean isQueueRegistered(String string) {
        return _queueToDynamicMDBMap.containsKey(string);
    }

    private static String registerFeature(BufferingFeature bufferingFeature) throws BufferingException {
        String string = null;
        int n = 3;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            string = UUID.randomUUID().toString();
            if (_registry.putIfAbsent(string, bufferingFeature) != null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new BufferingException("unable to create unique BufferingFeature ID after " + n + " tries.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("BufferingFeature registerFeature() registering BufferingFeature ID='" + string + "' ");
        }
        return string;
    }

    public static void unRegisterBufferingFeature(ServerTubeAssemblerContext serverTubeAssemblerContext) {
        BufferingFeature.unRegisterBufferingFeature(serverTubeAssemblerContext.getEndpoint());
    }

    public static void unRegisterBufferingFeature(WSEndpoint wSEndpoint) {
        List<String> list = BufferUtil.getTargetURIs(wSEndpoint);
        if (list.size() <= 0) {
            return;
        }
        String string = list.get(0);
        BufferingFeature bufferingFeature = _targetURIMap.get(string);
        if (bufferingFeature != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("unRegisterBufferingFeature for targetURI='" + (string == null ? "NULL" : string) + "'" + " found BufferingFeature with bufferingFeatureID='" + (bufferingFeature == null ? "NULL" : bufferingFeature.getBufferingFeatureId()));
            }
            BufferingFeature.removeFeature(bufferingFeature.getBufferingFeatureId());
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("unRegisterBufferingFeature for targetURI='" + (string == null ? "NULL" : string) + "'" + " no BufferingFeature registered.  Skipping unRegister.");
        }
    }

    private static BufferingFeature removeFeature(String string) {
        Set<String> set;
        BufferingFeature bufferingFeature;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("BufferingFeature removeFeature() unRegistering BufferingFeature ID='" + string + "' ");
        }
        if ((bufferingFeature = (BufferingFeature)((Object)_registry.get(string))) != null && (set = bufferingFeature.getTargetURIs()) != null) {
            for (String string2 : set) {
                _targetURIMap.remove(string2);
            }
        }
        return (BufferingFeature)((Object)_registry.remove(string));
    }

    public static void stop() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("BufferingFeature stop()");
        }
        if (_bufferingManager != null) {
            _bufferingManager.cleanupDynamicMDBs(_queueToDynamicMDBMap);
        }
    }

    static {
        _registry = new ConcurrentHashMap<String, BufferingFeature>();
        _targetURIMap = new ConcurrentHashMap<String, BufferingFeature>();
        _queueToDynamicMDBMap = new ConcurrentHashMap<String, Object>();
        LOGGER = Logger.getLogger(BufferingFeature.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BufferingFeatureUsers {
        WSRM;

    }
}

