/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.api.common;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.wsee.buffer2.api.common.BufferingDispatch;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.buffer2.exception.BufferingException;
import weblogic.wsee.buffer2.internal.common.JmsSessionPool;
import weblogic.wsee.buffer2.utils.BufferingConstants;
import weblogic.wsee.jaxws.spi.WLSEndpoint;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BufferingManager {
    protected static final Logger LOGGER = Logger.getLogger(BufferingManager.class.getName());
    public static final String RETRY_DELAY = "WLSRetryDelay";
    private static volatile JmsSessionPool nonTransactedSessionPool;
    protected InitialContext ctx;
    private static WLSEndpointListener _wlsEndpointListener;

    protected BufferingManager() throws BufferingException {
        try {
            this.ctx = new InitialContext();
        }
        catch (NamingException namingException) {
            throw new BufferingException(namingException);
        }
    }

    public void bufferMessage(String string, Serializable serializable, @NotNull BufferingConstants.MsgDirection msgDirection, int n, long l, String string2, long l2) throws BufferingException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Buffering message for " + string);
            LOGGER.fine("(retryCount = " + n + ", retryDelay = " + l + ")");
        }
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        try {
            queueSession = this.getNonTransactedSession();
            queueSender = this.getQueueSender(queueSession, string, string2);
            ObjectMessage objectMessage = queueSession.createObjectMessage(serializable);
            objectMessage.setStringProperty(BufferingConstants.TARGET_URI, string);
            objectMessage.setStringProperty(BufferingConstants.DIRECTION, msgDirection.toString());
            this.bufferMessagePlatform((Message)objectMessage, queueSender, string, l, n, string2, l2);
            this.sendMessage(string, queueSender, (Message)objectMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception.getCause() != null) {
                exception.getCause().printStackTrace();
            }
            throw new BufferingException("Could not enqueue buffered message: " + exception, exception);
        }
        finally {
            if (queueSender != null) {
                try {
                    queueSender.close();
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, exception.toString(), exception);
                    }
                    exception.printStackTrace();
                }
            }
            try {
                this.putNonTransactedSession(queueSession);
            }
            catch (BufferingException bufferingException) {}
        }
    }

    public QueueSession getNonTransactedSession() throws BufferingException {
        return this.getNonTransactedSessionPool().take();
    }

    public void putNonTransactedSession(QueueSession queueSession) throws BufferingException {
        this.getNonTransactedSessionPool().recycle(queueSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JmsSessionPool getNonTransactedSessionPool() throws BufferingException {
        JmsSessionPool jmsSessionPool = nonTransactedSessionPool;
        if (jmsSessionPool != null) return jmsSessionPool;
        Class<BufferingFeature> clazz = BufferingFeature.class;
        synchronized (BufferingFeature.class) {
            jmsSessionPool = nonTransactedSessionPool;
            if (jmsSessionPool != null) return jmsSessionPool;
            nonTransactedSessionPool = jmsSessionPool = this.getNonTransactedSessionPoolPlatform();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return jmsSessionPool;
        }
    }

    protected QueueSender getQueueSender(QueueSession queueSession, String string, String string2) throws Exception {
        String string3 = BufferingFeature.getQueueJndiName(string);
        this.ctx.lookup(string3);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Buffering message for " + string);
            LOGGER.fine("put onto Queue ='" + string3 + "')");
        }
        return this.getQueueSenderPlatform(queueSession, string3, string2);
    }

    protected void sendMessage(String string, QueueSender queueSender, Message message) throws JMSException {
        this.sendMessagePlatform(string, queueSender, message);
    }

    public BufferingFeature newBufferingFeature(BufferingFeature.BufferingFeatureUsers bufferingFeatureUsers, ServerTubeAssemblerContext serverTubeAssemblerContext, boolean bl, WSEndpoint wSEndpoint, TubelineSpliceFactory.DispatchFactory dispatchFactory) throws BufferingException {
        BufferingFeature bufferingFeature = BufferingFeature.newBufferingFeature(bufferingFeatureUsers, serverTubeAssemblerContext);
        bufferingFeature = this.newBufferingFeature(wSEndpoint, dispatchFactory, bufferingFeature);
        bufferingFeature.setDirection(bl ? BufferingConstants.MsgDirection.RESPONSE : BufferingConstants.MsgDirection.REQUEST);
        return bufferingFeature;
    }

    public BufferingFeature newBufferingFeature(BufferingFeature.BufferingFeatureUsers bufferingFeatureUsers, ClientTubeAssemblerContext clientTubeAssemblerContext, boolean bl, WLSEndpoint wLSEndpoint, TubelineSpliceFactory.DispatchFactory dispatchFactory) throws BufferingException {
        BufferingFeature bufferingFeature = BufferingFeature.newBufferingFeature(bufferingFeatureUsers, clientTubeAssemblerContext);
        bufferingFeature = this.newBufferingFeature(wLSEndpoint.getWSEndpoint(), dispatchFactory, bufferingFeature);
        bufferingFeature.setDirection(bl ? BufferingConstants.MsgDirection.RESPONSE : BufferingConstants.MsgDirection.REQUEST);
        wLSEndpoint.addListener(_wlsEndpointListener);
        return bufferingFeature;
    }

    private BufferingFeature newBufferingFeature(WSEndpoint wSEndpoint, TubelineSpliceFactory.DispatchFactory dispatchFactory, BufferingFeature bufferingFeature) {
        Object t = this.newBufferingDispatch();
        ((BufferingDispatch)t).setWSEndpoint(wSEndpoint);
        ((BufferingDispatch)t).setDispatchFactory(dispatchFactory);
        bufferingFeature.setBufferDispatch((BufferingDispatch)t);
        return bufferingFeature;
    }

    protected abstract void sendMessagePlatform(String var1, QueueSender var2, Message var3) throws JMSException;

    public abstract <T extends BufferingDispatch> T newBufferingDispatch();

    protected abstract JmsSessionPool getNonTransactedSessionPoolPlatform() throws BufferingException;

    protected abstract QueueSender getQueueSenderPlatform(QueueSession var1, String var2, String var3) throws JMSException;

    protected abstract void bufferMessagePlatform(Message var1, QueueSender var2, String var3, long var4, int var6, String var7, long var8) throws BufferingException;

    public abstract void cleanupDynamicMDBs(Map<String, Object> var1);

    static {
        _wlsEndpointListener = new WLSEndpointListener();
    }

    private static class WLSEndpointListener
    implements WLSEndpoint.Listener {
        private WLSEndpointListener() {
        }

        public void endpointStopping(WLSEndpoint wLSEndpoint) {
            BufferingFeature.unRegisterBufferingFeature(wLSEndpoint.getWSEndpoint());
        }
    }
}

