/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.api.wls;

import com.sun.xml.ws.api.pipe.Fiber;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import weblogic.jws.jaxws.client.async.FiberBox;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.buffer2.api.common.BufferingDispatch;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.jaxws.persistence.PersistentContext;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.jaxws.persistence.PersistentObject;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;

public final class BufferingDispatch_WLS
extends BufferingDispatch {
    private static String WLS_MDB_CLASSNAME = "weblogic.wsee.buffer2.internal.wls.BufferingMDB_WLS";

    public String getMDBClassName() {
        return WLS_MDB_CLASSNAME;
    }

    protected void executeDeliverPlatform(final Object object, final boolean bl, final BufferingFeature bufferingFeature) {
        try {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            PrivilegedExceptionAction<BufferingDispatch.NullObject> privilegedExceptionAction = new PrivilegedExceptionAction<BufferingDispatch.NullObject>(){

                @Override
                public BufferingDispatch.NullObject run() throws Exception {
                    if (object instanceof PersistentMessage) {
                        PersistentMessage persistentMessage = (PersistentMessage)object;
                        BufferingDispatch_WLS.this.deliver(persistentMessage, bl, bufferingFeature);
                    } else {
                        PersistentObject persistentObject = (PersistentObject)object;
                        DestinationMessageInfo destinationMessageInfo = (DestinationMessageInfo)persistentObject.getObj();
                        FiberBox fiberBox = destinationMessageInfo.getSuspendedFiber();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Got suspended fiber msgInfo from buffered message; " + fiberBox);
                        }
                        if (fiberBox != null) {
                            Fiber fiber = fiberBox.get();
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Resuming suspended fiber from buffered message; " + fiber);
                            }
                            fiber.resume(fiber.getPacket(), true);
                        }
                    }
                    return null;
                }
            };
            PersistentContext persistentContext = object instanceof PersistentMessage ? ((PersistentMessage)object).getContext() : ((PersistentObject)object).getContext();
            PersistentMessageFactory.getInstance().runActionInContext(persistentContext, authenticatedSubject, privilegedExceptionAction);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }
}

