/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.api.wls;

import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import weblogic.ejb.spi.DynamicEJBModule;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.wsee.buffer2.api.common.BufferingDispatch;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.buffer2.api.common.BufferingManager;
import weblogic.wsee.buffer2.api.wls.BufferingDispatch_WLS;
import weblogic.wsee.buffer2.exception.BufferingException;
import weblogic.wsee.buffer2.internal.common.JmsSessionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferingManager_WLS
extends BufferingManager {
    private static UnitOfOrderQueueFinder _unitOfOrderQueueFinder;

    public static void setUnitOfOrderQueueFinder(UnitOfOrderQueueFinder unitOfOrderQueueFinder) {
        _unitOfOrderQueueFinder = unitOfOrderQueueFinder;
    }

    public BufferingDispatch newBufferingDispatch() {
        return new BufferingDispatch_WLS();
    }

    @Override
    public void bufferMessagePlatform(Message message, QueueSender queueSender, String string, long l, int n, String string2, long l2) throws BufferingException {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** WLS bufferMessagePlatform(): targetURI='" + string + "', " + "setting Retry Delay='" + l + ", " + "redeliveryLimit='" + n + ", " + "unitOfOrder='" + string2 + "'.");
            }
            message.setLongProperty("WLSRetryDelay", l);
            ((WLMessageProducer)queueSender).setRedeliveryLimit(n);
            ((WLMessageProducer)queueSender).setUnitOfOrder(string2);
            BufferingFeature.BufferingFeatureUsers bufferingFeatureUsers = BufferingFeature.getBufferingFeatureUser(string);
            if (bufferingFeatureUsers.equals((Object)BufferingFeature.BufferingFeatureUsers.WSRM)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** WLS bufferMessagePlatform():  setting message properties for feature WS-RM:  SAFSequenceName='" + string2 + "', " + "SAFSeqNumber='" + l2 + "', " + "SAFNeedReorder='" + true + "'");
                }
                ((WLMessage)message).setSAFSequenceName(string2);
                ((WLMessage)message).setSAFSeqNumber(l2);
                ((MessageImpl)message).setSAFNeedReorder(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception.getCause() != null) {
                exception.getCause().printStackTrace();
            }
            throw new BufferingException("Could not enqueue buffered message: " + exception, exception);
        }
    }

    @Override
    protected final JmsSessionPool getNonTransactedSessionPoolPlatform() throws BufferingException {
        JmsSessionPool jmsSessionPool;
        try {
            Class<?> clazz = Class.forName("weblogic.jms.common.JMSServerUtilities");
            Method method = clazz.getMethod("getConnectionFactory", new Class[0]);
            if (method == null) {
                throw new BufferingException("Could not load method weblogic.jms.common.JMSServerUtilities.getXAConnectionFactory1");
            }
            Object object = method.invoke(null, new Object[0]);
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)object;
            jmsSessionPool = new JmsSessionPool(queueConnectionFactory, false, 1);
        }
        catch (Exception exception) {
            if (exception instanceof BufferingException) {
                throw (BufferingException)exception;
            }
            throw new BufferingException(exception);
        }
        return jmsSessionPool;
    }

    @Override
    protected final QueueSender getQueueSenderPlatform(final QueueSession queueSession, String string, String string2) throws JMSException {
        QueueSender queueSender;
        String string3;
        String string4 = null;
        if (string2 != null && _unitOfOrderQueueFinder != null) {
            string3 = _unitOfOrderQueueFinder.findQueueJndiNameForUnitOfOrder(string, string2);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Calculated UnitOfOrder-specific Queue JNDI: " + string3 + " for UnitOfOrder: " + string2 + " from Distributed Queue JNDI: " + string);
            }
            if (string3 != null) {
                try {
                    string4 = (Queue)this.ctx.lookup(string3);
                }
                catch (Exception exception) {
                    JMSException jMSException = new JMSException(exception.toString(), exception.toString());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
            }
        }
        if (string4 == null) {
            try {
                string4 = (Queue)this.ctx.lookup(string);
            }
            catch (Exception exception) {
                JMSException jMSException = new JMSException(exception.toString(), exception.toString());
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
        }
        string3 = string4;
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction((Queue)string3){
            final /* synthetic */ Queue val$useQueue;
            {
                this.val$useQueue = queue;
            }

            public Object run() throws JMSException {
                return queueSession.createSender(this.val$useQueue);
            }
        };
        try {
            queueSender = (QueueSender)privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
        return queueSender;
    }

    @Override
    protected final void sendMessagePlatform(String string, final QueueSender queueSender, final Message message) throws JMSException {
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                queueSender.send(message);
                return null;
            }
        };
        try {
            privilegedExceptionAction.run();
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        catch (Exception exception) {
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    @Override
    public void cleanupDynamicMDBs(Map<String, Object> map) {
        if (map != null) {
            for (Object object : map.values()) {
                DynamicEJBModule dynamicEJBModule = (DynamicEJBModule)object;
                dynamicEJBModule.undeployDynamicEJB();
            }
        }
    }

    public static interface UnitOfOrderQueueFinder {
        public String findQueueJndiNameForUnitOfOrder(String var1, String var2);
    }
}

