/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.internal.common;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.xml.rpc.JAXRPCException;
import weblogic.wsee.buffer.NoRetryException;
import weblogic.wsee.buffer2.api.common.BufferingDispatch;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.buffer2.utils.BufferingConstants;
import weblogic.wsee.jws.RetryException;
import weblogic.wsee.jws.container.Duration;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.ws.WsException;

public abstract class BufferingMDB
implements MessageListener {
    protected static final Logger LOGGER = Logger.getLogger(BufferingMDB.class.getName());

    public void ejbRemove() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("BufferingMDB removed");
        }
    }

    public void ejbCreate() throws CreateException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("BufferingMDB created");
        }
    }

    public void onMessage(Message message) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("onMessage");
        }
        boolean bl = true;
        long l = 0L;
        String string = null;
        try {
            string = message.getStringProperty(BufferingConstants.TARGET_URI);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BufferingMDB.onMessage: Deliver message to " + string);
            }
            boolean bl2 = true;
            String string2 = message.getStringProperty(BufferingConstants.DIRECTION);
            if (string2.equals(BufferingConstants.MsgDirection.REQUEST.toString())) {
                bl2 = false;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BufferingMDB.onMessage: isResponse='" + bl2 + "'");
            }
            if (bl2) {
                WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_IN_MSG_UPON_DEBUFFER);
            } else {
                WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.SERV_IN_MSG_UPON_DEBUFFER);
            }
            BufferingFeature bufferingFeature = BufferingFeature.getBufferingFeature(string);
            BufferingDispatch bufferingDispatch = BufferingFeature.getBufferDispatch(string);
            bufferingDispatch.onMessage(message, bl2, bufferingFeature);
        }
        catch (NoRetryException noRetryException) {
            assert (noRetryException.getCause() != null);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, noRetryException.toString(), noRetryException);
            }
            bl = false;
            if (noRetryException.getCause() instanceof JAXRPCException) {
                throw (JAXRPCException)noRetryException.getCause();
            }
            throw new JAXRPCException(noRetryException.getCause());
        }
        catch (Exception exception) {
            Throwable throwable;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, exception.toString(), exception);
            }
            if (exception instanceof JAXRPCException && (throwable = ((JAXRPCException)((Object)exception)).getLinkedCause()) instanceof WsException && throwable.getCause() instanceof RetryException) {
                if (this.retrySupported()) {
                    RetryException retryException = (RetryException)throwable.getCause();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Reset the retry delay from user-defined RetryException:" + retryException.getRetryDelay());
                    }
                    Duration duration = new Duration(retryException.getRetryDelay());
                    l = duration.convertToSeconds(new Date());
                    return;
                }
                throw new RuntimeException("Got RetryException when JMS retries is not supported. " + exception.getMessage());
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
        finally {
            if (this.retrySupported() && bl) {
                this.setRetryDelay(message, string, l);
            }
        }
    }

    protected abstract void setRetryDelay(Message var1, String var2, long var3);

    public abstract void setSession(Session var1);

    protected abstract boolean retrySupported();
}

