/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.internal.common;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.WseeCoreLogger;

public final class JmsSessionPool {
    private static final Logger LOGGER = Logger.getLogger(JmsSessionPool.class.getName());
    private static final ConcurrentLinkedQueue<QueueSession> _sessionQueue = new ConcurrentLinkedQueue();
    private final QueueConnectionFactory factory;
    private volatile QueueConnection connection;
    private final boolean transacted;
    private final int acknowledgeMode;

    private static void drainPool() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("JmsSessionPool draining " + _sessionQueue.size() + " queue sessions");
        }
        for (QueueSession queueSession : _sessionQueue) {
            try {
                queueSession.close();
            }
            catch (Exception exception) {
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    public JmsSessionPool(QueueConnectionFactory queueConnectionFactory, boolean bl, int n) {
        this.factory = queueConnectionFactory;
        this.transacted = bl;
        this.acknowledgeMode = n;
    }

    public final QueueSession take() {
        QueueSession queueSession = _sessionQueue.poll();
        if (queueSession == null) {
            return this.create();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("JmsSessionPool took QueueSession from pool. Remaining: " + _sessionQueue.size() + " queue sessions");
        }
        return queueSession;
    }

    public final void recycle(QueueSession queueSession) {
        _sessionQueue.offer(queueSession);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("JmsSessionPool recycled QueueSession back into pool. Current count: " + _sessionQueue.size() + " queue sessions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueueSession create() {
        try {
            JmsSessionPool jmsSessionPool;
            if (this.connection == null) {
                jmsSessionPool = this;
                synchronized (jmsSessionPool) {
                    if (this.connection == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("JmsSessionPool creating QueueConnection to populate the pool");
                        }
                        this.connection = this.factory.createQueueConnection();
                    }
                }
            }
            JmsSessionPool jmsSessionPool2 = this;
            synchronized (jmsSessionPool2) {
                jmsSessionPool = this.connection.createQueueSession(this.transacted, this.acknowledgeMode);
                this.connection.start();
            }
            return jmsSessionPool;
        }
        catch (JMSException jMSException) {
            throw new WebServiceException("Could not create JMS resource: " + (Object)((Object)jMSException));
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("JmsSessionPool ShutdownHook firing. Killing " + _sessionQueue.size() + " queue sessions");
                }
                JmsSessionPool.drainPool();
            }
        });
    }
}

