/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.internal.wls;

import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import weblogic.ejb.spi.JmsMessageDrivenBean;
import weblogic.jms.extensions.WLSession;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.buffer2.internal.common.BufferingMDB;

public final class BufferingMDB_WLS
extends BufferingMDB
implements JmsMessageDrivenBean {
    private volatile WLSession session = null;

    protected boolean retrySupported() {
        return true;
    }

    public void setSession(Session session) {
        this.session = (WLSession)session;
    }

    protected void setRetryDelay(Message message, String string, long l) {
        block8: {
            try {
                long l2 = BufferManager.instance().getRetryDelay(string, message.getJMSMessageID());
                if (l > 0L) {
                    if (l != l2) {
                        l2 = l;
                        BufferManager.instance().putRetryDelay(string, message.getJMSMessageID(), l2);
                    }
                } else if (message.propertyExists("BEARetryDelay")) {
                    l2 = message.getLongProperty("BEARetryDelay");
                    BufferManager.instance().putRetryDelay(string, message.getJMSMessageID(), l2);
                }
                if (l2 > 0L) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Setting retry delay to " + l2);
                        LOGGER.fine("Old retryDelay=" + this.session.getRedeliveryDelay());
                    }
                    this.session.setRedeliveryDelay(l2 * 1000L);
                }
            }
            catch (JMSException jMSException) {
                if (!LOGGER.isLoggable(Level.FINE)) break block8;
                LOGGER.fine("Could not set retry delay");
                LOGGER.log(Level.FINE, jMSException.toString(), jMSException);
            }
        }
    }
}

