/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer2.spi;

import weblogic.wsee.buffer2.exception.BufferingException;
import weblogic.wsee.buffer2.spi.BufferingProvider;

public class BufferingProviderManager {
    private static volatile BufferingProvider _theBufferingProvider;
    private static String PROVIDER_WLS;
    private static String PROVIDER_J2EE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferingProvider getBufferingProvider() throws BufferingException {
        if (_theBufferingProvider != null) return _theBufferingProvider;
        Class<BufferingProviderManager> clazz = BufferingProviderManager.class;
        synchronized (BufferingProviderManager.class) {
            if (_theBufferingProvider == null) {
                for (App_Server_Platform app_Server_Platform : App_Server_Platform.values()) {
                    try {
                        _theBufferingProvider = app_Server_Platform.getBufferingProvider();
                    }
                    catch (BufferingException bufferingException) {
                        // empty catch block
                    }
                }
            }
            if (_theBufferingProvider != null) return _theBufferingProvider;
            throw new BufferingException("Unable to load BufferingProvider");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferingProvider getBufferingProvider(App_Server_Platform app_Server_Platform) throws BufferingException {
        if (app_Server_Platform == null) {
            throw new BufferingException("Error.  Cannot Load using NULL platform.");
        }
        if (_theBufferingProvider != null) return _theBufferingProvider;
        Class<BufferingProviderManager> clazz = BufferingProviderManager.class;
        synchronized (BufferingProviderManager.class) {
            if (_theBufferingProvider != null) return _theBufferingProvider;
            _theBufferingProvider = app_Server_Platform.getBufferingProvider();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _theBufferingProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBufferingProvider(BufferingProvider bufferingProvider) {
        Class<BufferingProviderManager> clazz = BufferingProviderManager.class;
        synchronized (BufferingProviderManager.class) {
            _theBufferingProvider = bufferingProvider;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static /* synthetic */ String access$000() {
        return PROVIDER_WLS;
    }

    static /* synthetic */ String access$200() {
        return PROVIDER_J2EE;
    }

    static {
        PROVIDER_WLS = "weblogic.wsee.buffer2.provider.wls.BufferingProvider_WLS";
        PROVIDER_J2EE = "weblogic.wsee.buffer2.provider.j2ee.BufferingProvider_J2EE";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum App_Server_Platform {
        WLS("WLS", BufferingProviderManager.access$000()){}
        ,
        J2EE("J2EE", BufferingProviderManager.access$200()){};

        private String name;
        private String providerClassName;

        private App_Server_Platform(String string2, String string3) {
            this.name = string2;
            this.providerClassName = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getProviderClassName() {
            return this.providerClassName;
        }

        public String toString() {
            return this.name;
        }

        BufferingProvider getBufferingProvider() throws BufferingException {
            BufferingProvider bufferingProvider = null;
            try {
                Class<?> clazz = Class.forName(this.providerClassName);
                bufferingProvider = (BufferingProvider)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new BufferingException("Could not load BufferingProvider for App Server Platform '" + this.name + "'");
            }
            return bufferingProvider;
        }
    }
}

