/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.callback.CallbackClientBufferingHandler;
import weblogic.wsee.callback.CallbackUtils;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class CallbackClientBufferingDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(CallbackClientBufferingDeploymentListener.class);
    private static final List BEFORE = Arrays.asList((Object[])new String[]{"SECURITY_HANDLER", "CONNECTION_HANDLER"});
    private static final List AFTER = Arrays.asList((Object[])new String[]{"ASYNC_HANDLER"});

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("CallbackClientBufferingDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (!CallbackUtils.isCallbackService(wsPort)) continue;
            HandlerInfo handlerInfo = new HandlerInfo(CallbackClientBufferingHandler.class, null, null);
            try {
                wsPort.getInternalHandlerList().lenientInsert("CALLBACK_CLIENT_BUFFERING_HANDLER", handlerInfo, AFTER, BEFORE);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Could not insert callback client buffering handler", handlerException);
            }
        }
    }
}

