/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import java.util.Date;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.callback.CallbackClientBufferingData;
import weblogic.wsee.callback.CallbackHandler;
import weblogic.wsee.jws.container.Duration;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Verbose;

public class CallbackClientBufferingHandler
extends CallbackHandler {
    private static final boolean verbose = Verbose.isVerbose(CallbackClientBufferingHandler.class);
    public static final String CALLBACK_CLIENT_BUFFERING_DATA = "weblogic.wsee.callback.client.buffering";
    public static final String CALLBACK_CLIENT_BUFFERING_METHODNAME = "weblogic.wsee.callback.client.methodname";
    public static final String CALLBACK_CLIENT_BUFFERING_ARGS = "weblogic.wsee.callback.client.args";
    public static final String BINDING_TYPE = "weblogic.wsee.binding.type";

    public boolean handleRequest(MessageContext messageContext) {
        assert (messageContext != null);
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        CallbackClientBufferingData callbackClientBufferingData = (CallbackClientBufferingData)messageContext.getProperty(CALLBACK_CLIENT_BUFFERING_DATA);
        if (callbackClientBufferingData == null) {
            return true;
        }
        if (verbose) {
            Verbose.log("[CallbackClientBufferingHandler.handleRequest()] called");
        }
        if (wlMessageContext.getDispatcher().getOperation().getType() != 1 && wlMessageContext.getDispatcher().getOperation().getType() != 3 && !messageContext.containsProperty("weblogic.wsee.async.invoke")) {
            throw new JAXRPCException("Buffering only works with one way messages or asynchronous request/response messages.");
        }
        messageContext.setProperty(BINDING_TYPE, (Object)wlMessageContext.getDispatcher().getWsdlPort().getBinding().getBindingType());
        int n = callbackClientBufferingData.getRetryCount();
        String string = callbackClientBufferingData.getRetryDelay();
        Duration duration = new Duration(string);
        long l = duration.convertToSeconds(new Date());
        if (verbose) {
            Verbose.log("CallbackClientBufferingHandler: buffer to " + callbackClientBufferingData.getTargetURI() + " retryCount = " + n + ", retryDelay = " + l + " seconds.");
        }
        sOAPMessageContext.removeProperty("weblogic.wsee.enclosing.container");
        String string2 = (String)sOAPMessageContext.getProperty("weblogic.wsee.enclosing.jws.serviceuri");
        BufferManager.instance().bufferMessageWithServiceURI(callbackClientBufferingData.getTargetURI(), string2, new SOAPInvokeState(sOAPMessageContext, false), n, l);
        return false;
    }
}

