/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import weblogic.jws.Callback;
import weblogic.jws.MessageBuffer;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.jms.WsClientBufferingErrorMessageListener;
import weblogic.wsee.server.jms.WsClientBufferingMessageListener;
import weblogic.wsee.util.JmsUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class CallbackClientBufferingServerDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(CallbackClientBufferingServerDeploymentListener.class);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("CallbackClientBufferingServerDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            Class clazz = wsPort.getEndpoint().getJwsClass();
            if (clazz == null) continue;
            this.checkBufferedCallback(clazz, wsDeploymentContext);
        }
    }

    private void checkBufferedCallback(Class clazz, WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            if (field.getAnnotation(Callback.class) == null || !field.getType().isInterface()) continue;
            Class<?> clazz2 = field.getType();
            boolean bl = false;
            if (clazz2.getAnnotation(MessageBuffer.class) != null) {
                bl = true;
            } else {
                Method[] methodArray;
                for (Method method : methodArray = clazz2.getMethods()) {
                    if (method.getAnnotation(MessageBuffer.class) == null) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            this.setupBufferedCallback(wsDeploymentContext, ServerUtil.getBufferQueueInfo(clazz2), clazz2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupBufferedCallback(WsDeploymentContext wsDeploymentContext, ServerUtil.QueueInfo queueInfo, Class clazz) throws WsDeploymentException {
        WsClientBufferingMessageListener wsClientBufferingMessageListener = new WsClientBufferingMessageListener();
        String string = wsDeploymentContext.getContextPath() + "/" + wsDeploymentContext.getServiceName() + ":/" + clazz.getName().replace(".", "/");
        BufferManager bufferManager = BufferManager.instance();
        Object object = bufferManager;
        synchronized (object) {
            if (bufferManager.getMessageListener(string) != null) {
                return;
            }
            bufferManager.addMessageListener(string, wsClientBufferingMessageListener);
        }
        wsDeploymentContext.addBufferTargetURI(string);
        if (queueInfo.getQueueName() != null) {
            bufferManager.setTargetQueue(string, queueInfo);
        }
        object = new String("ASYNC_URI = '" + string + "'");
        AsyncUtil.setupDynamicMDB(wsDeploymentContext, (String)object, queueInfo.getQueueName(), queueInfo.getMdbRunAsPrincipalName(), "weblogic.wsee.server.jms.MdbWS", 0);
        this.setupErrorDestination(wsDeploymentContext, queueInfo, string);
    }

    private void setupErrorDestination(WsDeploymentContext wsDeploymentContext, ServerUtil.QueueInfo queueInfo, String string) throws WsDeploymentException {
        try {
            String string2 = JmsUtil.getErrorDestinationJNDI(queueInfo.getQueueName());
            if (string2 != null) {
                WsClientBufferingErrorMessageListener wsClientBufferingErrorMessageListener = new WsClientBufferingErrorMessageListener();
                BufferManager bufferManager = BufferManager.instance();
                bufferManager.addErrorListener(string, wsClientBufferingErrorMessageListener);
                String string3 = new String("ASYNC_URI = '" + string + "'");
                AsyncUtil.setupDynamicMDB(wsDeploymentContext, string3, string2, queueInfo.getMdbRunAsPrincipalName(), "weblogic.wsee.server.jms.MdbErrorWS", 0);
            }
        }
        catch (InvocationException invocationException) {
            if (verbose) {
                Verbose.logException(invocationException);
            }
            throw new WsDeploymentException(invocationException.getMessage(), invocationException);
        }
    }
}

