/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import weblogic.apache.xerces.impl.dv.util.Base64;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.connection.transport.https.HttpsTransportInfo;
import weblogic.wsee.security.bst.ClientBSTCredentialProvider;
import weblogic.wsee.security.bst.StubPropertyBSTCredProv;
import weblogic.wsee.security.unt.ClientUNTCredentialProvider;
import weblogic.xml.crypto.wss.provider.CredentialProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackCredentials
implements Serializable {
    static final long serialVersionUID = 3L;
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static ClearOrEncryptedService _coes;
    private static final String DEFAULT_KeyStoreType = "JKS";
    private String _keyStoreLocation;
    private String _keyStorePassword;
    private String _keyStoreType = "JKS";
    private String _trustStoreLocation;
    private String _trustStorePassword;
    private String _trustStoreType = "JKS";
    private String _keyAlias;
    private X509Certificate _serverCert;
    private String _keyPassword;
    private String _password = null;
    private String _username = null;
    private boolean _useClientCerts;

    public void setUsername(String string) {
        this._username = string;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public void setKeystore(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Key store location and password must both be specified in a service control");
        }
        this._keyStoreLocation = string;
        this._keyStorePassword = string2;
        if (string3 != null) {
            this._keyStoreType = string3;
        }
    }

    public void setTruststore(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Trust store location and password must both be specified in a service control");
        }
        this._trustStoreLocation = string;
        this._trustStorePassword = string2;
        if (string3 != null) {
            this._trustStoreType = string3;
        }
    }

    public void setClientCert(String string, String string2) {
        this._keyAlias = string;
        this._keyPassword = string2;
    }

    public void setServerCert(X509Certificate x509Certificate) {
        this._serverCert = x509Certificate;
    }

    public void useClientKeySSL(boolean bl) {
        this._useClientCerts = bl;
    }

    public boolean useClientKeySSL() {
        return this._useClientCerts;
    }

    public String getHttpBasicAuth() {
        String string = this._username + ":" + this._password;
        byte[] byArray = Base64.encode((byte[])string.getBytes());
        return "Basic " + new String(byArray);
    }

    public List<CredentialProvider> getMessageCredentialProviders() {
        ArrayList<CredentialProvider> arrayList = new ArrayList<CredentialProvider>();
        if (this._password != null || this._username != null) {
            arrayList.add(new ClientUNTCredentialProvider(this._username != null ? this._username.getBytes() : null, this._password != null ? this._password.getBytes() : null));
        }
        try {
            if (this._keyStoreLocation != null && this._keyStorePassword != null && this._keyAlias != null) {
                arrayList.add(new ClientBSTCredentialProvider(this._keyStoreLocation, this._keyStorePassword, this._keyAlias, this._keyPassword, this._keyStoreType, this._serverCert));
            } else if (this._serverCert != null) {
                arrayList.add(new StubPropertyBSTCredProv(this._serverCert, this._serverCert));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error processing keystore.", exception);
        }
        return arrayList;
    }

    HttpsTransportInfo getHttpsTransportInfo() {
        KeyStore keyStore;
        Object object;
        if (!this._useClientCerts) {
            return null;
        }
        HttpsTransportInfo httpsTransportInfo = new HttpsTransportInfo();
        httpsTransportInfo.setTrustManagers(new X509TrustManager[]{new RelaxedX509TrustManager()});
        if (this._keyStoreLocation != null && this._keyStorePassword != null) {
            try {
                object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyStore = KeyStore.getInstance(this._keyStoreType);
                keyStore.load(new FileInputStream(this._keyStoreLocation), this._keyStorePassword.toCharArray());
                String string = this._keyPassword;
                if (string == null) {
                    string = this._keyStorePassword;
                }
                if (this._keyAlias == null) {
                    ((KeyManagerFactory)object).init(keyStore, string.toCharArray());
                } else {
                    Certificate[] certificateArray = keyStore.getCertificateChain(this._keyAlias);
                    if (certificateArray == null) {
                        throw new SecurityException("No such key with alias '" + this._keyAlias + "' in key-store '" + this._keyStoreLocation + "'");
                    }
                    Key key = keyStore.getKey(this._keyAlias, string.toCharArray());
                    KeyStore keyStore2 = KeyStore.getInstance(this._keyStoreType);
                    keyStore2.load(null, this._keyStorePassword.toCharArray());
                    keyStore2.setKeyEntry(this._keyAlias, key, string.toCharArray(), certificateArray);
                    ((KeyManagerFactory)object).init(keyStore2, string.toCharArray());
                }
                httpsTransportInfo.setKeyManagers(((KeyManagerFactory)object).getKeyManagers());
            }
            catch (Exception exception) {
                throw new SecurityException("Cannot load key-store '" + this._keyStoreLocation + "' " + exception);
            }
        }
        if (this._trustStoreLocation != null && this._trustStorePassword != null) {
            try {
                object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                keyStore = KeyStore.getInstance(this._trustStoreType);
                keyStore.load(new FileInputStream(this._trustStoreLocation), this._trustStorePassword.toCharArray());
                ((TrustManagerFactory)object).init(keyStore);
                httpsTransportInfo.setTrustManagers(((TrustManagerFactory)object).getTrustManagers());
            }
            catch (Exception exception) {
                throw new SecurityException("Cannot load trust-store '" + this._trustStoreLocation + "' " + exception);
            }
        }
        return httpsTransportInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        CallbackCredentials callbackCredentials = this;
        synchronized (callbackCredentials) {
            String string = this._keyStoreLocation;
            String string2 = this._keyStorePassword;
            String string3 = this._keyStoreType;
            String string4 = this._trustStoreLocation;
            String string5 = this._trustStorePassword;
            String string6 = this._trustStoreType;
            String string7 = this._password;
            String string8 = this._username;
            String string9 = this._keyAlias;
            String string10 = this._keyPassword;
            if (this._keyStoreLocation != null) {
                this._keyStoreLocation = _coes.encrypt(this._keyStoreLocation);
            }
            if (this._keyStorePassword != null) {
                this._keyStorePassword = _coes.encrypt(this._keyStorePassword);
            }
            if (this._keyStoreType != null) {
                this._keyStoreType = _coes.encrypt(this._keyStoreType);
            }
            if (this._trustStoreLocation != null) {
                this._trustStoreLocation = _coes.encrypt(this._trustStoreLocation);
            }
            if (this._trustStorePassword != null) {
                this._trustStorePassword = _coes.encrypt(this._trustStorePassword);
            }
            if (this._trustStoreType != null) {
                this._trustStoreType = _coes.encrypt(this._trustStoreType);
            }
            if (this._password != null) {
                this._password = _coes.encrypt(this._password);
            }
            if (this._username != null) {
                this._username = _coes.encrypt(this._username);
            }
            if (this._keyAlias != null) {
                this._keyAlias = _coes.encrypt(this._keyAlias);
            }
            if (this._keyPassword != null) {
                this._keyPassword = _coes.encrypt(this._keyPassword);
            }
            objectOutputStream.defaultWriteObject();
            this._keyStoreLocation = string;
            this._keyStorePassword = string2;
            this._keyStoreType = string3;
            this._trustStoreLocation = string4;
            this._trustStorePassword = string5;
            this._trustStoreType = string6;
            this._password = string7;
            this._username = string8;
            this._keyAlias = string9;
            this._keyPassword = string10;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this._keyStoreLocation != null) {
            this._keyStoreLocation = _coes.decrypt(this._keyStoreLocation);
        }
        if (this._keyStoreType != null) {
            this._keyStoreType = _coes.decrypt(this._keyStoreType);
        }
        if (this._keyStorePassword != null) {
            this._keyStorePassword = _coes.decrypt(this._keyStorePassword);
        }
        if (this._trustStoreLocation != null) {
            this._trustStoreLocation = _coes.decrypt(this._trustStoreLocation);
        }
        if (this._trustStoreType != null) {
            this._trustStoreType = _coes.decrypt(this._trustStoreType);
        }
        if (this._trustStorePassword != null) {
            this._trustStorePassword = _coes.decrypt(this._trustStorePassword);
        }
        if (this._password != null) {
            this._password = _coes.decrypt(this._password);
        }
        if (this._username != null) {
            this._username = _coes.decrypt(this._username);
        }
        if (this._keyPassword != null) {
            this._keyPassword = _coes.decrypt(this._keyPassword);
        }
        if (this._keyAlias != null) {
            this._keyAlias = _coes.decrypt(this._keyAlias);
        }
    }

    static {
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelID, (AuthenticatedSubject)kernelID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    EncryptionService encryptionService = SerializedSystemIni.getEncryptionService();
                    _coes = new ClearOrEncryptedService(encryptionService);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static class RelaxedX509TrustManager
    implements X509TrustManager {
        private RelaxedX509TrustManager() {
        }

        public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }
}

