/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.w3c.dom.Element;
import weblogic.wsee.callback.CallbackConstants;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class CallbackInfoHeader
extends MsgHeader {
    private static final long serialVersionUID = 3753830341027224049L;
    private String stubName;
    private String serviceURI;
    private String appVersion;
    public static final QName NAME = CallbackConstants.CALLBACK_INFO_HEADER;
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private boolean roleRequired = false;

    public QName getName() {
        return NAME;
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public String getStubName() {
        return this.stubName;
    }

    public void setStubName(String string) {
        this.stubName = string;
    }

    public void setServiceURI(String string) {
        this.serviceURI = string;
    }

    public String getServiceURI() {
        return this.serviceURI;
    }

    public boolean isRoleRequired() {
        return this.roleRequired;
    }

    public void setRoleRequired(boolean bl) {
        this.roleRequired = bl;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String string) {
        this.appVersion = string;
    }

    public void write(Element element) throws MsgHeaderException {
        if (this.stubName != null) {
            DOMUtils.addValueNS(element, "http://www.openuri.org/2006/03/callback", "callback:StubName", this.stubName);
        }
        if (this.serviceURI != null) {
            DOMUtils.addValueNS(element, "http://www.openuri.org/2006/03/callback", "callback:ServiceURI", this.serviceURI);
        }
        if (this.appVersion != null) {
            DOMUtils.addValueNS(element, "http://www.openuri.org/2006/03/callback", "callback:AppVersion", this.appVersion);
        }
        if (this.roleRequired) {
            DOMUtils.addValueNS(element, "http://www.openuri.org/2006/03/callback", "callback:RoleRequired", "true");
        }
    }

    public void read(Element element) throws MsgHeaderException {
        try {
            this.stubName = DOMUtils.getOptionalValueByTagNameNS(element, "http://www.openuri.org/2006/03/callback", "StubName");
            this.serviceURI = DOMUtils.getOptionalValueByTagNameNS(element, "http://www.openuri.org/2006/03/callback", "ServiceURI");
            this.appVersion = DOMUtils.getOptionalValueByTagNameNS(element, "http://www.openuri.org/2006/03/callback", "AppVersion");
            String string = DOMUtils.getOptionalValueByTagNameNS(element, "http://www.openuri.org/2006/03/callback", "RoleRequired");
            this.roleRequired = "true".equals(string);
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not read class name", (Throwable)((Object)dOMProcessingException));
        }
    }

    public String convertToWlw81StringForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.stubName == null) {
            throw new JAXRPCException("No stub name found in callback information");
        }
        if (this.serviceURI == null) {
            throw new JAXRPCException("No service URI found in callback information");
        }
        stringBuffer.append("stn=" + this.stubName + ";");
        stringBuffer.append("su=" + this.serviceURI + ";");
        if (this.appVersion != null) {
            stringBuffer.append("av=" + this.appVersion + ";");
        }
        if (this.roleRequired) {
            stringBuffer.append("rr=true");
        }
        return stringBuffer.toString();
    }

    public void parseFromWlw81StringForm(String string) {
        if (string == null) {
            throw new JAXRPCException("Input callback information is null");
        }
        int n = string.indexOf("stn=");
        if (n < 0) {
            throw new JAXRPCException("No stub name found in callback information " + string);
        }
        int n2 = string.indexOf(";", n += "stn=".length());
        if (n2 <= n) {
            throw new JAXRPCException("No stub name value found in callback information " + string);
        }
        this.stubName = string.substring(n, n2);
        n = string.indexOf("su=", n2);
        if (n < 0) {
            throw new JAXRPCException("No service URI found in callback information " + string);
        }
        n2 = string.indexOf(";", n += "su=".length());
        if (n2 <= n) {
            throw new JAXRPCException("No service URI value found in callback information " + string);
        }
        this.serviceURI = string.substring(n, n2);
        n = string.indexOf("av=", n2);
        if (n >= 0) {
            n2 = string.indexOf(";", n += "av=".length());
            if (n2 <= n) {
                throw new JAXRPCException("No app version value found in callback information " + string);
            }
            this.appVersion = string.substring(n, n2);
        }
        if ((n = string.indexOf("rr=", n2)) >= 0) {
            n2 = string.indexOf(";", n += "rr=".length());
            if (n2 <= n) {
                throw new JAXRPCException("No role required value found in callback information " + string);
            }
            this.roleRequired = "true".equals(string.substring(n, n2));
        }
    }
}

