/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.callback.CallbackServiceHandler;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class CallbackServiceDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(CallbackServiceDeploymentListener.class);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        WsService wsService = wsDeploymentContext.getWsService();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            HandlerList handlerList = wsPort.getInternalHandlerList();
            if (verbose) {
                Verbose.log("Before CallbackServiceDeploymentListener");
                Verbose.log(handlerList);
            }
            HandlerInfo handlerInfo = new HandlerInfo(CallbackServiceHandler.class, new HashMap(), null);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("ONE_WAY_HANDLER");
            arrayList.add("PRE_INVOKE_HANDLER");
            try {
                handlerList.insert("CALLBACK_SERVICE_HANDLER", handlerInfo, arrayList2, arrayList);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Failed to register handler", handlerException);
            }
            if (!verbose) continue;
            Verbose.log("After CallbackServiceDeploymentListener");
            Verbose.log(handlerList);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

