/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import java.security.AccessController;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.callback.CallbackHandler;
import weblogic.wsee.callback.CallbackInfoHeader;
import weblogic.wsee.cluster.ClusterUtil;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.connection.transport.servlet.HttpServerTransport;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;

public class CallbackServiceHandler
extends CallbackHandler {
    private static final boolean verbose = Verbose.isVerbose(CallbackServiceHandler.class);
    public static final String SECURITY_REALM = "__SECURITY_REALM__";
    private String securityRealm = null;

    public void init(HandlerInfo handlerInfo) {
        Map map = handlerInfo.getHandlerConfig();
        this.securityRealm = (String)map.get(SECURITY_REALM);
    }

    public boolean handleRequest(MessageContext messageContext) {
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        SoapMessageContext soapMessageContext = (SoapMessageContext)wlMessageContext;
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        CallbackInfoHeader callbackInfoHeader = (CallbackInfoHeader)msgHeaders.getHeader(CallbackInfoHeader.TYPE);
        if (callbackInfoHeader != null) {
            String string;
            if (verbose) {
                Verbose.log("Callback message received");
            }
            if ((string = callbackInfoHeader.getAppVersion()) != null) {
                if (verbose) {
                    Verbose.log("Setting version to send callback to " + string);
                }
                wlMessageContext.setProperty("weblogic.wsee.callback.appversion", string);
            } else if (verbose) {
                Verbose.log("No app version in callback info header");
            }
            if (callbackInfoHeader.isRoleRequired()) {
                AuthenticatedSubject authenticatedSubject;
                if (verbose) {
                    Verbose.log("Callback requires roles");
                }
                if (SubjectUtils.isUserAnonymous((AuthenticatedSubject)(authenticatedSubject = ClusterUtil.getSubject((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction()))))) {
                    if (verbose) {
                        Verbose.log("Anonymous user, will request authentication information");
                    }
                    this.setAuthFault(soapMessageContext, "Role information required for callback.");
                }
            }
        }
        return true;
    }

    private void setAuthFault(SoapMessageContext soapMessageContext, String string) {
        HttpServletResponse httpServletResponse;
        Transport transport = soapMessageContext.getDispatcher().getConnection().getTransport();
        if (transport instanceof HttpServerTransport) {
            httpServletResponse = ((HttpServerTransport)transport).getResponse();
            httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"" + this.securityRealm + "\"");
        }
        try {
            soapMessageContext.setProperty("weblogic.wsee.AuthRequired", "true");
            httpServletResponse = WLMessageFactory.getInstance().getMessageFactory(soapMessageContext.isSoap12()).createMessage();
            SOAPFault sOAPFault = httpServletResponse.getSOAPPart().getEnvelope().getBody().addFault();
            sOAPFault.setFaultCode("env:Client.Authentication");
            sOAPFault.setFaultString(string);
            soapMessageContext.setMessage((SOAPMessage)httpServletResponse);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException("Unable to send error", (Throwable)sOAPException);
        }
    }

    public boolean handleResponse(MessageContext messageContext) {
        return true;
    }
}

