/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.Remote;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jws.Oneway;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Element;
import weblogic.jws.MessageBuffer;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.callback.CallbackClientBufferingData;
import weblogic.wsee.callback.CallbackCredentials;
import weblogic.wsee.connection.transport.https.HttpsTransportInfo;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.jaxrpc.StubImpl;
import weblogic.wsee.jws.CallbackInterface;
import weblogic.wsee.jws.Protocol;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.ControlAPIUtil;
import weblogic.wsee.ws.dispatch.server.ServletEndpointContextImpl;

public class CallbackStubImpl
implements CallbackInterface,
InvocationHandler,
Serializable {
    static final long serialVersionUID = 1L;
    String stubId = null;
    private Stub stub = null;
    private Class callbackInterface;
    static Map<Key, Converter> converters;
    private static final String JAX_RPC_ENDPOINT_ADDRESS_PROPERTY = "javax.xml.rpc.service.endpoint.address";
    private static final String TRANSPORT_INFO_PROPERTY = "weblogic.wsee.connection.transportinfo";
    CallbackCredentials _credentials = null;
    String _originalEndpointAddress = null;
    String _endpointAddress = null;
    boolean _originalEndpointAddresSet = false;
    Integer _originalTimeout = null;
    boolean _originalTimeoutSet = false;
    private static final String DEFAULT_KeyStoreType = "JKS";
    private static final String UPGRADE_81_PROPERTY = "weblogic.wsee.WLW81Upgrade";

    public static Stub newInstance(Stub stub, Class clazz) {
        Class[] classArray = new Class[]{Stub.class, clazz};
        CallbackStubImpl callbackStubImpl = new CallbackStubImpl(stub, clazz);
        return (Stub)Proxy.newProxyInstance(stub.getClass().getClassLoader(), classArray, (InvocationHandler)callbackStubImpl);
    }

    public CallbackStubImpl(Stub stub, Class clazz) {
        this.stub = stub;
        this.stubId = "Stub Created At: " + new Date();
        this.callbackInterface = clazz;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.getDeclaringClass().isAssignableFrom(CallbackStubImpl.class)) {
            try {
                Method method2 = CallbackStubImpl.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (method2 != null) {
                    return method2.invoke((Object)this, objectArray);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        this.invokePrep();
        return this.invokeStub(object, method, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeStub(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        if (!method.getDeclaringClass().isAssignableFrom(this.callbackInterface)) {
            try {
                return method.invoke((Object)this.stub, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        Class clazz = this.getPortTypeInterface();
        assert (clazz != null);
        Method method2 = this.getCallBackMethod(clazz, method);
        if (method2 == null) {
            throw new NoSuchMethodException(method.toString() + " is not found in the " + this.callbackInterface);
        }
        Class<?>[] classArray = method.getParameterTypes();
        Class<?>[] classArray2 = method2.getParameterTypes();
        Object[] objectArray2 = null;
        assert (classArray.length == classArray2.length);
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i].isAssignableFrom(classArray[i])) continue;
            int n = 0;
            int n2 = 0;
            while (classArray2[i].isArray()) {
                classArray2[i] = classArray2[i].getComponentType();
                ++n;
            }
            while (classArray[i].isArray()) {
                classArray[i] = classArray[i].getComponentType();
                ++n2;
            }
            if (n != n2) {
                throw new NoSuchMethodException(method.toString() + " is not found in the " + this.callbackInterface);
            }
            Converter converter = converters.get(new Key(classArray[i], classArray2[i]));
            if (converter == null) {
                throw new NoSuchMethodException(method.toString() + " is not found in the " + this.callbackInterface);
            }
            if (n2 > 0) {
                converter = new ArrayConverter(converter, method2.getParameterTypes()[i]);
            }
            if (objectArray2 == null) {
                objectArray2 = new Object[objectArray.length];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            }
            objectArray2[i] = converter.getValue(objectArray2[i]);
        }
        if (objectArray2 == null) {
            objectArray2 = objectArray;
        }
        if (this.thereIsNoTargetAndFromNonConversationalJws()) {
            String string = "JWS is not conversational, but tried to perform a callback. If asynchronous callbacks are needed, you will need to make this a conversational web service with start, continue, and finish methods.";
            throw new RuntimeException(string);
        }
        if (this.potentialDeadlock(method)) {
            this.printDeadlockWarning();
        }
        this.processBuffering(this.stub, method, objectArray);
        try {
            object2 = method2.invoke((Object)this.stub, objectArray2);
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (this.stub instanceof StubImpl) {
                ((StubImpl)this.stub)._removeProperty("weblogic.wsee.callback.client.buffering");
            }
            ((StubImpl)this.stub)._removeProperty("weblogic.wsee.callback.client.methodname");
            ((StubImpl)this.stub)._removeProperty("weblogic.wsee.callback.client.args");
            throw throwable;
        }
        if (this.stub instanceof StubImpl) {
            ((StubImpl)this.stub)._removeProperty("weblogic.wsee.callback.client.buffering");
        }
        ((StubImpl)this.stub)._removeProperty("weblogic.wsee.callback.client.methodname");
        ((StubImpl)this.stub)._removeProperty("weblogic.wsee.callback.client.args");
        return object2;
    }

    private Method getCallBackMethod(Class clazz, Method method) {
        Method[] methodArray;
        for (Method method2 : methodArray = clazz.getDeclaredMethods()) {
            if (!method2.getName().equals(method.getName())) continue;
            return method2;
        }
        return null;
    }

    private Class getPortTypeInterface() {
        Class<?>[] classArray;
        Class<?> clazz = null;
        for (Class<?> clazz2 : classArray = this.stub.getClass().getInterfaces()) {
            if (!Remote.class.isAssignableFrom(clazz2)) continue;
            clazz = clazz2;
            break;
        }
        return clazz;
    }

    private void processBuffering(Stub stub, Method method, Object[] objectArray) {
        MessageBuffer messageBuffer = this.getMessageBuffer(method);
        if (messageBuffer == null) {
            return;
        }
        boolean bl = true;
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object instanceof Serializable) continue;
                System.err.println("Error reporting will not work for callback MessageBuffer: not all arguments are serializable");
                bl = false;
                break;
            }
        }
        if (bl) {
            stub._setProperty("weblogic.wsee.callback.client.methodname", (Object)method.getName());
            stub._setProperty("weblogic.wsee.callback.client.args", (Object)objectArray);
        }
        CallbackClientBufferingData callbackClientBufferingData = new CallbackClientBufferingData();
        callbackClientBufferingData.setRetryCount(messageBuffer.retryCount());
        callbackClientBufferingData.setRetryDelay(messageBuffer.retryDelay());
        callbackClientBufferingData.setTargetURI((String)stub._getProperty("weblogic.wsee.enclosing.jws.contextpath") + "/" + (String)stub._getProperty("weblogic.wsee.enclosing.jws.servicename") + ":/" + method.getDeclaringClass().getName().replace(".", "/"));
        stub._setProperty("weblogic.wsee.callback.client.buffering", (Object)callbackClientBufferingData);
    }

    private MessageBuffer getMessageBuffer(Method method) {
        MessageBuffer messageBuffer = method.getAnnotation(MessageBuffer.class);
        if (messageBuffer == null) {
            messageBuffer = method.getDeclaringClass().getAnnotation(MessageBuffer.class);
        }
        return messageBuffer;
    }

    private boolean thereIsNoTargetAndFromNonConversationalJws() {
        if (null == this.stub._getProperty("weblogic.wsee.addressing.Target")) {
            MessageContext messageContext = ServletEndpointContextImpl.getMessageContextStatic();
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            String string = (String)wlMessageContext.getProperty(JAX_RPC_ENDPOINT_ADDRESS_PROPERTY);
            return null == string;
        }
        return false;
    }

    private void printDeadlockWarning() {
        System.err.println("===========================");
        System.err.println("Potential deadlock detected: you should not invoke a synchronous, conversational callback within a blocking jws method.  You can fix this by making either the jws method or the callback buffered.");
        System.err.println("===========================");
    }

    private boolean potentialDeadlock(Method method) {
        Oneway oneway = method.getAnnotation(Oneway.class);
        MessageBuffer messageBuffer = this.getMessageBuffer(method);
        if (oneway == null && messageBuffer == null) {
            MessageContext messageContext = ServletEndpointContextImpl.getMessageContextStatic();
            if (messageContext == null) {
                return false;
            }
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            if (wlMessageContext.getDispatcher().getOperation().getType() == 1 || wlMessageContext.getDispatcher().getOperation().getType() == 3 || wlMessageContext.getProperty("weblogic.wsee.reply.anonymous") == null || wlMessageContext.containsProperty("weblogic.wsee.handler.wlw81BufferCompatFlat")) {
                return false;
            }
            EndpointReference endpointReference = (EndpointReference)this.stub._getProperty("weblogic.wsee.addressing.Target");
            if (endpointReference != null) {
                Iterator iterator;
                if (endpointReference.getReferenceParameters() != null) {
                    iterator = endpointReference.getReferenceParameters().listHeaders();
                    while (iterator.hasNext()) {
                        if (!(iterator.next() instanceof ContinueHeader)) continue;
                        return true;
                    }
                }
                if (endpointReference.getReferenceProperties() != null) {
                    iterator = endpointReference.getReferenceProperties().listHeaders();
                    while (iterator.hasNext()) {
                        if (!(iterator.next() instanceof ContinueHeader)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void invokePrep() {
        if (this._credentials != null) {
            HttpsTransportInfo httpsTransportInfo;
            String string;
            String string2 = this._credentials.getUsername();
            if (string2 != null) {
                this.stub._setProperty("javax.xml.rpc.security.auth.username", (Object)string2);
            }
            if ((string = this._credentials.getPassword()) != null) {
                this.stub._setProperty("javax.xml.rpc.security.auth.password", (Object)string);
            }
            if ((httpsTransportInfo = this._credentials.getHttpsTransportInfo()) != null) {
                this.stub._setProperty(TRANSPORT_INFO_PROPERTY, (Object)httpsTransportInfo);
            }
        }
        this.stub._setProperty(UPGRADE_81_PROPERTY, (Object)"true");
    }

    public Element[] getInputHeaders() {
        return ControlAPIUtil.getInputHeaders(this.stub);
    }

    public void setOutputHeaders(Element[] elementArray) {
        ControlAPIUtil.setOutputHeaders(this.stub, elementArray);
    }

    public void setConversationID(String string) {
        this.stub._setProperty("weblogic.wsee.conversation.ConversationId", (Object)string);
    }

    public String getConversationID() {
        String string = (String)this.stub._getProperty("weblogic.wsee.conversation.ConversationId");
        if (string == null) {
            Map map = (Map)this.stub._getProperty("weblogic.wsee.invoke_properties");
            if (map == null) {
                return null;
            }
            EndpointReference endpointReference = (EndpointReference)map.get("weblogic.wsee.addressing.Target");
            if (endpointReference == null) {
                return null;
            }
            MsgHeaders msgHeaders = endpointReference.getReferenceParameters();
            if (msgHeaders == null) {
                return null;
            }
            ContinueHeader continueHeader = (ContinueHeader)msgHeaders.getHeader(ContinueHeader.TYPE);
            if (continueHeader == null) {
                return null;
            }
            string = continueHeader.getConversationId();
        }
        return string;
    }

    public void setTimeout(int n) {
        if (n < 0) {
            n = 0;
        }
        if (!this._originalTimeoutSet) {
            this._originalTimeoutSet = true;
            this._originalTimeout = (Integer)this.stub._getProperty("weblogic.wsee.transport.read.timeout");
        }
        this.stub._setProperty("weblogic.wsee.transport.read.timeout", (Object)new Integer(n));
    }

    public int getTimeout() {
        Integer n = (Integer)this.stub._getProperty("weblogic.wsee.transport.read.timeout");
        if (n != null) {
            return n;
        }
        return -1;
    }

    public void setEndPoint(URL uRL) {
        if (uRL != null) {
            String string = uRL.toExternalForm();
            this.setEndpointAddress(string);
        } else {
            this.setEndpointAddress(null);
        }
    }

    public URL getEndPoint() {
        String string = this.getEndpointAddress();
        if (string == null) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Invalid URL returned from stub!", malformedURLException);
        }
    }

    public String getEndpointAddress() {
        EndpointReference endpointReference;
        String string = (String)this.stub._getProperty(JAX_RPC_ENDPOINT_ADDRESS_PROPERTY);
        if (string == null && (endpointReference = (EndpointReference)this.stub._getProperty("weblogic.wsee.addressing.Target")) != null) {
            string = endpointReference.getAddress();
        }
        return string;
    }

    public void setEndpointAddress(String string) {
        if (!this._originalEndpointAddresSet) {
            this._originalEndpointAddress = this.getEndpointAddress();
            this._originalEndpointAddresSet = true;
        }
        this.stub._setProperty(JAX_RPC_ENDPOINT_ADDRESS_PROPERTY, (Object)string);
        EndpointReference endpointReference = (EndpointReference)this.stub._getProperty("weblogic.wsee.addressing.Target");
        if (endpointReference != null) {
            endpointReference.setAddress(string);
        }
    }

    public void setUsername(String string) {
        if (this._credentials == null) {
            this._credentials = new CallbackCredentials();
        }
        this._credentials.setUsername(string);
    }

    public void setPassword(String string) {
        if (this._credentials == null) {
            this._credentials = new CallbackCredentials();
        }
        this._credentials.setPassword(string);
    }

    public String getUsername() {
        return this._credentials != null ? this._credentials.getUsername() : null;
    }

    public String getPassword() {
        return this._credentials != null ? this._credentials.getPassword() : null;
    }

    public void setProtocol(Protocol protocol) {
    }

    public Protocol getProtocol() {
        String string = this.getEndpointAddress();
        if (string == null) {
            return null;
        }
        if (string.startsWith("http") || string.startsWith("https")) {
            return Protocol.HTTP_SOAP;
        }
        if (string.startsWith("jms")) {
            return Protocol.JMS_SOAP;
        }
        return null;
    }

    public void useClientKeySSL(boolean bl) {
        if (this._credentials == null) {
            this._credentials = new CallbackCredentials();
        }
        this._credentials.useClientKeySSL(bl);
    }

    public void setKeystore(String string, String string2) {
        this.setKeystore(string, string2, null);
    }

    public void setKeystore(String string, String string2, String string3) {
        if (this._credentials == null) {
            this._credentials = new CallbackCredentials();
        }
        this._credentials.setKeystore(string, string2, string3);
    }

    public void setClientCert(String string, String string2) {
        if (this._credentials == null) {
            this._credentials = new CallbackCredentials();
        }
        this._credentials.setClientCert(string, string2);
    }

    public void reset() {
        this._credentials = null;
        this.stub._setProperty("javax.xml.rpc.security.auth.username", null);
        this.stub._setProperty("javax.xml.rpc.security.auth.password", null);
        this.stub._setProperty(TRANSPORT_INFO_PROPERTY, null);
        if (this._originalEndpointAddresSet) {
            this.stub._setProperty(JAX_RPC_ENDPOINT_ADDRESS_PROPERTY, (Object)this._originalEndpointAddress);
            EndpointReference endpointReference = (EndpointReference)this.stub._getProperty("weblogic.wsee.addressing.Target");
            if (endpointReference != null) {
                endpointReference.setAddress(this._originalEndpointAddress);
            }
        }
        this._originalEndpointAddress = null;
        this._originalEndpointAddresSet = false;
        if (this._originalTimeoutSet) {
            this.stub._setProperty("weblogic.wsee.transport.read.timeout", (Object)this._originalTimeout);
        }
        this._originalTimeout = null;
        this._originalTimeoutSet = false;
        ControlAPIUtil.unsetOutputHeaders(this.stub);
    }

    public void setTruststore(String string, String string2) {
        this.setTruststore(string, string2, null);
    }

    public void setTruststore(String string, String string2, String string3) {
        if (this._credentials == null) {
            this._credentials = new CallbackCredentials();
        }
        this._credentials.setTruststore(string, string2, string3);
    }

    public CallbackCredentials getCallbackCredentials() {
        return this._credentials;
    }

    static {
        Converter[] converterArray;
        converters = new HashMap<Key, Converter>();
        for (Converter converter : converterArray = new Converter[]{new DateConverter(Calendar.class), new DateConverter(GregorianCalendar.class), new GregorianCalendarConverter(Calendar.class), new Obj2StringConverter(Character.class), new Obj2StringConverter(Character.TYPE), new Obj2StringConverter(URI.class), new AutoBoxingConverter(Byte.class, Byte.TYPE, (byte)0), new AutoBoxingConverter(Short.class, Short.TYPE, (short)0), new AutoBoxingConverter(Integer.class, Integer.TYPE), new AutoBoxingConverter(Long.class, Long.TYPE), new AutoBoxingConverter(Float.class, Float.TYPE), new AutoBoxingConverter(Double.class, Double.TYPE), new AutoBoxingConverter(Boolean.class, Boolean.TYPE, false)}) {
            converters.put(converter.getKey(), converter);
        }
    }

    static class Key {
        Class from;
        Class to;

        public Key(Class clazz, Class clazz2) {
            this.from = clazz;
            this.to = clazz2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.from == this.from && this.to == this.to;
            }
            return false;
        }

        public int hashCode() {
            int n = this.from != null ? this.from.hashCode() : 0;
            n = 29 * n + (this.to != null ? this.to.hashCode() : 0);
            return n;
        }
    }

    static class ArrayConverter
    implements Converter {
        private Converter _delegate;
        private Class _to;

        public ArrayConverter(Converter converter, Class clazz) {
            this._delegate = converter;
            this._to = clazz;
        }

        public Object getValue(Object object) {
            return this.convert(object, this._to);
        }

        public Key getKey() {
            return null;
        }

        private Object convert(Object object, Class clazz) {
            if (object == null) {
                return null;
            }
            if ((clazz = clazz.getComponentType()) == null) {
                return this._delegate.getValue(object);
            }
            Object[] objectArray = (Object[])Array.newInstance(clazz, Array.getLength(object));
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.convert(Array.get(object, i), clazz);
            }
            return objectArray;
        }
    }

    static class AutoBoxingConverter
    implements Converter {
        private Class from;
        private Class to;
        private Object defaultValue;

        AutoBoxingConverter(Class clazz, Class clazz2) {
            this(clazz, clazz2, 0);
        }

        AutoBoxingConverter(Class clazz, Class clazz2, Object object) {
            this.from = clazz;
            this.to = clazz2;
            this.defaultValue = object;
        }

        public Object getValue(Object object) {
            if (object == null) {
                return this.defaultValue;
            }
            return object;
        }

        public Key getKey() {
            return new Key(this.from, this.to);
        }
    }

    static class GregorianCalendarConverter
    implements Converter {
        private Class from;

        public GregorianCalendarConverter(Class clazz) {
            this.from = clazz;
        }

        public GregorianCalendar getValue(Object object) {
            return (GregorianCalendar)GregorianCalendar.class.cast(object);
        }

        public Key getKey() {
            return new Key(this.from, GregorianCalendar.class);
        }
    }

    static class DateConverter
    implements Converter {
        private Class to;

        public DateConverter(Class clazz) {
            this.to = clazz;
        }

        public Calendar getValue(Object object) {
            if (object == null) {
                return null;
            }
            assert (object instanceof Date);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime((Date)object);
            return gregorianCalendar;
        }

        public Key getKey() {
            return new Key(Date.class, this.to);
        }
    }

    static class Obj2StringConverter
    implements Converter {
        private Class from;

        Obj2StringConverter(Class clazz) {
            this.from = clazz;
        }

        public String getValue(Object object) {
            return object == null ? null : object.toString();
        }

        public Key getKey() {
            return new Key(this.from, String.class);
        }
    }

    static interface Converter {
        public Object getValue(Object var1);

        public Key getKey();
    }
}

