/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import com.bea.xbean.common.NameUtil;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackUtils {
    private static final String CALLBACK_SERVICE_URI = "/CallbackService.jws";

    public static boolean isCallbackService(WsPort wsPort) {
        if (wsPort == null) {
            return false;
        }
        WsdlPartnerLinkType wsdlPartnerLinkType = (WsdlPartnerLinkType)wsPort.getWsdlPort().getDefinitions().getExtension("PartnerLinkType");
        if (wsdlPartnerLinkType == null) {
            return false;
        }
        QName qName = null;
        try {
            qName = wsdlPartnerLinkType.getPortTypeName("Callback");
        }
        catch (WsdlException wsdlException) {
            wsdlException.printStackTrace();
            return false;
        }
        if (qName == null) {
            return false;
        }
        return qName.equals(wsPort.getWsdlPort().getPortType().getName());
    }

    public static String getServiceUri(QName qName, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('/');
        stringBuilder.append(NameUtil.getClassNameFromQName((QName)qName).replace(".", "/"));
        stringBuilder.append('/');
        stringBuilder.append(string);
        stringBuilder.append(CALLBACK_SERVICE_URI);
        return stringBuilder.toString();
    }

    public static String getCallbackPortName(String string) {
        return string + "Callback";
    }

    public static boolean has81StyleCallback(JsService jsService) {
        WsdlService wsdlService = jsService.getWsdlService();
        for (WsdlPortType wsdlPortType : wsdlService.getPortTypes()) {
            for (WsdlOperation wsdlOperation : wsdlPortType.getOperations().values()) {
                if (wsdlOperation.getType() != 2 && wsdlOperation.getType() != 3) continue;
                return true;
            }
        }
        return false;
    }

    public static String parseSendingSideConvId(String string) {
        if (!string.startsWith("[")) {
            return null;
        }
        int n = string.indexOf("]", 1);
        if (n > 1) {
            return string.substring(1, n);
        }
        return null;
    }

    public static String escapeValueForWlw81ControlCallback(String string) {
        if (string == null) {
            return null;
        }
        return string.replace(";", "\\;");
    }

    public static String unEscapeValueForWlw81ControlCallback(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("\\;", ";");
    }

    public static LinkedHashMap<String, String> keyValuePairsForWlw81ControlsCallbackEncodedConvId(String string) {
        int n;
        int n2;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string != null && (n2 = string.length()) > (n = string.indexOf(93) + 1)) {
            int n3;
            int n4;
            while (n < n2 && n > 0 && (n4 = string.indexOf(61, n)) >= 0 && (n3 = string.indexOf(59, n4)) > n4) {
                String string2 = string.substring(n, n4);
                String string3 = string.substring(n4 + 1, n3);
                linkedHashMap.put(string2, CallbackUtils.unEscapeValueForWlw81ControlCallback(string3));
                n = n3 + 1;
            }
        }
        return linkedHashMap;
    }

    public static String encodeConversationIdForWlw81ControlsCallback(String string, String string2, LinkedHashMap<String, String> linkedHashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || string.equals("")) {
            stringBuffer.append("[]");
        } else {
            ContinueHeader continueHeader = new ContinueHeader(string, string2);
            stringBuffer.append("[");
            stringBuffer.append(continueHeader.convertToWlw81StringForm());
            stringBuffer.append("]");
        }
        for (String string3 : linkedHashMap.keySet()) {
            String string4 = linkedHashMap.get(string3);
            stringBuffer.append(string3);
            stringBuffer.append("=");
            stringBuffer.append(CallbackUtils.escapeValueForWlw81ControlCallback(string4));
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }
}

