/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.callback.CallbackWlw81ClientHandler;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortBuilder;

public class CallbackWlw81ClientDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(CallbackWlw81ClientDeploymentListener.class);
    private static final List BEFORE = Arrays.asList((Object[])new String[]{"SECURITY_HANDLER", "CONVERSATION_HANDLER", "CONNECTION_HANDLER"});
    private static final List AFTER = Arrays.asList((Object[])new String[]{"CODEC_HANDLER"});

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("CallbackWlw81ClientDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (ConversationUtils.isConversational(wsPort) || !this.hasWlw81Operations(wsPort)) continue;
            HandlerInfo handlerInfo = new HandlerInfo(CallbackWlw81ClientHandler.class, null, null);
            try {
                wsPort.getInternalHandlerList().lenientInsert("CALLBACK_WLW81_CLIENT_HANDLER", handlerInfo, AFTER, BEFORE);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Could not insert WLW81 callback client handler", handlerException);
            }
        }
    }

    private boolean hasWlw81Operations(WsPort wsPort) {
        for (WsdlOperationBuilder wsdlOperationBuilder : ((WsdlPortBuilder)wsPort.getWsdlPort()).getPortType().getOperations().values()) {
            if (!wsdlOperationBuilder.isWLW81CallbackOperation()) continue;
            return true;
        }
        return false;
    }
}

