/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback.controls;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.callback.controls.ControlCallbackHandler;
import weblogic.wsee.callback.controls.ControlCallbackTransactionHandler;
import weblogic.wsee.callback.controls.ConversationControlCallbackHandler;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ControlCallbackDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(ControlCallbackDeploymentListener.class);
    private static final List BEFORE = Arrays.asList((Object[])new String[]{"OPERATION_LOOKUP_HANDLER"});
    private static final List AFTER = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER"});

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("ControlCallbackDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            boolean bl = ConversationUtils.isConversational(wsPort);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = wsDeploymentContext.getContextPath();
            if (string != null) {
                hashMap.put("control.callback.context.path", string);
            }
            HandlerInfo handlerInfo = new HandlerInfo(ControlCallbackTransactionHandler.class, null, null);
            HandlerInfo handlerInfo2 = new HandlerInfo(ControlCallbackHandler.class, hashMap, null);
            if (verbose) {
                if (bl) {
                    Verbose.log("Adding ConversationControlCallbackHandler and ControlCallbackHandler for " + wsDeploymentContext.getServiceURIs()[0]);
                } else {
                    Verbose.log("Adding ControlCallbackHandler for " + wsDeploymentContext.getServiceURIs()[0]);
                }
            }
            try {
                int n = wsPort.getInternalHandlerList().insert("CONTROL_CALLBACK_TRANSACTION_HANDLER", handlerInfo, AFTER, BEFORE);
                if (bl) {
                    HandlerInfo handlerInfo3 = new HandlerInfo(ConversationControlCallbackHandler.class, null, null);
                    wsPort.getInternalHandlerList().insert("CONVERSATION_CONTROL_CALLBACK_HANDLER", n + 1, handlerInfo3);
                    wsPort.getInternalHandlerList().insert("CONTROL_CALLBACK_HANDLER", n + 2, handlerInfo2);
                    continue;
                }
                wsPort.getInternalHandlerList().insert("CONTROL_CALLBACK_HANDLER", n + 1, handlerInfo2);
            }
            catch (HandlerException handlerException) {
                if (bl) {
                    throw new WsDeploymentException("Could not insert ControlCallbackHandler or ConversationalControlCallbackHandler", handlerException);
                }
                throw new WsDeploymentException("Could not insert ControlCallbackHandler", handlerException);
            }
        }
    }
}

