/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback.controls;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.jws.wlw.WLWServiceControlCallbackJWS;
import weblogic.wsee.callback.controls.Wlw81ControlCallbackHeaderTranslationHandler;
import weblogic.wsee.cluster.ForwardingHandler;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ControlCallbackJwsDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(ControlCallbackJwsDeploymentListener.class);
    private static final List HANDLER_BEFORE = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER"});
    private static final List HANDLER_AFTER = Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER", "SECURITY_HANDLER"});

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("ControlCallbackJwsDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            Class clazz = wsPort.getEndpoint().getJwsClass();
            if (clazz == null || !this.isCallbackJws(clazz) || wsPort.getInternalHandlerList().contains("FORWARDING_HANDLER")) continue;
            HandlerInfo handlerInfo = new HandlerInfo(ForwardingHandler.class, new HashMap(), null);
            HandlerInfo handlerInfo2 = new HandlerInfo(Wlw81ControlCallbackHeaderTranslationHandler.class, new HashMap(), null);
            try {
                if (verbose) {
                    try {
                        Verbose.log("Adding ForwardingHandler for " + wsPort.getWsdlPort().getPortAddress().getServiceuri());
                    }
                    catch (Exception exception) {
                        Verbose.log("Adding ForwardingHandler for " + wsDeploymentContext.getServiceURIs()[0]);
                    }
                }
                int n = wsPort.getInternalHandlerList().lenientInsert("WLW81_CONTROL_CALLBACK_TRANSLATION_HANDLER", handlerInfo2, HANDLER_AFTER, HANDLER_BEFORE);
                wsPort.getInternalHandlerList().insert("FORWARDING_HANDLER", n + 1, handlerInfo);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Could not insert ForwardingHandler", handlerException);
            }
        }
    }

    private boolean isCallbackJws(Class clazz) {
        return clazz.getAnnotation(WLWServiceControlCallbackJWS.class) != null;
    }
}

