/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback.controls;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.transaction.TransactionHelper;
import weblogic.wsee.callback.controls.ControlCallbackData;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlCallbackTransactionHandler
extends GenericHandler
implements WLHandler {
    private static final String SAVED_TXN = "com.bea.workshop.controlcallback.savedtxn";
    private static final String USER_TXN = "com.bea.workshop.controlcallback.usertxn";
    private static boolean verbose = Verbose.isVerbose(ControlCallbackTransactionHandler.class);
    private static final String TRANSACTION_SEETING_REQUIRED = "Required";
    private static final String TRANSATION_SETTING_REQUIRES_NEW = "RequiresNew";

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        Object object = wlMessageContext.getProperty("weblogic.wsee.callback.controls.ControlCallbackData");
        if (object == null) {
            return true;
        }
        try {
            this.setUpWLWTransaction(wlMessageContext, (ControlCallbackData)object);
        }
        catch (RuntimeException runtimeException) {
            wlMessageContext.setProperty("weblogic.wsee.local.invoke.throwable", runtimeException);
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            Verbose.log((Object)"Unable to start transaction for control callback", throwable);
            wlMessageContext.setProperty("weblogic.wsee.local.invoke.throwable", throwable);
            throw new JAXRPCException(throwable);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        try {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            Object object = wlMessageContext.getProperty("weblogic.wsee.callback.controls.ControlCallbackData");
            if (object == null) {
                return true;
            }
            this.handleEndTxn(wlMessageContext);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            Verbose.log((Object)"Unable to finish transaction for control callback", throwable);
            throw new JAXRPCException(throwable);
        }
        return true;
    }

    @Override
    public boolean handleClosure(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    private void setUpWLWTransaction(WlMessageContext wlMessageContext, ControlCallbackData controlCallbackData) throws Exception {
        Object object;
        Object object2;
        Method[] methodArray;
        Object object3 = controlCallbackData.getEventRef();
        WsPort wsPort = WsRegistry.instance().lookup(controlCallbackData.getServiceUri());
        Class clazz = wsPort.getEndpoint().getJwsClass();
        Class<?> clazz2 = this.getEventHandlerClass();
        Class<?> clazz3 = this.getEventRefClass();
        Method method = null;
        Class clazz4 = null;
        for (Method method2 : methodArray = clazz.getMethods()) {
            if (!method2.isAnnotationPresent(clazz2)) continue;
            object2 = method2.getAnnotation(clazz2);
            object = object2.getClass().getMethod("eventSet", new Class[0]);
            clazz4 = (Class)((Method)object).invoke(object2, new Object[0]);
            Method method3 = object2.getClass().getMethod("eventName", new Class[0]);
            String string = (String)method3.invoke(object2, new Object[0]);
            Method method4 = clazz4.getMethod(string, method2.getParameterTypes());
            Constructor<?> constructor = clazz3.getConstructor(Method.class);
            Object obj = constructor.newInstance(method4);
            if (!object3.equals(obj)) continue;
            method = method4;
            break;
        }
        if (method != null) {
            Method method5;
            Object object4;
            Class<?> clazz5 = this.getTxnAttributeClass();
            Object obj = method.getAnnotation(clazz5);
            if (obj == null) {
                Class<?> method4 = this.getControlInf(clazz4);
                if (method4 != null) {
                    obj = method4.getAnnotation(clazz5);
                }
                if (obj == null) {
                    return;
                }
            }
            if (((String)(object = (String)((Method)(object2 = (object4 = (method5 = obj.getClass().getMethod("value", new Class[0])).invoke(obj, new Object[0])).getClass().getMethod("value", new Class[0]))).invoke(object4, new Object[0]))).equals(TRANSACTION_SEETING_REQUIRED) || ((String)object).equals(TRANSATION_SETTING_REQUIRES_NEW)) {
                this.handleStartTxn(wlMessageContext, ((String)object).equals(TRANSATION_SETTING_REQUIRES_NEW));
            }
            if (verbose) {
                Verbose.say("WLW Transaction setting for callback is " + (String)object);
            }
        }
    }

    private void handleStartTxn(WlMessageContext wlMessageContext, boolean bl) throws Exception {
        int n = 6;
        Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
        if (transaction != null) {
            if (bl) {
                Transaction transaction2 = TransactionHelper.getTransactionHelper().getTransactionManager().suspend();
                wlMessageContext.setProperty(SAVED_TXN, transaction2);
                ControlCallbackTransactionHandler.beginTxn(wlMessageContext);
                return;
            }
            n = transaction.getStatus();
        }
        if (transaction == null || n != 0) {
            ControlCallbackTransactionHandler.beginTxn(wlMessageContext);
        }
    }

    private static void beginTxn(WlMessageContext wlMessageContext) throws Exception {
        UserTransaction userTransaction = TransactionHelper.getTransactionHelper().getUserTransaction();
        userTransaction.begin();
        wlMessageContext.setProperty(USER_TXN, userTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEndTxn(WlMessageContext wlMessageContext) throws Exception {
        try {
            UserTransaction userTransaction = (UserTransaction)wlMessageContext.getProperty(USER_TXN);
            if (userTransaction == null) {
                return;
            }
            int n = userTransaction.getStatus();
            if (n == 1) {
                userTransaction.rollback();
            } else if (n != 4 && n != 9) {
                userTransaction.commit();
            }
        }
        finally {
            Transaction transaction = (Transaction)wlMessageContext.getProperty(SAVED_TXN);
            if (transaction != null) {
                TransactionHelper.getTransactionHelper().getTransactionManager().resume(transaction);
            }
            wlMessageContext.removeProperty(USER_TXN);
            wlMessageContext.removeProperty(SAVED_TXN);
        }
    }

    private Class<?> getEventHandlerClass() throws ClassNotFoundException {
        return this.getContextClassLoader().loadClass("org.apache.beehive.controls.api.events.EventHandler");
    }

    private Class<?> getEventRefClass() throws ClassNotFoundException {
        return this.getContextClassLoader().loadClass("org.apache.beehive.controls.api.events.EventRef");
    }

    private Class<?> getTxnAttributeClass() throws ClassNotFoundException {
        return this.getContextClassLoader().loadClass("com.bea.control.annotations.TransactionAttribute");
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Class<?> getControlInf(Class clazz) throws Exception {
        Class<?> clazz2 = this.getContextClassLoader().loadClass("org.apache.beehive.controls.api.bean.ControlExtension");
        Class<?> clazz3 = this.getContextClassLoader().loadClass("org.apache.beehive.controls.api.bean.ControlInterface");
        Class<?> clazz4 = clazz.getEnclosingClass();
        if (clazz4 != null) {
            return this.getControlInf(clazz4, clazz3, clazz2);
        }
        return null;
    }

    private Class<?> getControlInf(Class clazz, Class clazz2, Class clazz3) {
        if (clazz != null && clazz.isAnnotationPresent(clazz2)) {
            return clazz;
        }
        if (clazz != null && clazz.isAnnotationPresent(clazz3)) {
            Class<?>[] classArray;
            for (Class<?> clazz4 : classArray = clazz.getInterfaces()) {
                Class<?> clazz5 = this.getControlInf(clazz4, clazz2, clazz3);
                if (clazz5 == null) continue;
                return clazz5;
            }
        }
        return null;
    }
}

