/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.callback.controls;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import weblogic.logging.NonCatalogLogger;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.conversation.ConversationCMPHandler;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.conversation.LockManager;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.jws.conversation.ConversationState;
import weblogic.wsee.jws.conversation.Store;
import weblogic.wsee.jws.conversation.StoreConfig;
import weblogic.wsee.jws.conversation.StoreException;
import weblogic.wsee.jws.conversation.StoreManager;
import weblogic.wsee.message.WlMessageContext;

public class ConversationControlCallbackHandler
extends ConversationCMPHandler
implements WLHandler {
    private static final boolean verbose = true;
    NonCatalogLogger _logger = new NonCatalogLogger(ConversationControlCallbackHandler.class.getName());

    public boolean handleRequest(MessageContext messageContext) {
        Object object;
        Object object2;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        Object object3 = wlMessageContext.getProperty("weblogic.wsee.callback.controls.ControlCallbackData");
        if (object3 == null) {
            return true;
        }
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.conversation.ConversationId");
        if (string == null) {
            return true;
        }
        try {
            object2 = (LockManager.Lock)messageContext.getProperty("weblogic.wsee.conversation.Lock");
            if (object2 != null) {
                this._logger.debug("\n\n\n!!!!!! ERROR SOMEONE OBTAINED THE LOCK BEFORE I DID..THIS IS NOT GOOD!\n\n");
            }
            this._logger.debug("---> Obtaining conversation lock for control callbacks: " + string);
            object = LockManager.getInstance().lock(string);
            this._logger.debug("---> Obtained conversation lock for control callbacks: " + string + " ... lock=" + object);
            messageContext.setProperty("weblogic.wsee.conversation.Lock", object);
        }
        catch (InterruptedException interruptedException) {
            throw new JAXRPCException((Throwable)interruptedException);
        }
        object2 = this.getStore(string, wlMessageContext);
        try {
            object = ConversationCMPHandler.loadState(wlMessageContext, (Store)object2, string);
            wlMessageContext.setProperty("weblogic.wsee.jws.container", object);
            wlMessageContext.setProperty("weblogic.wsee.ejb.altRunAs", object.getAltAuthenticatedSubject());
        }
        catch (JAXRPCException jAXRPCException) {
            jAXRPCException.printStackTrace();
            messageContext.setProperty("weblogic.wsee.local.invoke.throwable", (Object)jAXRPCException);
            throw jAXRPCException;
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    public boolean handleClosure(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        return this.finish(messageContext);
    }

    private boolean finish(MessageContext messageContext) {
        if (messageContext.getProperty("weblogic.wsee.callback.controls.ControlCallbackData") == null) {
            return true;
        }
        try {
            this.updateStoreIfNeeded(messageContext);
        }
        catch (StoreException storeException) {
            String string = (String)messageContext.getProperty("weblogic.wsee.conversation.ConversationId");
            storeException.printStackTrace();
            this._logger.debug("Could not save the conversation state ", (Throwable)storeException);
            throw new JAXRPCException("Could not save the conversation state " + string, (Throwable)storeException);
        }
        finally {
            LockManager.Lock lock = (LockManager.Lock)messageContext.getProperty("weblogic.wsee.conversation.Lock");
            if (lock != null) {
                lock.release();
                String string = (String)messageContext.getProperty("weblogic.wsee.conversation.ConversationId");
                this._logger.debug("---> Released jws conversation lock for control callbacks: " + string + " ... lock=" + lock);
            }
        }
        return true;
    }

    private void updateStoreIfNeeded(MessageContext messageContext) throws StoreException {
        ConversationState conversationState;
        String string = (String)messageContext.getProperty("weblogic.wsee.conversation.ConversationId");
        if (string == null) {
            this._logger.debug("updateStore(): ConversationId is null must not be conversational!");
            return;
        }
        this._logger.debug("updateStore():In Conversation! ConversationId is " + string);
        StoreConfig storeConfig = (StoreConfig)messageContext.getProperty("weblogic.wsee.conversation.StoreConfig");
        if (storeConfig != null && (conversationState = (ConversationState)((Object)ContainerFactory.getContainer(messageContext))) != null) {
            Store store = StoreManager.getStore(storeConfig);
            if (this.isConversationFinished(messageContext)) {
                this._logger.debug("Deleting conversation state since conversation has finished");
                store.delete(string);
                LockManager.getInstance().destroy(string);
            } else {
                store.update(conversationState);
            }
        }
    }

    private boolean isConversationFinished(MessageContext messageContext) {
        ConversationPhase conversationPhase = (ConversationPhase)messageContext.getProperty("weblogic.wsee.conversation.ConversationPhase");
        return conversationPhase != null && conversationPhase.equals(ConversationPhase.FINISH) || AsyncUtil.getContainer(messageContext) != null && AsyncUtil.getContainer(messageContext).isFinished();
    }
}

