/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.cluster;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.rpc.JAXRPCException;
import weblogic.jndi.Environment;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.cluster.ClusterDispatcherRemote;
import weblogic.wsee.cluster.ClusterService;
import weblogic.wsee.cluster.ClusterServiceException;
import weblogic.wsee.util.Verbose;

public class ClusterDispatcher
implements ClusterDispatcherRemote {
    private static final boolean verbose = Verbose.isVerbose(ClusterDispatcher.class);
    public static final String CLUSTER_DISPATCHER_JNDI_NAME = "weblogic.wsee.cluster.ClusterDispatcher";
    private static ClusterDispatcher dispatcher;
    private static final AuthenticatedSubject kernelId;
    private final Map services = new HashMap();

    public static synchronized ClusterDispatcher getInstance() {
        if (dispatcher == null) {
            dispatcher = new ClusterDispatcher();
        }
        return dispatcher;
    }

    private ClusterDispatcher() {
        Environment environment = new Environment();
        environment.setCreateIntermediateContexts(true);
        environment.setReplicateBindings(false);
        try {
            Context context = environment.getInitialContext();
            PrivilegedActionUtilities.bindAsSU(context, CLUSTER_DISPATCHER_JNDI_NAME, this, kernelId);
            if (verbose) {
                Verbose.say("Initialized ClusterDispather and bound it to non-replicated JNDI context at: weblogic.wsee.cluster.ClusterDispatcher");
            }
        }
        catch (NamingException namingException) {
            if (verbose) {
                Verbose.logException(namingException);
            }
            throw new JAXRPCException((Throwable)namingException);
        }
    }

    public synchronized void registerClusterService(ClusterService clusterService) {
        if (this.services.get(clusterService.getTargetURI()) == null) {
            if (verbose) {
                Verbose.say("Registering ClusterService at target URI " + clusterService.getTargetURI() + " as: " + clusterService);
            }
            this.services.put(clusterService.getTargetURI(), clusterService);
        }
    }

    public Serializable dispatch(String string, Serializable serializable) throws RemoteException {
        ClusterService clusterService = this.getClusterService(string);
        if (verbose) {
            Verbose.say("Dispatching using ClusterService for targetURI " + string + " and service (" + clusterService + "), object: " + serializable);
        }
        if (clusterService == null) {
            throw new JAXRPCException("Cluster service for " + string + " not available");
        }
        try {
            return clusterService.dispatch(serializable);
        }
        catch (ClusterServiceException clusterServiceException) {
            throw new RemoteException(clusterServiceException.toString());
        }
    }

    private synchronized ClusterService getClusterService(String string) {
        return (ClusterService)this.services.get(string);
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

