/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.cluster;

import java.rmi.UnknownHostException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.URLManager;
import weblogic.wsee.cluster.ClusterDispatcherRemote;
import weblogic.wsee.cluster.ClusterServiceException;
import weblogic.wsee.util.Verbose;

public class ClusterRoutingUtil {
    private static final boolean verbose = Verbose.isVerbose(ClusterRoutingUtil.class);

    public static ClusterDispatcherRemote getClusterDispatcher(String string, String string2) throws ClusterServiceException {
        try {
            String string3 = URLManager.findURL(string, ProtocolManager.getDefaultProtocol());
            if (verbose) {
                Verbose.log("Dispatch message for " + string2 + " to " + string + " at " + string3);
            }
            Environment environment = new Environment();
            environment.setProviderUrl(string3);
            Context context = environment.getInitialContext();
            ClusterDispatcherRemote clusterDispatcherRemote = (ClusterDispatcherRemote)context.lookup("weblogic.wsee.cluster.ClusterDispatcher");
            return clusterDispatcherRemote;
        }
        catch (NamingException namingException) {
            throw new ClusterServiceException(namingException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ClusterServiceException(unknownHostException);
        }
    }
}

