/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.cluster;

import java.security.AccessController;
import java.util.Locale;
import javax.xml.rpc.JAXRPCException;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class ClusterUtil {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static String getProtocol(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n <= 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getExternalAddress(String string) {
        String string2 = System.getProperty("weblogic.wsee.proxy.address");
        if (string2 != null) {
            return string2;
        }
        String string3 = string.toLowerCase(Locale.ENGLISH);
        ServerChannel serverChannel = ServerChannelManager.findLocalServerChannel((String)("weblogic-wsee-proxy-channel-" + string3));
        if (serverChannel != null) {
            String string4 = serverChannel.getPublicAddress();
            if (string4 == null) {
                throw new JAXRPCException("Public address for the proxy channel is not set");
            }
            if (!string.equalsIgnoreCase(serverChannel.getProtocolPrefix())) {
                throw new JAXRPCException("weblogic-wsee-proxy-channel-" + string + " should have the protocol be " + string);
            }
            return string + "://" + string4 + ":" + serverChannel.getPublicPort();
        }
        ServerChannel serverChannel2 = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolManager.getProtocolByName((String)string3));
        if (serverChannel2 == null) {
            throw new JAXRPCException("No default channel established for protocol " + string);
        }
        String string5 = ChannelHelper.createClusterURL(serverChannel2);
        if (string5.contains(",")) {
            throw new JAXRPCException("Network channel weblogic-wsee-proxy-channel-" + string + " should be set.");
        }
        return string5;
    }

    public static String getAddress() {
        String string = System.getProperty("weblogic.proxy.server");
        if (string != null) {
            int n = string.indexOf("//");
            int n2 = string.lastIndexOf(58);
            if (n < 0 || n + 1 >= n2) {
                throw new JAXRPCException("Invalid proxy server specified: " + string + ", correct format: t3://[host]:[port]");
            }
            return string.substring(n + 2, n2);
        }
        String string2 = ManagementService.getRuntimeAccess(kernelId).getServer().getListenAddress();
        if (string2 == null) {
            throw new JAXRPCException("Server listen address is not set");
        }
        return string2;
    }

    public static int getPort() {
        String string = System.getProperty("weblogic.proxy.server");
        if (string != null) {
            int n = string.lastIndexOf(58);
            if (n >= 6) {
                try {
                    int n2 = Integer.parseInt(string.substring(n + 1));
                    return n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JAXRPCException("Invalid proxy server specified: " + string + ", correct format: t3://[host]:[port]", (Throwable)numberFormatException);
                }
            }
            throw new JAXRPCException("Invalid proxy server specified: " + string + ", correct format: t3://[host]:[port]");
        }
        return ManagementService.getRuntimeAccess(kernelId).getServer().getListenPort();
    }

    public static AuthenticatedSubject getSubject(AuthenticatedSubject authenticatedSubject) {
        return (AuthenticatedSubject)SubjectManager.getSubjectManager().getCurrentSubject((AbstractSubject)authenticatedSubject);
    }
}

