/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.cluster;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReferenceHeader;
import weblogic.wsee.addressing.FaultToHeader;
import weblogic.wsee.addressing.FromHeader;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.cluster.ClusterDispatcherRemote;
import weblogic.wsee.cluster.ClusterRoutingUtil;
import weblogic.wsee.cluster.ClusterServiceException;
import weblogic.wsee.cluster.ClusterUtil;
import weblogic.wsee.cluster.SerializableSOAPMessage;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.connection.soap.SoapConnection;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationHeader;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.security.wssc.sct.SCTHelperAllVersion;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.PathServiceUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.dispatch.Dispatcher;

public class ForwardingHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(ForwardingHandler.class);
    public static final String CLUSTER_ROUTED = "weblogic.wsee.cluster.routed";
    public static final String VERSION_FORWARDED = "weblogic.wsee.cluster.forwarded_version";
    private QName[] HEADERS = new QName[0];

    public QName[] getHeaders() {
        return this.HEADERS;
    }

    public boolean handleRequest(MessageContext messageContext) {
        String string;
        Object object;
        Object object2;
        Object object3;
        assert (messageContext != null);
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if ("true".equalsIgnoreCase((String)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME"))) {
            return true;
        }
        if (verbose) {
            Verbose.log("[ForwardingHandler.handleRequest()] called");
        }
        ServiceIdentityHeader serviceIdentityHeader = (ServiceIdentityHeader)wlMessageContext.getHeaders().getHeader(ServiceIdentityHeader.TYPE);
        String string2 = null;
        Throwable throwable = null;
        String string3 = null;
        if (serviceIdentityHeader == null) {
            if (verbose) {
                Verbose.log("ServiceIdentityHeader is NULL.");
            }
            if ((object3 = (ContinueHeader)(object2 = wlMessageContext.getHeaders()).getHeader(ContinueHeader.TYPE)) != null) {
                if (verbose) {
                    Verbose.log("ContinueHeader is NOT NULL");
                }
                if ((string2 = ((ContinueHeader)object3).getServerName()) == null) {
                    try {
                        string2 = PathServiceUtil.getServerNameFromPathService(((ConversationHeader)object3).getConversationId());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        string3 = ((ConversationHeader)object3).getConversationId();
                    }
                }
                if (verbose) {
                    Verbose.log("serverName='" + string2 + "'");
                }
                if (wlMessageContext.getProperty("weblogic.wsee.version.appversion.id") == null && (object = ((ContinueHeader)object3).getAppVersionId()) != null) {
                    wlMessageContext.setProperty("weblogic.wsee.version.appversion.id", object);
                }
            } else {
                if (verbose) {
                    Verbose.log("continueHeader is NULL");
                }
                if (wlMessageContext.getProperty("weblogic.wsee.version.appversion.id") == null && (object = ApplicationVersionUtils.getCurrentVersionId()) != null) {
                    wlMessageContext.setProperty(VERSION_FORWARDED, object);
                }
            }
            if (!"true".equalsIgnoreCase((String)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME"))) {
                object = (SequenceHeader)wlMessageContext.getHeaders().getHeader(SequenceHeader.TYPE);
                if (object != null && string2 == null) {
                    string2 = ((SequenceHeader)object).getSequenceId();
                    string2 = string2.substring(5, string2.indexOf(58, 6));
                }
                if (verbose && string2 != null) {
                    Verbose.log("serverName='" + string2 + "'");
                }
            }
            if (string2 == null) {
                if (verbose) {
                    Verbose.log("serverName is NULL get from SCToken using SCTHelperAllVersion.getCredentialIdentifier");
                }
                if ((object = SCTHelperAllVersion.getCredentialIdentifier((SOAPMessageContext)messageContext)) != null) {
                    int n = ((String)object).indexOf("uuid:");
                    if (n == 0) {
                        n = ((String)object).indexOf(58, 6);
                        if (n >= 6) {
                            string2 = ((String)object).substring(5, n);
                            if (verbose) {
                                Verbose.log("Routing to " + string2 + " using SCT id");
                            }
                        }
                    } else if (verbose) {
                        Verbose.log("credId='" + (String)object + "' has no 'uuid'");
                    }
                }
            }
            if (string2 == null && throwable == null) {
                return true;
            }
            if (string2 == null && throwable != null) {
                throw new JAXRPCException("Failed to determine the route for conversation " + string3, throwable);
            }
            string = "weblogic.wsee.conversation.msg.cluster.service";
        } else {
            string = serviceIdentityHeader.getServiceName();
            if (verbose) {
                Verbose.log("ServiceIdentityHeader is NOT NULL.  got serviceName from ServiceIdentityHeader='" + string + "'");
            }
            if (!string.equals("weblogic.wsee.conversation.msg.cluster.service")) {
                return true;
            }
            string2 = serviceIdentityHeader.getServerName();
            if (verbose) {
                Verbose.log(" from Header, got serverName='" + string2 + "'");
            }
            if (wlMessageContext.getProperty("weblogic.wsee.version.appversion.id") == null && (object3 = (ContinueHeader)(object2 = wlMessageContext.getHeaders()).getHeader(ContinueHeader.TYPE)) != null && ((ContinueHeader)object3).getAppVersionId() != null) {
                wlMessageContext.setProperty("weblogic.wsee.version.appversion.id", ((ContinueHeader)object3).getAppVersionId());
            }
        }
        object2 = LocalServerIdentity.getIdentity().getServerName();
        if (verbose) {
            Verbose.log("from LocalServerIdentity.getIdentity() got serverName='" + (String)object2 + "'");
        }
        if (((String)object2).equalsIgnoreCase(string2)) {
            return true;
        }
        if (verbose) {
            object3 = wlMessageContext.getHeaders();
            object = (MessageIdHeader)object3.getHeader(MessageIdHeader.TYPE);
            String string4 = null;
            if (object != null) {
                string4 = ((MessageIdHeader)object).getMessageId();
            }
            Verbose.log("!! Forwarding msg id " + string4 + " from server " + (String)object2 + " to server " + string2);
            SoapConnection.dumpSoapMsg((SoapMessageContext)wlMessageContext, true);
        }
        object3 = wlMessageContext.getDispatcher();
        boolean bl = this.confirmOneway((Dispatcher)object3, wlMessageContext);
        this.route(string2, string, wlMessageContext, bl);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void route(String string, String string2, WlMessageContext wlMessageContext, boolean bl) {
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)wlMessageContext;
        try {
            Serializable serializable;
            Object object;
            ClusterDispatcherRemote clusterDispatcherRemote = ClusterRoutingUtil.getClusterDispatcher(string, string2);
            if (clusterDispatcherRemote == null) return;
            SOAPInvokeState sOAPInvokeState = new SOAPInvokeState(sOAPMessageContext);
            sOAPInvokeState.setSubject(ClusterUtil.getSubject((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())));
            String string3 = null;
            if (verbose) {
                object = wlMessageContext.getHeaders();
                serializable = (MessageIdHeader)object.getHeader(MessageIdHeader.TYPE);
                if (serializable != null) {
                    string3 = ((MessageIdHeader)serializable).getMessageId();
                }
                Verbose.say("!! Invoking ClusterDispatcherRemote for msg " + string3);
            }
            object = clusterDispatcherRemote.dispatch(string2, sOAPInvokeState);
            if (verbose) {
                Verbose.say("!! Back from ClusterDispatcherRemote on msg " + string3 + " with ret: " + object);
            }
            if (object != null) {
                if (!(object instanceof SerializableSOAPMessage)) throw new JAXRPCException("Unknown return type for cluster routing");
                serializable = (SerializableSOAPMessage)object;
                sOAPMessageContext.setMessage(((SerializableSOAPMessage)serializable).getSOAPMessage());
                wlMessageContext.setProperty("weblogic.wsee.reply.anonymous", "true");
                return;
            }
            wlMessageContext.setProperty(CLUSTER_ROUTED, "true");
            if (bl) return;
            AddressingUtil.confirmOneway(wlMessageContext);
            return;
        }
        catch (ClusterServiceException clusterServiceException) {
            if (!verbose) throw new JAXRPCException((Throwable)clusterServiceException);
            Verbose.logException(clusterServiceException);
            throw new JAXRPCException((Throwable)clusterServiceException);
        }
        catch (RemoteException remoteException) {
            if (!verbose) throw new JAXRPCException((Throwable)remoteException);
            Verbose.logException(remoteException);
            throw new JAXRPCException((Throwable)remoteException);
        }
    }

    private boolean confirmOneway(Dispatcher dispatcher, WlMessageContext wlMessageContext) {
        boolean bl = false;
        if (dispatcher.getOperation() != null && (dispatcher.getOperation().getType() == 1 || dispatcher.getOperation().getType() == 3)) {
            AddressingUtil.confirmOneway(wlMessageContext);
            bl = true;
        }
        if (!bl && this.checkAsyncReqRes(wlMessageContext)) {
            AddressingUtil.confirmOneway(wlMessageContext);
            bl = true;
        }
        return bl;
    }

    private boolean checkAsyncReqRes(WlMessageContext wlMessageContext) {
        EndpointReferenceHeader endpointReferenceHeader;
        boolean bl = false;
        boolean bl2 = false;
        ReplyToHeader replyToHeader = (ReplyToHeader)wlMessageContext.getHeaders().getHeader(ReplyToHeader.TYPE);
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        if (replyToHeader != null) {
            if (!addressingProvider.isAnonymousReferenceURI(replyToHeader.getReference().getAddress())) {
                bl = true;
            }
        } else {
            endpointReferenceHeader = (FromHeader)wlMessageContext.getHeaders().getHeader(FromHeader.TYPE);
            if (endpointReferenceHeader != null && !addressingProvider.isAnonymousReferenceURI(endpointReferenceHeader.getReference().getAddress())) {
                bl = true;
            }
        }
        if ((endpointReferenceHeader = (FaultToHeader)wlMessageContext.getHeaders().getHeader(FaultToHeader.TYPE)) != null) {
            if (!addressingProvider.isAnonymousReferenceURI(endpointReferenceHeader.getReference().getAddress())) {
                bl2 = true;
            }
        } else {
            bl2 = bl;
        }
        return bl && bl2;
    }
}

