/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.xml.saaj.SOAPMessageImpl;

public class SerializableSOAPMessage
implements Serializable {
    private SOAPMessage msg = null;
    private AuthenticatedSubject subject = null;

    public SerializableSOAPMessage() {
    }

    public SerializableSOAPMessage(SOAPMessage sOAPMessage) {
        if (!(sOAPMessage instanceof Externalizable)) {
            throw new JAXRPCException("Invalid SOAP message type: " + sOAPMessage.getClass());
        }
        this.msg = sOAPMessage;
    }

    public SOAPMessage getSOAPMessage() {
        return this.msg;
    }

    public void setSubject(AuthenticatedSubject authenticatedSubject) {
        this.subject = authenticatedSubject;
    }

    public AuthenticatedSubject getSubject() {
        return this.subject;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.subject = n > 0 ? (AuthenticatedSubject)objectInputStream.readObject() : null;
        int n2 = objectInputStream.readInt();
        if (n2 > 0) {
            boolean bl = objectInputStream.readBoolean();
            MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(bl);
            try {
                this.msg = messageFactory.createMessage();
            }
            catch (SOAPException sOAPException) {
                throw new IOException(sOAPException.getMessage());
            }
            ((SOAPMessageImpl)this.msg).readExternal((ObjectInput)objectInputStream);
        } else {
            this.msg = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.subject != null) {
            objectOutputStream.writeInt(1);
            objectOutputStream.writeObject(this.subject);
        } else {
            objectOutputStream.writeInt(0);
        }
        if (this.msg != null) {
            objectOutputStream.writeInt(1);
            objectOutputStream.writeBoolean(this.isSoap12());
            ((SOAPMessageImpl)this.msg).writeExternal((ObjectOutput)objectOutputStream);
        } else {
            objectOutputStream.writeInt(0);
        }
    }

    private boolean isSoap12() {
        try {
            return "http://www.w3.org/2003/05/soap-envelope".equals(this.msg.getSOAPPart().getEnvelope().getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            return false;
        }
    }
}

