/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.cluster;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class ServiceIdentityHeader
extends MsgHeader {
    public static final String SERVICEIDENTITY_NS = "http://www.bea.com/ServiceIdentity";
    public static final String SERVICEIDENTITY_PREFIX = "serviceidentity";
    public static final String XML_TAG_SERVICEIDENTITY = "ServiceIdentity";
    public static final String XML_TAG_SERVICE_NAME = "ServiceName";
    public static final String XML_TAG_SERVER_NAME = "ServerName";
    public static final QName NAME = new QName("http://www.bea.com/ServiceIdentity", "ServiceIdentity", "serviceidentity");
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private String serviceName;
    private String serverName;

    public QName getName() {
        return NAME;
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void read(Element element) throws MsgHeaderException {
        try {
            this.serverName = DOMUtils.getValueByTagNameNS(element, SERVICEIDENTITY_NS, XML_TAG_SERVER_NAME);
            this.serviceName = DOMUtils.getValueByTagNameNS(element, SERVICEIDENTITY_NS, XML_TAG_SERVICE_NAME);
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not read service identity header", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(Element element) throws MsgHeaderException {
        if (this.serverName == null) {
            throw new MsgHeaderException("Server name is null");
        }
        if (this.serviceName == null) {
            throw new MsgHeaderException("Service name is null");
        }
        DOMUtils.addNamespaceDeclaration(element, SERVICEIDENTITY_PREFIX, SERVICEIDENTITY_NS);
        DOMUtils.addValueNS(element, SERVICEIDENTITY_NS, "serviceidentity:ServerName", this.serverName);
        DOMUtils.addValueNS(element, SERVICEIDENTITY_NS, "serviceidentity:ServiceName", this.serviceName);
    }
}

