/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.cluster;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortTermCache<K, V> {
    private long _maxTime;
    private Map<K, Envelope<K, V>> _cache;

    public ShortTermCache(long l) {
        this._maxTime = l;
        this._cache = new HashMap<K, Envelope<K, V>>();
    }

    public synchronized V put(K k, V v) {
        Envelope<K, V> envelope = new Envelope<K, V>(k, v);
        Envelope<K, V> envelope2 = this._cache.put(k, envelope);
        return envelope2 != null ? (V)envelope2.getValue() : null;
    }

    public synchronized void remove(K k) {
        this._cache.remove(k);
    }

    public synchronized V get(K k) {
        boolean bl;
        Envelope<K, V> envelope = this._cache.get(k);
        boolean bl2 = bl = envelope != null && envelope.isExpired();
        if (envelope == null || bl) {
            if (bl) {
                this.purgeCache();
            }
            return null;
        }
        return envelope.getValue();
    }

    private void purgeCache() {
        Iterator<K> iterator = this._cache.keySet().iterator();
        while (iterator.hasNext()) {
            K k = iterator.next();
            Envelope<K, V> envelope = this._cache.get(k);
            if (!envelope.isExpired()) continue;
            iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Envelope<K, V> {
        private K _key;
        private V _value;
        public long _cacheTime;

        public Envelope(K k, V v) {
            this._key = k;
            this._value = v;
            this._cacheTime = System.currentTimeMillis();
        }

        public K getKey() {
            return this._key;
        }

        public V getValue() {
            return this._value;
        }

        public long getCacheTime() {
            return this._cacheTime;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this._cacheTime > ShortTermCache.this._maxTime;
        }
    }
}

