/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.codec;

import java.util.HashMap;
import weblogic.wsee.codec.Codec;
import weblogic.wsee.codec.CodecException;
import weblogic.wsee.codec.soap11.SoapCodec;
import weblogic.wsee.codec.soap12.Soap12Codec;
import weblogic.wsee.wsdl.WsdlBinding;

public class CodecFactory {
    private static CodecFactory instance = new CodecFactory();
    private HashMap codecs = new HashMap();

    private CodecFactory() {
        this.codecs.put("SOAP11", new SoapCodec());
        this.codecs.put("SOAP12", new Soap12Codec());
    }

    public static CodecFactory instance() {
        return instance;
    }

    public Codec getCodec(WsdlBinding wsdlBinding) throws CodecException {
        String string = wsdlBinding.getBindingType();
        Codec codec2 = (Codec)this.codecs.get(string);
        if (codec2 == null) {
            throw new CodecException("Unable to find Codec for binding type '" + string + "'");
        }
        return codec2;
    }
}

