/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.codec.soap11;

import com.bea.staxb.runtime.MarshalOptions;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.bind.runtime.SerializerContext;
import weblogic.wsee.bind.runtime.internal.BaseSerializerContext;

class SerializationContextUtil {
    private static final String ENCODING_STYLE = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String SOAP12_ENCODING_STYLE = "http://www.w3.org/2003/05/soap-encoding";

    private SerializationContextUtil() {
    }

    static SerializerContext createSerializerContext(RuntimeBindings runtimeBindings, MessageContext messageContext, String string, String string2) {
        MarshalOptions marshalOptions = BaseSerializerContext.createDefaultMarshalOptions();
        if (Boolean.parseBoolean((String)messageContext.getProperty("weblogic.wsee.marshal.forceIncludeXsiType"))) {
            marshalOptions.setForceIncludeXsiType(true);
        }
        if (Boolean.parseBoolean((String)messageContext.getProperty("weblogic.wsee.marshal.forceOracle1012CompatibleMarshal"))) {
            marshalOptions.setForceOracle1012Compatible(true);
            return runtimeBindings.createSerializerContext(0, marshalOptions);
        }
        if ("literal".equals(string)) {
            SerializationContextUtil.forceDotNetCompatibleMarshal(messageContext, marshalOptions);
            return runtimeBindings.createSerializerContext(0, marshalOptions);
        }
        if ("encoded".equals(string)) {
            if (string2 != null && SOAP12_ENCODING_STYLE.equals(string2)) {
                return runtimeBindings.createSerializerContext(2, marshalOptions);
            }
            return runtimeBindings.createSerializerContext(1, marshalOptions);
        }
        throw new AssertionError((Object)("unknown encoding: " + string));
    }

    private static void forceDotNetCompatibleMarshal(MessageContext messageContext, MarshalOptions marshalOptions) {
        Boolean bl = (Boolean)messageContext.getProperty("weblogic.wsee.dotnet.compatible.binding");
        if (bl != null) {
            marshalOptions.setForceDotNetCompatibleMarshal(bl.booleanValue());
        } else {
            marshalOptions.setForceDotNetCompatibleMarshal(Boolean.parseBoolean(System.getProperty("weblogic.wsee.dotnet.compatible.binding")));
        }
    }
}

