/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.codec.soap11;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.xml.XmlException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.bind.runtime.BindingContext;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.codec.Codec;
import weblogic.wsee.codec.CodecException;
import weblogic.wsee.codec.soap11.SerializationContextUtil;
import weblogic.wsee.codec.soap11.SoapDecoder;
import weblogic.wsee.codec.soap11.SoapEncoder;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.jaxrpc.soapfault.WLSOAPFaultException;
import weblogic.wsee.jws.wlw.JwsSoapFaultHelper;
import weblogic.wsee.jws.wlw.SoapFaultException;
import weblogic.wsee.jws.wlw.UnRecognizedFaultException;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.mtom.api.MtomPolicyInfo;
import weblogic.wsee.mtom.api.MtomPolicyInfoFactory;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.util.SaajUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLSOAPFactory;
import weblogic.wsee.ws.WsFault;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsServiceImpl;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBody;
import weblogic.wsee.wsdl.soap11.SoapFault;
import weblogic.wsee.wsdl.soap11.SoapMessageBase;
import weblogic.xml.saaj.SOAPMessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapCodec
implements Codec {
    private static final boolean verbose = Verbose.isVerbose(SoapCodec.class);
    public static final Name VOID_NAME_KEY;
    public static final String VALIDATING_DECODER = "weblogic.wsee.soap.validating_decoder";
    static final String PREFIX = "m";
    static final String DOCUMENT = "document";
    static final String RPC = "rpc";
    static final String LITERAL = "literal";
    static final String ENCODED = "encoded";
    static final short NOT_SPECIAL_EXCEPTION = 0;
    static final short WLW_SOAPFAULT_EXCEPTION = 1;
    static final short JAXRPC_SOAPFAULT_EXCEPTION = 2;
    static final boolean is81CustomException;

    @Override
    public MessageContext createContext() {
        return new SoapMessageContext();
    }

    @Override
    public void encode(MessageContext messageContext, WsdlBindingMessage wsdlBindingMessage, WsMethod wsMethod, Map map) throws CodecException {
        SoapMessageContext soapMessageContext = this.getSoapMessageContext(messageContext);
        try {
            MtomPolicyInfo mtomPolicyInfo = MtomPolicyInfoFactory.getInstance(messageContext);
            boolean bl = false;
            if (mtomPolicyInfo.isMtomOptional()) {
                if ((WlMessageContext)messageContext.getProperty("weblogic.wsee.mtom_message_recvd") != null) {
                    bl = true;
                }
            } else if (!mtomPolicyInfo.isMtomDisable()) {
                bl = true;
            }
            SOAPMessage sOAPMessage = soapMessageContext.clearMessage(bl);
            this.createEncoder(sOAPMessage, wsdlBindingMessage, wsMethod, messageContext).encode(map);
        }
        catch (SOAPException sOAPException) {
            throw new CodecException("Failed to encode message", sOAPException);
        }
        catch (WsdlException wsdlException) {
            throw new CodecException("Failed to encode message", wsdlException);
        }
        catch (XmlException xmlException) {
            throw new CodecException("Failed to encode message", xmlException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new CodecException("Failed to encode message", xMLStreamException);
        }
        catch (PolicyException policyException) {
            throw new CodecException("Failed to encode message", policyException);
        }
    }

    protected SoapEncoder createEncoder(SOAPMessage sOAPMessage, WsdlBindingMessage wsdlBindingMessage, WsMethod wsMethod, MessageContext messageContext) {
        return new SoapEncoder(sOAPMessage, wsdlBindingMessage, wsMethod, messageContext);
    }

    @Override
    public void decode(MessageContext messageContext, WsdlBindingMessage wsdlBindingMessage, WsMethod wsMethod, Map map) throws CodecException {
        if (verbose) {
            Verbose.here();
        }
        SoapMessageContext soapMessageContext = this.getSoapMessageContext(messageContext);
        SOAPMessage sOAPMessage = soapMessageContext.getMessage();
        try {
            MtomPolicyInfo mtomPolicyInfo = MtomPolicyInfoFactory.getInstance(messageContext);
            if (mtomPolicyInfo != null && ((SOAPMessageImpl)sOAPMessage).getIsMTOMmessage() && mtomPolicyInfo.isMtomDisable()) {
                throw new CodecException("non-MTOM endpoint received a MTOM message");
            }
            boolean bl = false;
            if (soapMessageContext.containsProperty(VALIDATING_DECODER)) {
                bl = (Boolean)soapMessageContext.getProperty(VALIDATING_DECODER);
            }
            this.createDecoder(soapMessageContext, wsdlBindingMessage, wsMethod).decode(map, bl);
        }
        catch (SOAPException sOAPException) {
            throw new CodecException("Failed to encode message", sOAPException);
        }
        catch (WsdlException wsdlException) {
            throw new CodecException("Failed to decode message", wsdlException);
        }
        catch (XmlException xmlException) {
            throw new CodecException("Failed to decode message", xmlException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new CodecException("Failed to decode message", xMLStreamException);
        }
        catch (PolicyException policyException) {
            throw new CodecException("Failed to encode message", policyException);
        }
    }

    protected SoapDecoder createDecoder(SOAPMessageContext sOAPMessageContext, WsdlBindingMessage wsdlBindingMessage, WsMethod wsMethod) {
        return new SoapDecoder(sOAPMessageContext, wsdlBindingMessage, wsMethod);
    }

    @Override
    public QName getOperation(MessageContext messageContext) throws CodecException {
        SoapMessageContext soapMessageContext = this.getSoapMessageContext(messageContext);
        SOAPMessage sOAPMessage = soapMessageContext.getMessage();
        try {
            Node node;
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            Dispatcher dispatcher = wlMessageContext.getDispatcher();
            ActionHeader actionHeader = (ActionHeader)wlMessageContext.getHeaders().getHeader(ActionHeader.TYPE);
            String string = actionHeader == null ? null : actionHeader.getActionURI();
            Map<Name, QName> map = dispatcher.getWsPort().getActionDispatchMap(string);
            if (map == null) {
                map = dispatcher.getWsPort().getSoapDispatchMap();
            }
            if (map == null) {
                throw new AssertionError((Object)"Soap dispatch map is null");
            }
            SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
            for (node = sOAPBody.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType() || map.get(((SOAPElement)node).getElementName()) == null) continue;
                return map.get(((SOAPElement)node).getElementName());
            }
            node = sOAPMessage.getSOAPHeader();
            if (node != null) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (1 != node2.getNodeType() || map.get(((SOAPElement)node2).getElementName()) == null) continue;
                    return map.get(((SOAPElement)node2).getElementName());
                }
            }
            return map.get(VOID_NAME_KEY);
        }
        catch (SOAPException sOAPException) {
            throw new CodecException("Failed to find web service method name", sOAPException);
        }
    }

    @Override
    public void decodeFault(MessageContext messageContext, Collection<? extends WsdlBindingMessage> collection, WsMethod wsMethod) throws CodecException, SOAPException {
        Object object;
        Object object2;
        Object object3;
        SOAPFault sOAPFault;
        block28: {
            SoapMessageContext soapMessageContext = this.getSoapMessageContext(messageContext);
            SOAPMessage sOAPMessage = soapMessageContext.getMessage();
            if (!sOAPMessage.getSOAPBody().hasFault()) {
                throw new CodecException("SOAP Body does not contain SOAP Fault");
            }
            sOAPFault = sOAPMessage.getSOAPBody().getFault();
            object3 = null;
            Detail detail = sOAPFault.getDetail();
            SOAPElement sOAPElement = this.getTopLevel(detail);
            if (sOAPElement != null && collection != null && collection.size() > 0 && object3 == null) {
                int n;
                Object object4;
                object2 = collection.iterator().next();
                object = this.getSoapFault((WsdlBindingMessage)object2);
                String string = null;
                if (object == null) {
                    object4 = this.getSoapBody((WsdlBindingMessage)object2);
                    if (object4 != null) {
                        string = ((SoapBody)object4).getUse();
                    }
                } else {
                    string = ((SoapFault)object).getUse();
                }
                if (LITERAL.equals(string)) {
                    n = 0;
                    if (verbose) {
                        Verbose.log("  using LITERAL BindingContext");
                    }
                } else if (ENCODED.equals(string)) {
                    n = 1;
                    if (verbose) {
                        Verbose.log("  using SOAP11 BindingContext");
                    }
                } else {
                    throw new AssertionError((Object)("unknown encoding: " + string));
                }
                object4 = WlMessageContext.narrow(messageContext);
                String string2 = null;
                try {
                    string2 = this.findStyle(((WlMessageContext)object4).getDispatcher());
                }
                catch (WsdlException wsdlException) {
                    throw new CodecException(" WsdlException while trying to findStyle for Fault in wsMethod " + wsMethod, wsdlException);
                }
                try {
                    object3 = this.createExceptionFromFault(collection, wsMethod, sOAPElement, sOAPMessage, string2, n);
                }
                catch (Throwable throwable) {
                    if (verbose) {
                        Verbose.log(" got Throwable " + throwable.getClass().getName() + " while attempting " + " to createExceptionFromFault. " + throwable.getMessage());
                    }
                    object3 = null;
                }
            }
            if (is81CustomException && object3 != null && ((Throwable)object3).getCause() == null) {
                try {
                    object2 = new SOAPFaultException(this.getFaultCode(sOAPFault), sOAPFault.getFaultString(), sOAPFault.getFaultActor(), sOAPFault.getDetail());
                    ((Throwable)object3).initCause((Throwable)object2);
                }
                catch (RuntimeException runtimeException) {
                    if (!verbose) break block28;
                    Verbose.log("Exception in setting cause for current exception" + runtimeException);
                }
            }
        }
        if (object3 == null && messageContext.getProperty("com.bea.SOAPFAULTS_CONTAIN_XMLBEANS") != null) {
            try {
                object3 = this.createExceptionFromFault(sOAPFault);
            }
            catch (UnRecognizedFaultException unRecognizedFaultException) {
                if (verbose) {
                    Verbose.log((Object)"Unable to unmarshal fault into a wlw SoapFaultException", unRecognizedFaultException);
                }
                object3 = null;
            }
        }
        if (object3 == null) {
            if (sOAPFault.getFaultCodeAsQName() == null) {
                throw new CodecException("SOAP Body does not contain a validate SOAP Fault!");
            }
            object3 = new WLSOAPFaultException(sOAPFault);
            if (verbose) {
                Verbose.log(" could not create exception from known exception types.  Created general SOAPFaultException instead");
            }
        }
        if ((object = ((WlMessageContext)(object2 = (WlMessageContext)messageContext)).getFault()) != null) {
            if (verbose) {
                Verbose.log(" Throwable from context.getFault() not null.  Setting initCause on exception to " + ((Throwable)object).getMessage());
            }
            ((Throwable)object3).initCause((Throwable)object);
        }
        ((WlMessageContext)object2).setFault((Throwable)object3);
    }

    protected SoapFault getSoapFault(WsdlBindingMessage wsdlBindingMessage) {
        return SoapFault.narrow(wsdlBindingMessage);
    }

    protected SoapBody getSoapBody(WsdlBindingMessage wsdlBindingMessage) {
        return SoapBody.narrow(wsdlBindingMessage);
    }

    protected SoapBinding getSoapBinding(WsdlBinding wsdlBinding) {
        return SoapBinding.narrow(wsdlBinding);
    }

    protected SoapBindingOperation getSoapBindingOperation(WsdlBindingOperation wsdlBindingOperation) {
        return SoapBindingOperation.narrow(wsdlBindingOperation);
    }

    protected void fillFault(SOAPFault sOAPFault, SoapFaultException soapFaultException) throws SOAPException {
        JwsSoapFaultHelper.fillFault(sOAPFault, 1, soapFaultException);
    }

    protected SoapFaultException createExceptionFromFault(SOAPFault sOAPFault) throws UnRecognizedFaultException {
        return JwsSoapFaultHelper.createExceptionFromFault(sOAPFault, 1);
    }

    @Override
    public boolean encodeFault(MessageContext messageContext, WsMethod wsMethod, Throwable throwable) throws CodecException {
        this.getSoapMessageContext(messageContext).clearMessage();
        boolean bl = false;
        int n = 0;
        if (throwable instanceof SOAPFaultException) {
            n = 2;
        } else if (throwable instanceof SoapFaultException) {
            n = 1;
        }
        if (n != 0) {
            block14: {
                if (verbose) {
                    Verbose.log("+++  encode Exception " + throwable + " as a special case   ++++");
                }
                SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
                try {
                    SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
                    SOAPFault sOAPFault = sOAPBody.addFault();
                    if (n == 2) {
                        SOAPFaultUtil.fillFault(sOAPFault, throwable);
                        break block14;
                    }
                    if (n == 1) {
                        this.fillFault(sOAPFault, (SoapFaultException)throwable);
                        break block14;
                    }
                    throw new CodecException(" Unhandled special exception of type '" + n + "', " + "class '" + throwable.getClass().getName() + "', '" + throwable.getMessage() + "'");
                }
                catch (SOAPException sOAPException) {
                    throw new CodecException("Failed to encode", sOAPException);
                }
            }
            bl = true;
            return true;
        }
        Iterator iterator = wsMethod.getExceptions();
        while (iterator.hasNext()) {
            WsFault wsFault = (WsFault)iterator.next();
            if (!wsFault.getExceptionClass().equals(throwable.getClass())) continue;
            try {
                this.encodeFault(messageContext, wsMethod, wsFault, throwable);
            }
            catch (SOAPException sOAPException) {
                throw new CodecException("Failed to encode", sOAPException);
            }
            catch (XmlException xmlException) {
                throw new CodecException("Failed to encode", xmlException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new CodecException("Failed to encode", xMLStreamException);
            }
            bl = true;
        }
        return bl;
    }

    private boolean encodeWlwFault(MessageContext messageContext, WsMethod wsMethod, Throwable throwable) throws CodecException {
        this.getSoapMessageContext(messageContext).clearMessage();
        if (throwable instanceof SOAPFaultException) {
            if (verbose) {
                Verbose.log("+++  encode SOAPFaultException " + throwable + " as a special case   ++++");
            }
            SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
            try {
                SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
                SOAPFault sOAPFault = sOAPBody.addFault();
                SOAPFaultUtil.fillFault(sOAPFault, throwable);
            }
            catch (SOAPException sOAPException) {
                throw new CodecException("Failed to encode", sOAPException);
            }
            return true;
        }
        return false;
    }

    private Throwable createExceptionFromFault(Collection<? extends WsdlBindingMessage> collection, WsMethod wsMethod, SOAPElement sOAPElement, SOAPMessage sOAPMessage, String string, int n) throws CodecException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        SOAPBody sOAPBody;
        RuntimeBindings runtimeBindings;
        Throwable throwable;
        block22: {
            throwable = null;
            runtimeBindings = ((WsServiceImpl)wsMethod.getEndpoint().getService()).getBindingProvider();
            sOAPBody = null;
            try {
                object5 = sOAPMessage.getSOAPPart().getEnvelope();
                if (DOCUMENT.equals(string)) {
                    if (wsMethod.isWrapped()) {
                        object4 = object5.getBody().getChildElements();
                        sOAPBody = this.getFirstElement((Iterator)object4);
                    } else {
                        sOAPBody = object5.getBody();
                    }
                    break block22;
                }
                if (RPC.equals(string)) {
                    object4 = object5.getBody().getChildElements();
                    sOAPBody = this.getFirstElement((Iterator)object4);
                    if (sOAPBody == null) {
                        throw new CodecException("For RPC style web service, Soap Body element must have a child element.");
                    }
                    break block22;
                }
                throw new CodecException("unknown style '" + string + "'");
            }
            catch (SOAPException sOAPException) {
                throw new CodecException("Error while trying to find topElement from SOAPMessage " + sOAPMessage, sOAPException);
            }
        }
        object5 = runtimeBindings.createDeserializerContext(n, (Element)sOAPBody, false);
        object5.setMessage(sOAPMessage);
        object4 = this.findXsiType(sOAPMessage, sOAPElement);
        QName qName = new QName(sOAPElement.getElementName().getURI(), sOAPElement.getElementName().getLocalName());
        Object object6 = null;
        Iterator iterator = wsMethod.getExceptions();
        boolean bl = false;
        int n2 = 0;
        Object object7 = null;
        while (iterator.hasNext() && throwable == null) {
            object3 = (WsFault)iterator.next();
            object2 = this.getPart((WsFault)object3);
            if (object2.getElement() != null) {
                if (!object2.getElement().equals(qName)) continue;
                bl = true;
                object7 = object3;
                break;
            }
            if (!sOAPElement.getElementName().getLocalName().equals(object2.getName())) continue;
            ++n2;
            object7 = object3;
        }
        if (!bl && n2 > 1) {
            object7 = null;
            object3 = wsMethod.getExceptions();
            while (object3.hasNext()) {
                object2 = (WsFault)iterator.next();
                object = this.getPart((WsFault)object2);
                if (object.getType() == null || !object.getType().equals(object4)) continue;
                object7 = object2;
                break;
            }
        }
        if (object7 == null) {
            if (verbose) {
                Verbose.log("could not find matching fault for faultElement '" + qName + "', xsiType '" + object4 + "'");
            }
            return null;
        }
        if (verbose) {
            Verbose.log("found matching fault: '" + object7 + "', for faultElement '" + qName + "'");
        }
        boolean bl2 = ((WsFault)object7).marshalProperty();
        object2 = null;
        object = null;
        object = bl2 ? ((WsFault)object7).getMarshalPropertyClass() : ((WsFault)object7).getExceptionClass();
        try {
            WsdlPart wsdlPart = this.getPart((WsFault)object7);
            if (wsdlPart.getElement() != null) {
                object2 = XmlTypeName.forGlobalName((char)'e', (QName)wsdlPart.getElement());
                if (verbose) {
                    Verbose.log("createExceptionFromFault:   about to call deserializeElement with , exceptionPropertyClass " + ((Class)object).getName() + ", xmlElementName " + object2 + ", on element with tag name '" + sOAPElement.getTagName() + "'");
                }
                object6 = object5.deserializeElement(sOAPElement, (Class)object, (XmlTypeName)object2, false);
                throwable = bl2 ? (Throwable)((WsFault)object7).getMarshalPropertyExceptionConstructor().newInstance(object6) : (Throwable)object6;
            } else {
                object2 = bl2 ? XmlTypeName.forGlobalName((char)'t', (QName)((WsFault)object7).getMarshalPropertyQName()) : XmlTypeName.forGlobalName((char)'t', (QName)wsdlPart.getType());
                if (verbose) {
                    Verbose.log("createExceptionFromFault:   about to call deserializeType with , exceptionPropertyClass " + ((Class)object).getName() + ", message part type " + wsdlPart.getType() + ", xmlTypeName " + object2 + ", on element with tag name '" + sOAPElement.getTagName() + "'");
                }
                object6 = object5.deserializeType(sOAPElement, (Class)object, (XmlTypeName)object2, false);
                throwable = bl2 ? (Throwable)((WsFault)object7).getMarshalPropertyExceptionConstructor().newInstance(object6) : (Throwable)object6;
            }
        }
        catch (Throwable throwable2) {
            if (verbose) {
                Verbose.logException(throwable2);
            }
            throw new CodecException("Failed to decode exception for name " + (object2 == null ? "<null>" : object2) + ", " + throwable2);
        }
        if (verbose) {
            Verbose.log(" deserialization complete, exception is " + throwable);
        }
        return throwable;
    }

    private SOAPElement getTopLevel(Detail detail) {
        if (detail == null) {
            return null;
        }
        Iterator iterator = detail.getChildElements();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPElement)) continue;
            return (SOAPElement)e;
        }
        return null;
    }

    private WsdlPart getPart(WsFault wsFault) {
        WsdlMessage wsdlMessage = wsFault.getFaultMessage();
        Iterator<? extends WsdlPart> iterator = wsdlMessage.getParts().values().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("A fault message must have at leastone part");
        }
        WsdlPart wsdlPart = iterator.next();
        return wsdlPart;
    }

    private QName findXsiType(SOAPMessage sOAPMessage, SOAPElement sOAPElement) {
        Name name = null;
        try {
            name = sOAPMessage.getSOAPPart().getEnvelope().createName("type");
        }
        catch (Throwable throwable) {
            return null;
        }
        String string = sOAPElement.getAttributeValue(name);
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") != -1) {
            String string2 = string.substring(0, string.indexOf(":"));
            String string3 = string.substring(string.indexOf(":") + 1);
            String string4 = sOAPElement.getNamespaceURI(string2);
            if (string4 == null) {
                return new QName(string);
            }
            return new QName(string4, string3);
        }
        return new QName(string);
    }

    private void encodeFault(MessageContext messageContext, WsMethod wsMethod, WsFault wsFault, Throwable throwable) throws SOAPException, XmlException, XMLStreamException {
        WsdlMessage wsdlMessage;
        Object object;
        SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
        RuntimeBindings runtimeBindings = ((WsServiceImpl)wsMethod.getEndpoint().getService()).getBindingProvider();
        BindingContext bindingContext = null;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        WsdlBindingOperation wsdlBindingOperation = wlMessageContext.getDispatcher().getBindingOperation();
        WsdlMessage wsdlMessage2 = wsFault.getFaultMessage();
        Object object2 = null;
        Object object3 = wsdlBindingOperation.getFaults().values().iterator();
        while (object3.hasNext()) {
            object = object3.next();
            wsdlMessage = null;
            try {
                wsdlMessage = object.getMessage();
                if (!wsdlMessage.equals(wsdlMessage2)) continue;
                object2 = object;
            }
            catch (Throwable throwable2) {
                Verbose.log("WsdlBindingMessage.getMessage caught " + throwable2.getMessage());
            }
        }
        if (object2 != null) {
            if (verbose) {
                Verbose.log("\n\n ++++ encodeFault matched up wsdlBindingMessage for fault: " + wsFault + ", wsdlBindinMessage is: " + object2);
            }
            if ((object3 = SoapFault.narrow(object2)) != null) {
                object = ((SoapFault)object3).getUse();
                bindingContext = SerializationContextUtil.createSerializerContext(runtimeBindings, messageContext, (String)object, ((SoapMessageBase)object3).getEncodingStyle());
            } else if (verbose) {
                Verbose.log("\n\n ++++ encodeFault COULD NOT get SoapFault from the wsdlBindingMessage for fault: " + wsFault);
            }
        } else if (verbose) {
            Verbose.log("\n\n ++++ encodeFault COULD NOT match up wsdlBindingMessage for fault: " + wsFault);
        }
        if (bindingContext == null) {
            if (verbose) {
                Verbose.log("\n\n ++++ encodeFault for fault: " + wsFault + " use LITERAL serializer as a default");
            }
            bindingContext = runtimeBindings.createSerializerContext(0);
        }
        bindingContext.setMessage(sOAPMessage);
        bindingContext.setDocument((Document)sOAPMessage.getSOAPPart());
        object3 = sOAPMessage.getSOAPBody();
        object = object3.addFault();
        object.setFaultString(throwable.getMessage());
        wsdlMessage = object.addDetail();
        WsdlPart wsdlPart = this.getPart(wsFault);
        if (wsFault.marshalProperty()) {
            Method method;
            if (verbose) {
                Verbose.log("+++++  encodeFault Serialize xsd builtin pn wire for fault " + wsFault);
            }
            if ((method = wsFault.getMarshalPropertyGetterMethod()) != null) {
                Object object4 = null;
                try {
                    object4 = method.invoke((Object)throwable, new Object[0]);
                }
                catch (Exception exception) {
                    if (verbose) {
                        Verbose.log(" encodeFault Could not serialize user exception.  Unable to execute getter on exception " + method.getName() + " due to " + exception.getMessage());
                    }
                    return;
                }
                Class clazz = wsFault.getMarshalPropertyClass();
                QName qName = wsFault.getMarshalPropertyQName();
                XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName);
                QName qName2 = null;
                if (wsdlPart.getElement() == null) {
                    qName2 = new QName(wsdlPart.getName());
                    if (verbose) {
                        Verbose.log("++++ encodeFault serialize as TYPE, class '" + clazz + "', using XmlTypeName '" + xmlTypeName + "', partName '" + qName2 + "'");
                    }
                    bindingContext.serializeType((SOAPElement)wsdlMessage, object4, clazz, xmlTypeName, qName2, false, WsdlUtils.getMimeType(wsdlPart.getName(), (WsdlBindingMessage)object2));
                } else {
                    xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)wsdlPart.getElement());
                    if (verbose) {
                        Verbose.log("++++ encodeFault serialize as ELEMENT, class '" + clazz + "', using XmlTypeName '" + xmlTypeName + "'");
                    }
                    bindingContext.serializeElement((SOAPElement)wsdlMessage, object4, clazz, xmlTypeName, false, WsdlUtils.getMimeType(wsdlPart.getName(), (WsdlBindingMessage)object2));
                }
            }
        } else {
            if (verbose) {
                Verbose.log("++++  encodeFault Serialize complexException for fault " + wsFault);
            }
            XmlTypeName xmlTypeName = null;
            QName qName = null;
            if (wsdlPart.getElement() == null) {
                xmlTypeName = XmlTypeName.forGlobalName((char)'t', (QName)wsdlPart.getType());
                qName = new QName(wsdlPart.getName());
                if (verbose) {
                    Verbose.log("++++ encodeFault Serialize as TYPE, using XmlTypeName '" + xmlTypeName + "'");
                }
                bindingContext.serializeType((SOAPElement)wsdlMessage, throwable, wsFault.getExceptionClass(), xmlTypeName, qName, false, WsdlUtils.getMimeType(wsdlPart.getName(), (WsdlBindingMessage)object2));
            } else {
                xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)wsdlPart.getElement());
                if (verbose) {
                    Verbose.log("++++  encodeFault Serialize as ELEMENT, using XmlTypeName '" + xmlTypeName + "'");
                }
                bindingContext.serializeElement((SOAPElement)wsdlMessage, throwable, wsFault.getExceptionClass(), xmlTypeName, false, WsdlUtils.getMimeType(wsdlPart.getName(), (WsdlBindingMessage)object2));
            }
        }
        if (verbose) {
            Verbose.log("++++  encodeFault Exception encoded " + sOAPMessage);
        }
    }

    private String findStyle(Dispatcher dispatcher) throws WsdlException {
        Iterator<? extends WsdlOperation> iterator = dispatcher.getWsdlPort().getPortType().getOperations().values().iterator();
        WsdlOperation wsdlOperation = iterator.next();
        WsdlBindingOperation wsdlBindingOperation = dispatcher.getWsdlPort().getBinding().getOperations().get(wsdlOperation.getName());
        SoapBinding soapBinding = this.getSoapBinding(wsdlBindingOperation.getBinding());
        if (soapBinding == null) {
            throw new WsdlException("SoapBinding extension is not found for binding");
        }
        SoapBindingOperation soapBindingOperation = this.getSoapBindingOperation(wsdlBindingOperation);
        if (soapBindingOperation == null) {
            throw new WsdlException("SoapOperation extension is not found for operation");
        }
        return SoapEncoder.getStyle(soapBindingOperation, soapBinding);
    }

    private QName getFaultCode(SOAPFault sOAPFault) {
        Name name = sOAPFault.getFaultCodeAsName();
        if (name == null) {
            return null;
        }
        QName qName = SaajUtil.qnameFromName(name);
        return qName;
    }

    private SoapMessageContext getSoapMessageContext(MessageContext messageContext) throws CodecException {
        if (!(messageContext instanceof SoapMessageContext)) {
            throw new CodecException("SoapCodec can only handle SOAPMessageContext but found '" + messageContext.getClass() + "'");
        }
        SoapMessageContext soapMessageContext = (SoapMessageContext)messageContext;
        return soapMessageContext;
    }

    private SOAPElement getFirstElement(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPElement)) continue;
            return (SOAPElement)e;
        }
        return null;
    }

    static {
        SOAPFactory sOAPFactory = WLSOAPFactory.createSOAPFactory();
        String string = "something_unlikely";
        String string2 = "http://void.operation.org";
        try {
            VOID_NAME_KEY = sOAPFactory.createName(string, null, string2);
        }
        catch (SOAPException sOAPException) {
            throw new IllegalStateException("Failed to create javax.xml.soap.Name with namespace " + string2 + " localpart " + string);
        }
        is81CustomException = Boolean.getBoolean("weblogic.wsee.soap.81CustomException");
    }
}

