/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.codec.soap11;

import com.bea.staxb.buildtime.WildcardUtil;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.xbeanmarshal.buildtime.internal.util.XmlBeanUtil;
import com.bea.xbeanmarshal.runtime.ElementWildcardHelper;
import com.bea.xml.XmlException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.bind.runtime.DeserializerContext;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.codec.CodecException;
import weblogic.wsee.codec.soap11.SoapEncoder;
import weblogic.wsee.util.HeaderUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsReturnType;
import weblogic.wsee.ws.WsServiceImpl;
import weblogic.wsee.ws.WsType;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBody;
import weblogic.xml.saaj.SOAPMessageImpl;

public class SoapDecoder {
    private SOAPMessage soapMessage;
    private WsdlBindingMessage message;
    private WsMethod method;
    private SoapBody soapBody;
    private RuntimeBindings bindings;
    private boolean isMTOMmessage;
    private static final boolean verbose = Verbose.isVerbose(SoapDecoder.class);
    private static boolean WRITE_ELEMENT_WILDCARD_ARRAY_WRAPPER = false;
    private SOAPMessageContext soapMessageCtx;

    protected SoapDecoder(SOAPMessageContext sOAPMessageContext, WsdlBindingMessage wsdlBindingMessage, WsMethod wsMethod) {
        this.soapMessageCtx = sOAPMessageContext;
        this.soapMessage = sOAPMessageContext.getMessage();
        this.message = wsdlBindingMessage;
        this.method = wsMethod;
        this.isMTOMmessage = ((SOAPMessageImpl)this.soapMessage).getIsMTOMmessage();
    }

    public void decode(Map map, boolean bl) throws WsdlException, SOAPException, CodecException, XMLStreamException, XmlException {
        if (verbose) {
            Verbose.log("Decoding SOAP Message");
        }
        SOAPEnvelope sOAPEnvelope = this.soapMessage.getSOAPPart().getEnvelope();
        WsdlBindingOperation wsdlBindingOperation = this.message.getBindingOperation();
        SoapBinding soapBinding = this.getSoapBinding(wsdlBindingOperation.getBinding());
        if (soapBinding == null) {
            throw new WsdlException("SoapBinding extension is not found for binding");
        }
        SoapBindingOperation soapBindingOperation = this.getSoapBindingOperation(wsdlBindingOperation);
        if (soapBindingOperation == null) {
            throw new WsdlException("SoapOperation extension is not found for operation");
        }
        SOAPBody sOAPBody = null;
        String string = SoapEncoder.getStyle(soapBindingOperation, soapBinding);
        if ("document".equals(string)) {
            if (this.method.isWrapped()) {
                Iterator iterator = sOAPEnvelope.getBody().getChildElements();
                sOAPBody = this.getFirstElement(iterator);
            } else {
                sOAPBody = sOAPEnvelope.getBody();
            }
        } else if ("rpc".equals(string)) {
            Iterator iterator = sOAPEnvelope.getBody().getChildElements();
            sOAPBody = this.getFirstElement(iterator);
            if (sOAPBody == null) {
                throw new CodecException("For RPC style web service, Soap Body element must have a child element.");
            }
        } else {
            throw new CodecException("unknown style '" + string + "'");
        }
        this.decodeParts((SOAPElement)sOAPBody, map, bl);
        HeaderUtil.checkMustUnderstandHeader(sOAPEnvelope.getHeader());
    }

    private SOAPElement getFirstElement(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPElement)) continue;
            return (SOAPElement)e;
        }
        return null;
    }

    private void decodeParts(SOAPElement sOAPElement, Map map, boolean bl) throws WsdlException, CodecException, XMLStreamException, XmlException {
        int n;
        this.bindings = ((WsServiceImpl)this.method.getEndpoint().getService()).getBindingProvider();
        this.soapBody = this.getSoapBody(this.message);
        if (this.soapBody == null) {
            throw new WsdlException("SoapBody extension is not found for message");
        }
        if ("literal".equals(this.soapBody.getUse())) {
            n = 0;
        } else if ("encoded".equals(this.soapBody.getUse())) {
            n = 1;
        } else {
            throw new AssertionError((Object)("unknown encoding: " + this.soapBody.getUse()));
        }
        DeserializerContext deserializerContext = this.bindings.createDeserializerContext(n, sOAPElement.getOwnerDocument().getDocumentElement(), bl);
        deserializerContext.setMessage(this.soapMessage);
        deserializerContext.setMessageContext((MessageContext)this.soapMessageCtx);
        Iterator iterator = sOAPElement.getChildElements();
        if (this.message.getType() == 0) {
            this.decodeParams(iterator, map, deserializerContext);
        } else {
            this.decodeReturn(iterator, map, deserializerContext);
        }
        SOAPElement sOAPElement2 = this.getNextElement(iterator);
        if (sOAPElement2 != null) {
            throw new CodecException("Found more elements in the soap envelope than required by WSDL:" + sOAPElement2.getElementName() + ". WSDL Message" + " for this operation is: " + this.message);
        }
    }

    private void decodeParams(Iterator iterator, Map map, DeserializerContext deserializerContext) throws XMLStreamException, XmlException, WsdlException, CodecException {
        SOAPElement sOAPElement = null;
        Iterator iterator2 = this.method.getParameters();
        while (iterator2.hasNext()) {
            SOAPElement sOAPElement2;
            WsParameterType wsParameterType = (WsParameterType)iterator2.next();
            if (wsParameterType.getMode() != 2 && wsParameterType.getMode() != 0) continue;
            boolean bl = false;
            if (wsParameterType.isHeader()) {
                sOAPElement2 = this.getHeaderElement(wsParameterType);
                bl = true;
            } else {
                if (sOAPElement == null) {
                    sOAPElement2 = this.getNextElement(iterator);
                } else {
                    sOAPElement2 = sOAPElement;
                    sOAPElement = null;
                }
                if (this.isOptionalParam(wsParameterType)) {
                    if (sOAPElement2 != null) {
                        if (!this.match(sOAPElement2, wsParameterType)) {
                            map.put(wsParameterType.getName(), null);
                            if (!iterator2.hasNext()) {
                                throw new CodecException("Found more elements in the soap envelope than required by WSDL:" + sOAPElement2.getElementName() + ". WSDL Message" + " for this operation is: " + this.message);
                            }
                            sOAPElement = sOAPElement2;
                            continue;
                        }
                    } else {
                        map.put(wsParameterType.getName(), null);
                        continue;
                    }
                }
            }
            if (wsParameterType.getXmlName().isElementWildcardArrayType() || wsParameterType.getXmlName().isElementWildcardType()) {
                if (sOAPElement2 == null) {
                    map.put(wsParameterType.getName(), null);
                    continue;
                }
                if (wsParameterType.getXmlName().isElementWildcardArrayType() && !WRITE_ELEMENT_WILDCARD_ARRAY_WRAPPER) {
                    try {
                        sOAPElement2 = ElementWildcardHelper.createSyntheticWrappedArray((SOAPElement)sOAPElement2, (Iterator)iterator, (boolean)verbose);
                    }
                    catch (Throwable throwable) {
                        throw new CodecException(" Error while trying to create array element wrapper for extensibility elements.  Exception '" + throwable.getMessage() + "'");
                    }
                }
            } else if (wsParameterType.getJavaType().getName().equals(WildcardUtil.SOAPELEMENT_CLASSNAME)) {
                if (sOAPElement2 == null) {
                    map.put(wsParameterType.getName(), null);
                    continue;
                }
            } else {
                this.checkNullElement(sOAPElement2, wsParameterType);
            }
            Object object = this.decodePart(wsParameterType, sOAPElement2, deserializerContext);
            map.put(wsParameterType.getName(), object);
            if (!bl) continue;
            sOAPElement2.getParentElement().removeChild((Node)sOAPElement2);
        }
    }

    private boolean isOptionalParam(WsParameterType wsParameterType) {
        return wsParameterType.isOptionalElement();
    }

    private boolean match(SOAPElement sOAPElement, WsParameterType wsParameterType) {
        XmlTypeName xmlTypeName = wsParameterType.getXmlName();
        if (xmlTypeName != null && (xmlTypeName.isElementWildcardArrayType() || xmlTypeName.isElementWildcardType() || xmlTypeName.isElementWildcardArrayElement() || xmlTypeName.isElementWildcardElement())) {
            return true;
        }
        QName qName = wsParameterType.getElementName();
        if (qName == null && wsParameterType.getXmlName() != null && wsParameterType.getXmlName().isElement()) {
            qName = wsParameterType.getXmlName().getQName();
        }
        return sOAPElement != null && sOAPElement.getElementQName() != null && sOAPElement.getElementQName().equals(qName);
    }

    private SOAPElement getHeaderElement(WsParameterType wsParameterType) throws CodecException {
        try {
            SOAPElement sOAPElement;
            SOAPHeader sOAPHeader = this.soapMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                throw new CodecException("Soap header element is not found");
            }
            Iterator iterator = sOAPHeader.getChildElements();
            while (iterator.hasNext() && (sOAPElement = this.getNextElement(iterator)) != null) {
                XmlTypeName xmlTypeName = wsParameterType.getXmlName();
                if (xmlTypeName.isElement()) {
                    QName qName = xmlTypeName.getQName();
                    String string = sOAPElement.getNamespaceURI();
                    if (string == null) {
                        string = "";
                    }
                    if (!qName.getLocalPart().equals(sOAPElement.getLocalName()) || !qName.getNamespaceURI().equals(string)) continue;
                    return sOAPElement;
                }
                if (!wsParameterType.getName().equals(sOAPElement.getLocalName())) continue;
                return sOAPElement;
            }
        }
        catch (SOAPException sOAPException) {
            throw new CodecException("failed to get soap header", sOAPException);
        }
        return null;
    }

    private void checkNullElement(SOAPElement sOAPElement, WsParameterType wsParameterType) throws CodecException {
        if (sOAPElement == null) {
            throw new CodecException("Unable to find xml element for parameter: " + wsParameterType.getName());
        }
        XmlTypeName xmlTypeName = wsParameterType.getXmlName();
        if (xmlTypeName.isElement()) {
            QName qName = xmlTypeName.getQName();
            String string = sOAPElement.getNamespaceURI();
            if (string == null) {
                string = "";
            }
            if (!qName.getLocalPart().equals(sOAPElement.getLocalName()) || !qName.getNamespaceURI().equals(string)) {
                throw new CodecException("Unable to find xml element for parameter: " + wsParameterType.getName());
            }
        } else {
            String string = xmlTypeName.toString();
            String string2 = string = string == null ? "" : string;
            if (string.startsWith("t=") && !wsParameterType.getName().equals(sOAPElement.getLocalName())) {
                throw new CodecException("Unable to find xml element for parameter: " + wsParameterType.getName());
            }
        }
    }

    private void decodeReturn(Iterator iterator, Map map, DeserializerContext deserializerContext) throws XMLStreamException, XmlException, WsdlException, CodecException {
        Object object;
        boolean bl = false;
        WsReturnType wsReturnType = this.method.getReturnType();
        if (wsReturnType != null) {
            object = this.getNextElement(iterator);
            if (object != null) {
                if (wsReturnType.getXmlName().isElementWildcardArrayType()) {
                    bl = true;
                    try {
                        object = ElementWildcardHelper.createSyntheticWrappedArray((SOAPElement)object, (Iterator)iterator, (boolean)verbose);
                    }
                    catch (Throwable throwable) {
                        throw new CodecException(" Error while trying to create array element wrapper for extensibility elements.  Exception '" + throwable.getMessage() + "'");
                    }
                }
                map.put(wsReturnType.getName(), this.decodePart(wsReturnType, (SOAPElement)object, deserializerContext));
            } else {
                map.put(wsReturnType.getName(), null);
            }
        }
        object = this.method.getParameters();
        while (object.hasNext()) {
            SOAPElement sOAPElement;
            WsParameterType wsParameterType = (WsParameterType)object.next();
            if (wsParameterType.getMode() != 2 && wsParameterType.getMode() != 1) continue;
            SOAPElement sOAPElement2 = sOAPElement = wsParameterType.isHeader() ? this.getHeaderElement(wsParameterType) : this.getNextElement(iterator);
            if (!wsParameterType.isHeader()) {
                if (bl) {
                    String string = "";
                    try {
                        string = XmlBeanUtil.toXMLString((Node)this.soapMessage.getSOAPPart().getEnvelope().getBody());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new IllegalArgumentException(" WebService operation='" + this.message.getBindingOperation().getName() + "' has a return type that is mapped to an unbounded element wildcard <any maxOccurs='unbounded'../>. " + "\n This operation also has parameters that are either INOUT or OUT parameters. " + "\n Because the names of the element wildcard array elements are indeterminant, " + "\n the xml decoder cannot tell where the return type wildcard array elements end and where the " + "INOUT or OUT parameters begin.  Decoding of this message is aborted." + "\n  Message: \n\n" + string + "\n\n\n");
                }
                if (wsParameterType.getXmlName().isElementWildcardArrayType()) {
                    try {
                        sOAPElement = ElementWildcardHelper.createSyntheticWrappedArray((SOAPElement)sOAPElement, (Iterator)iterator, (boolean)verbose);
                    }
                    catch (Throwable throwable) {
                        throw new CodecException(" Error while trying to create array element wrapper for extensibility elements.  Exception '" + throwable.getMessage() + "'");
                    }
                }
            } else {
                HeaderUtil.removeMustUnderstandFromHeader((Element)sOAPElement);
            }
            map.put(wsParameterType.getName(), this.decodePart(wsParameterType, sOAPElement, deserializerContext));
        }
    }

    private SOAPElement getNextElement(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPElement)) continue;
            return (SOAPElement)e;
        }
        return null;
    }

    private Object decodePart(WsType wsType, SOAPElement sOAPElement, DeserializerContext deserializerContext) throws XMLStreamException, XmlException, WsdlException {
        String string = wsType.getName();
        WsdlPart wsdlPart = this.message.getMessage().getParts().get(string);
        Object object = wsType.isAnyXmlObject() ? deserializerContext.deserializeXmlObjects(this.method.isWrapped(), wsType.isXmlObjectForDocument() | wsType.isArrayOfXmlObjectForDocument(), wsType.isArrayOfXmlObjectForType() | wsType.isArrayOfXmlObjectForDocument(), sOAPElement, wsType.getJavaType(), wsType.getElementName()) : (this.method.isWrapped() && !wsType.isHeader() ? deserializerContext.deserializeWrappedElement(sOAPElement, wsType.getJavaType(), wsType.getXmlName(), this.isMTOMmessage) : (wsdlPart.getType() != null ? deserializerContext.deserializeType(sOAPElement, wsType.getJavaType(), wsType.getXmlName(), this.isMTOMmessage) : deserializerContext.deserializeElement(sOAPElement, wsType.getJavaType(), wsType.getXmlName(), this.isMTOMmessage)));
        if (verbose) {
            Verbose.logArgs("name", wsType.getName(), "XML root", sOAPElement.getElementName(), "value", object);
        }
        return object;
    }

    protected SoapBody getSoapBody(WsdlBindingMessage wsdlBindingMessage) {
        return SoapBody.narrow(wsdlBindingMessage);
    }

    protected SoapBindingOperation getSoapBindingOperation(WsdlBindingOperation wsdlBindingOperation) {
        return SoapBindingOperation.narrow(wsdlBindingOperation);
    }

    protected SoapBinding getSoapBinding(WsdlBinding wsdlBinding) {
        return SoapBinding.narrow(wsdlBinding);
    }
}

