/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.codec.soap11;

import com.bea.xml.XmlException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.bind.runtime.SerializerContext;
import weblogic.wsee.codec.CodecException;
import weblogic.wsee.codec.soap11.SerializationContextUtil;
import weblogic.wsee.codec.soap12.Soap12Encoder;
import weblogic.wsee.mtom.api.MtomPolicyInfo;
import weblogic.wsee.mtom.api.MtomPolicyInfoFactory;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsReturnType;
import weblogic.wsee.ws.WsServiceImpl;
import weblogic.wsee.ws.WsType;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.soap11.SoapBinding;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBody;

public class SoapEncoder {
    private SOAPMessage soapMessage;
    private WsdlBindingMessage message;
    private WsMethod method;
    private Map args;
    private RuntimeBindings bindings;
    private SerializerContext serContext;
    private SoapBody soapBody;
    protected MessageContext messageContext;
    private boolean useMTOMmessage;
    private static final String ENCODING_STYLE = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String SOAP12_ENCODING_STYLE = "http://www.w3.org/2003/05/soap-encoding";
    private static final boolean verbose = Verbose.isVerbose(SoapEncoder.class);

    protected SoapEncoder(SOAPMessage sOAPMessage, WsdlBindingMessage wsdlBindingMessage, WsMethod wsMethod, MessageContext messageContext) {
        block8: {
            block7: {
                this.messageContext = null;
                this.useMTOMmessage = true;
                this.soapMessage = sOAPMessage;
                this.message = wsdlBindingMessage;
                this.method = wsMethod;
                this.messageContext = messageContext;
                try {
                    MtomPolicyInfo mtomPolicyInfo = MtomPolicyInfoFactory.getInstance(messageContext);
                    if (mtomPolicyInfo.isMtomDisable()) {
                        this.useMTOMmessage = false;
                    }
                    if (verbose) {
                        Verbose.log("useMTOMmessage set to '" + this.useMTOMmessage + "'");
                    }
                }
                catch (PolicyException policyException) {
                    this.useMTOMmessage = false;
                    if (!verbose) break block7;
                    Verbose.log(" unable to get MtomPolicyInfo.  useMTOMmessage will have value '" + this.useMTOMmessage + "'");
                }
            }
            if (messageContext.getProperty("weblogic.wsee.xop.normal") != null) {
                try {
                    sOAPMessage.setProperty("weblogic.wsee.xop.normal", (Object)"true");
                }
                catch (SOAPException sOAPException) {
                    if (!verbose) break block8;
                    Verbose.log(" unable to enable normal xop");
                }
            }
        }
    }

    protected void encode(Map map) throws SOAPException, CodecException, WsdlException, XmlException, XMLStreamException {
        this.args = map;
        SOAPEnvelope sOAPEnvelope = this.soapMessage.getSOAPPart().getEnvelope();
        WsdlBindingOperation wsdlBindingOperation = this.message.getBindingOperation();
        WsdlBinding wsdlBinding = wsdlBindingOperation.getBinding();
        SoapBinding soapBinding = this.getSoapBinding(wsdlBinding);
        if (soapBinding == null) {
            throw new WsdlException("SoapBinding extension is not found for binding");
        }
        SoapBindingOperation soapBindingOperation = this.getSoapBindingOperation(wsdlBindingOperation);
        if (soapBindingOperation == null) {
            throw new WsdlException("SoapOperation extension is not found for operation");
        }
        this.addSoapActionHeader(this.soapMessage, soapBindingOperation);
        this.soapBody = this.getSoapBody(this.message);
        if (this.soapBody == null) {
            throw new WsdlException("SoapBody extension is not found for message");
        }
        Object object = null;
        String string = SoapEncoder.getStyle(soapBindingOperation, soapBinding);
        if ("document".equals(string)) {
            object = this.method.isWrapped() ? this.createWrapElementForDoc(sOAPEnvelope) : sOAPEnvelope.getBody();
        } else if ("rpc".equals(string)) {
            object = this.createWrapElementForRpc(sOAPEnvelope);
        } else {
            throw new CodecException("unknown style '" + string + "'");
        }
        this.encodeParts((SOAPElement)object);
        if (this.soapMessage.getProperty("weblogic.wsee.xop.normal.set") != null) {
            this.messageContext.setProperty("weblogic.wsee.xop.normal.set", this.soapMessage.getProperty("weblogic.wsee.xop.normal.set"));
            this.soapMessage.setProperty("weblogic.wsee.xop.normal.set", null);
        }
    }

    protected void addSoapActionHeader(SOAPMessage sOAPMessage, SoapBindingOperation soapBindingOperation) {
        String string = soapBindingOperation.getSoapAction();
        if (string != null) {
            string = this.wrap(string);
            if (verbose) {
                Verbose.log("Soap action: " + string);
            }
            sOAPMessage.getMimeHeaders().setHeader("SOAPAction", string);
        } else {
            if (verbose) {
                Verbose.log("No soap action found using \"\"");
            }
            sOAPMessage.getMimeHeaders().setHeader("SOAPAction", "\"\"");
        }
    }

    protected String wrap(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.startsWith("\"")) {
            stringBuffer.append("\"");
        }
        stringBuffer.append(string);
        if (!string.endsWith("\"")) {
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    static String getStyle(SoapBindingOperation soapBindingOperation, SoapBinding soapBinding) {
        String string = soapBindingOperation.getStyle();
        if (string != null && !"".equals(string)) {
            return string;
        }
        string = soapBinding.getStyle();
        if (string != null && !"".equals(string)) {
            return string;
        }
        return "document";
    }

    private void encodeParts(SOAPElement sOAPElement) throws CodecException, SOAPException, XmlException, XMLStreamException, WsdlException {
        this.bindings = ((WsServiceImpl)this.method.getEndpoint().getService()).getBindingProvider();
        this.serContext = SerializationContextUtil.createSerializerContext(this.bindings, this.messageContext, this.soapBody.getUse(), this instanceof Soap12Encoder ? SOAP12_ENCODING_STYLE : ENCODING_STYLE);
        if ("encoded".equals(this.soapBody.getUse()) && !(this instanceof Soap12Encoder)) {
            this.soapMessage.getSOAPPart().getEnvelope().setEncodingStyle(ENCODING_STYLE);
        }
        assert (this.serContext != null);
        this.serContext.setMessage(this.soapMessage);
        this.serContext.setDocument((Document)this.soapMessage.getSOAPPart());
        if (this.message.getType() == 0) {
            this.encodeParams(sOAPElement, this.soapMessage.getSOAPHeader());
        } else {
            this.encodeReturn(sOAPElement, this.soapMessage.getSOAPHeader());
        }
        this.serContext.serializeReferencedObjects((SOAPElement)this.soapMessage.getSOAPBody());
    }

    private void encodeReturn(SOAPElement sOAPElement, SOAPHeader sOAPHeader) throws XmlException, XMLStreamException, WsdlException {
        Iterator<Object> iterator;
        WsReturnType wsReturnType = this.method.getReturnType();
        if (wsReturnType != null) {
            iterator = this.args.get(wsReturnType.getName());
            this.encodePart(sOAPElement, wsReturnType, iterator);
        }
        iterator = this.method.getParameters();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            if (wsParameterType.getMode() != 2 && wsParameterType.getMode() != 1) continue;
            Object v = this.args.get(wsParameterType.getName());
            SOAPHeader sOAPHeader2 = wsParameterType.isHeader() ? sOAPHeader : sOAPElement;
            this.encodePart((SOAPElement)sOAPHeader2, wsParameterType, v);
        }
    }

    private void encodeParams(SOAPElement sOAPElement, SOAPHeader sOAPHeader) throws XmlException, XMLStreamException, CodecException, WsdlException {
        int n = 0;
        Iterator iterator = this.method.getParameters();
        while (iterator.hasNext()) {
            SOAPHeader sOAPHeader2;
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            if (verbose) {
                Verbose.log("Is header: " + wsParameterType.isHeader());
            }
            if (wsParameterType.getMode() == 1) continue;
            Object object = sOAPHeader2 = wsParameterType.isHeader() ? sOAPHeader : sOAPElement;
            if (n >= this.args.size()) {
                throw new CodecException("Not enough args to invoke '" + this.method.getOperationName() + "'. Number of args = " + this.args.size() + " method = " + this.method);
            }
            this.encodePart((SOAPElement)sOAPHeader2, wsParameterType, this.args.get(wsParameterType.getName()));
            ++n;
        }
        if (iterator.hasNext()) {
            throw new CodecException("Too many args to invoke '" + this.method.getOperationName() + "'. Number of args = " + this.args.size() + " method = " + this.method);
        }
    }

    private void encodePart(SOAPElement sOAPElement, WsType wsType, Object object) throws XmlException, XMLStreamException, WsdlException {
        if (verbose) {
            Verbose.logArgs("xml root", sOAPElement.getElementName(), "parameter", wsType.getName(), "xml type", wsType.getXmlName(), "java type", wsType.getJavaType(), "value", object);
        }
        String string = wsType.getName();
        WsdlPart wsdlPart = this.message.getMessage().getParts().get(string);
        assert (wsdlPart != null);
        if (wsType.isAnyXmlObject()) {
            QName qName = null;
            qName = this.method.isWrapped() ? wsType.getElementName() : (wsType.getElementName() != null ? wsType.getElementName() : wsType.getXmlName().getQName());
            this.serContext.serializeXmlObjects(this.method.isWrapped(), wsType.isXmlObjectForDocument() | wsType.isArrayOfXmlObjectForDocument(), wsType.isArrayOfXmlObjectForType() | wsType.isArrayOfXmlObjectForDocument(), sOAPElement, wsType.getJavaType(), object, qName);
        } else if (this.method.isWrapped() && !wsType.isHeader()) {
            this.serContext.serializeType(sOAPElement, object, wsType.getJavaType(), wsType.getXmlName(), wsType.getElementName(), this.useMTOMmessage, wsdlPart == null ? null : WsdlUtils.getMimeType(wsdlPart.getName(), this.message));
        } else if (wsdlPart.getType() != null) {
            this.serializeType(wsType.isHeader(), string, sOAPElement, object, wsType, wsdlPart == null ? null : WsdlUtils.getMimeType(wsdlPart.getName(), this.message));
        } else {
            this.serContext.serializeElement(sOAPElement, object, wsType.getJavaType(), wsType.getXmlName(), this.useMTOMmessage, wsdlPart == null ? null : WsdlUtils.getMimeType(wsdlPart.getName(), this.message));
        }
    }

    private void serializeType(boolean bl, String string, SOAPElement sOAPElement, Object object, WsType wsType, String string2) throws XmlException, XMLStreamException {
        QName qName = bl ? new QName(this.soapBody.getNamespace(), string) : new QName(string);
        this.serContext.serializeType(sOAPElement, object, wsType.getJavaType(), wsType.getXmlName(), qName, this.useMTOMmessage, string2);
    }

    private SOAPElement createWrapElementForDoc(SOAPEnvelope sOAPEnvelope) throws SOAPException {
        QName qName = null;
        qName = this.message.getType() == 0 ? this.method.getWrapperElement() : this.method.getReturnWrapperElement();
        return this.addWrapper(qName.getNamespaceURI(), qName.getLocalPart(), sOAPEnvelope);
    }

    private SOAPElement createWrapElementForRpc(SOAPEnvelope sOAPEnvelope) throws SOAPException {
        String string = null;
        string = this.message.getType() == 0 ? this.method.getOperationName().getLocalPart() : this.method.getOperationName().getLocalPart() + "Response";
        String string2 = this.soapBody.getNamespace();
        return this.addWrapper(string2, string, sOAPEnvelope);
    }

    private SOAPElement addWrapper(String string, String string2, SOAPEnvelope sOAPEnvelope) throws SOAPException {
        Name name = string == null || "".equals(string) ? sOAPEnvelope.createName(string2) : sOAPEnvelope.createName(string2, "m", string);
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        SOAPBodyElement sOAPBodyElement = sOAPBody.addBodyElement(name);
        if (string != null && !"".equals(string)) {
            sOAPBodyElement.addNamespaceDeclaration("m", string);
        }
        return sOAPBodyElement;
    }

    protected SoapBody getSoapBody(WsdlBindingMessage wsdlBindingMessage) {
        return SoapBody.narrow(wsdlBindingMessage);
    }

    protected SoapBindingOperation getSoapBindingOperation(WsdlBindingOperation wsdlBindingOperation) {
        return SoapBindingOperation.narrow(wsdlBindingOperation);
    }

    protected SoapBinding getSoapBinding(WsdlBinding wsdlBinding) {
        return SoapBinding.narrow(wsdlBinding);
    }
}

