/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.codec.soap12;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.codec.soap11.SoapEncoder;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.soap11.SoapBindingOperation;
import weblogic.wsee.wsdl.soap12.Soap12Binding;
import weblogic.wsee.wsdl.soap12.Soap12BindingOperation;
import weblogic.wsee.wsdl.soap12.Soap12Body;

public class Soap12Encoder
extends SoapEncoder {
    private static final boolean verbose = Verbose.isVerbose(Soap12Encoder.class);

    Soap12Encoder(SOAPMessage sOAPMessage, WsdlBindingMessage wsdlBindingMessage, WsMethod wsMethod, MessageContext messageContext) {
        super(sOAPMessage, wsdlBindingMessage, wsMethod, messageContext);
    }

    protected Soap12Body getSoapBody(WsdlBindingMessage wsdlBindingMessage) {
        return Soap12Body.narrow(wsdlBindingMessage);
    }

    protected Soap12BindingOperation getSoapBindingOperation(WsdlBindingOperation wsdlBindingOperation) {
        return Soap12BindingOperation.narrow(wsdlBindingOperation);
    }

    protected Soap12Binding getSoapBinding(WsdlBinding wsdlBinding) {
        return Soap12Binding.narrow(wsdlBinding);
    }

    protected void addSoapActionHeader(SOAPMessage sOAPMessage, SoapBindingOperation soapBindingOperation) {
        String string = soapBindingOperation.getSoapAction();
        if (!StringUtil.isEmpty(string)) {
            block10: {
                try {
                    sOAPMessage.setProperty("weblogic.xml.saaj.action-parameter", (Object)string);
                }
                catch (SOAPException sOAPException) {
                    if (!verbose) break block10;
                    Verbose.logException(sOAPException);
                }
            }
            string = this.wrap(string);
            if (verbose) {
                Verbose.log("Adding action parameter: " + string + " to Content-Type");
            }
            String string2 = "application/soap+xml";
            String[] stringArray = sOAPMessage.getMimeHeaders().getHeader("Content-Type");
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
            string2 = string2.trim();
            int n = string2.indexOf("action=");
            int n2 = 7;
            String string3 = null;
            if (n > 0) {
                string3 = string2.substring(0, n + n2) + string;
                int n3 = string2.indexOf(";", n);
                if (n3 >= 0) {
                    string3 = string3 + string2.substring(n3);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder(string2);
                if (!string2.endsWith(";")) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(" action=");
                stringBuilder.append(string);
                string3 = stringBuilder.toString();
            }
            sOAPMessage.getMimeHeaders().setHeader("Content-Type", string3);
            if (verbose) {
                Verbose.log("Set Content-Type to: " + string3);
            }
        }
    }
}

