/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.component;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.holders.Holder;
import weblogic.wsee.component.Component;
import weblogic.wsee.component.ComponentException;
import weblogic.wsee.util.Verbose;

public abstract class BaseComponent
implements Component {
    private static final boolean verbose = Verbose.isVerbose(BaseComponent.class);

    public void preinvoke(String string, MessageContext messageContext) throws ComponentException {
    }

    public void postinvoke(String string, MessageContext messageContext) throws ComponentException {
    }

    public void destroy() {
    }

    protected Method findMethod(Class clazz, String string, Class[] classArray) {
        if (verbose) {
            Verbose.log("method " + string);
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!string.equals(methodArray[i].getName())) continue;
            if (classArray == null) {
                return methodArray[i];
            }
            Class[] classArray2 = methodArray[i].getParameterTypes();
            if (!BaseComponent.isAssignable(classArray, classArray2)) continue;
            return methodArray[i];
        }
        return null;
    }

    protected static boolean isAssignable(Class[] classArray, Class[] classArray2) {
        if (classArray == null || classArray2 == null) {
            return false;
        }
        if (verbose) {
            Verbose.log("Arg length " + classArray.length + " & " + classArray2.length);
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (BaseComponent.isAssignable(classArray[i], classArray2[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean isAssignable(Class clazz, Class clazz2) {
        Class<?> clazz3 = BaseComponent.unwrapHolderType(clazz);
        Class<?> clazz4 = BaseComponent.unwrapHolderType(clazz2);
        if (verbose) {
            Verbose.log(clazz3 + " & " + clazz4);
        }
        if (clazz3.getName().equals(clazz4.getName())) {
            return true;
        }
        if (clazz4.isAssignableFrom(clazz3)) {
            return true;
        }
        if (!clazz3.isArray() || !clazz4.isArray()) {
            return false;
        }
        int n = 0;
        while (clazz3.getComponentType() != null) {
            ++n;
            clazz3 = clazz3.getComponentType();
        }
        int n2 = 0;
        while (clazz4.getComponentType() != null) {
            ++n2;
            clazz4 = clazz4.getComponentType();
        }
        return n == n2 && clazz4.isAssignableFrom(clazz3);
    }

    private static Class unwrapHolderType(Class clazz) {
        if (Holder.class.isAssignableFrom(clazz)) {
            try {
                Field field = clazz.getField("value");
                return field.getType();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalArgumentException(clazz + " is an instance of" + "Holder class, but it does not have a public field called value. " + noSuchFieldException);
            }
            catch (SecurityException securityException) {
                throw new IllegalArgumentException(clazz + " is an instance of" + "Holder class, but it does not have a public field called value. " + securityException);
            }
        }
        return clazz;
    }
}

