/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.component.ejb;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import weblogic.ejb.spi.MethodUtils;
import weblogic.ejb.spi.WSObjectFactory;
import weblogic.wsee.component.BaseComponent;
import weblogic.wsee.component.Component;
import weblogic.wsee.component.ComponentException;
import weblogic.wsee.server.WsSecurityContextHandler;
import weblogic.wsee.server.ejb.WsEjb;

public class EjbComponent
extends BaseComponent
implements Component {
    public static final String EJBTARGET = "weblogic.wsee.ejb.target";
    public static final String ALT_RUN_AS = "weblogic.wsee.ejb.altRunAs";
    private WSObjectFactory wsofact;
    private final Class sei;
    private final Map preOps = new HashMap();
    private final Map operations = new HashMap();

    public EjbComponent(WSObjectFactory wSObjectFactory, Class clazz) {
        this.wsofact = wSObjectFactory;
        this.sei = clazz;
    }

    public void preinvoke(String string, MessageContext messageContext) throws ComponentException {
        Method method = (Method)this.preOps.get(string);
        try {
            WsEjb wsEjb = new WsEjb(this.wsofact);
            wsEjb.preInvoke(method, messageContext.getProperty(ALT_RUN_AS), new WsSecurityContextHandler(messageContext));
            messageContext.setProperty(EJBTARGET, (Object)wsEjb);
        }
        catch (Exception exception) {
            throw new ComponentException("Failed to do preinvoke for operation '" + method.getName() + "'", exception);
        }
    }

    public Object invoke(String string, Object[] objectArray, MessageContext messageContext) throws ComponentException {
        WsEjb wsEjb = (WsEjb)messageContext.getProperty(EJBTARGET);
        Method method = (Method)this.operations.get(string);
        try {
            return wsEjb.invoke(method, objectArray);
        }
        catch (Throwable throwable) {
            throw new ComponentException("Failed to do invoke for operation  " + method.getName() + throwable, throwable);
        }
    }

    public void postinvoke(String string, MessageContext messageContext) throws ComponentException {
        WsEjb wsEjb = (WsEjb)messageContext.getProperty(EJBTARGET);
        wsEjb.postInvoke();
    }

    public void registerOperation(String string, String string2, Class[] classArray) throws ComponentException {
        String string3;
        assert (string != null);
        assert (string2 != null);
        Method method = this.findMethod(this.sei, string2, classArray);
        if (method == null) {
            throw new ComponentException("Unable to find method '" + string2 + "' " + "operation " + string + "' in service endpoint interface :" + " " + this.sei);
        }
        Class<?> clazz = this.wsofact.create().getClass();
        Method method2 = this.findMethod(clazz, string3 = MethodUtils.getWSOPreInvokeMethodName(method), WsEjb.getPreinvokeParams(classArray));
        if (method2 == null) {
            throw new AssertionError((Object)("preinvoke method is not found for method " + method));
        }
        String string4 = MethodUtils.getWSOBusinessMethodName(method);
        Method method3 = this.findMethod(clazz, string4, classArray);
        if (method2 == null) {
            throw new AssertionError((Object)("business method is not found for method " + method));
        }
        this.preOps.put(string, method2);
        this.operations.put(string, method3);
    }

    public String toString() {
        return this.sei.getName() + " (EJB)";
    }
}

