/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.component.pojo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.server.ServiceLifecycle;
import weblogic.jws.ForceDotNetCompatibleBinding;
import weblogic.wsee.component.BaseComponent;
import weblogic.wsee.component.Component;
import weblogic.wsee.component.ComponentException;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.dispatch.server.ServletEndpointContextImpl;

public class JavaClassComponent
extends BaseComponent
implements Component {
    private static final boolean verbose = Verbose.isVerbose(JavaClassComponent.class);
    private ServletEndpointContextImpl endpointCtx;
    private Object target;
    private Class targetClass;
    private Map operations = new HashMap();

    public JavaClassComponent(Class clazz, ServletContext servletContext) throws ComponentException {
        this.endpointCtx = new ServletEndpointContextImpl(servletContext, clazz);
        this.targetClass = clazz;
        this.target = this.createTarget();
    }

    public Object createTarget() throws ComponentException {
        Object var1_1 = null;
        try {
            var1_1 = this.targetClass.newInstance();
            this.callInit(var1_1);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ComponentException("Failed to create a new instance", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ComponentException("Failed to create a new instance", instantiationException);
        }
        return var1_1;
    }

    private void callInit(Object object) throws ComponentException {
        if (object instanceof ServiceLifecycle) {
            ServiceLifecycle serviceLifecycle = (ServiceLifecycle)object;
            try {
                serviceLifecycle.init((Object)this.endpointCtx);
            }
            catch (ServiceException serviceException) {
                throw new ComponentException("failed to call init method on the target " + (Object)((Object)serviceException));
            }
        }
    }

    public void destroy() {
        if (ServiceLifecycle.class.isInstance(this.target)) {
            ServiceLifecycle serviceLifecycle = (ServiceLifecycle)this.target;
            serviceLifecycle.destroy();
        }
    }

    public void preinvoke(String string, MessageContext messageContext) throws ComponentException {
        super.preinvoke(string, messageContext);
        this.forceDotNetCompatibleBinding(messageContext);
    }

    private void forceDotNetCompatibleBinding(MessageContext messageContext) {
        ForceDotNetCompatibleBinding forceDotNetCompatibleBinding = this.targetClass.getAnnotation(ForceDotNetCompatibleBinding.class);
        if (forceDotNetCompatibleBinding != null) {
            messageContext.setProperty("weblogic.wsee.dotnet.compatible.binding", (Object)forceDotNetCompatibleBinding.value());
        }
    }

    public Object invoke(String string, Object[] objectArray, MessageContext messageContext) throws ComponentException {
        this.endpointCtx.setMessageContext(messageContext);
        Method method = (Method)this.operations.get(string);
        if (method == null) {
            throw new ComponentException("Unable to find a method with name '" + string + "' in target :" + this.target);
        }
        Object object = null;
        try {
            try {
                object = method.invoke(this.getTarget(messageContext), objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ComponentException("Failed to invoke method", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ComponentException("Failed to invoke method", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ComponentException("Failed to invoke method", invocationTargetException);
            }
            Object var8_6 = null;
            this.endpointCtx.unSetMessageContext();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.endpointCtx.unSetMessageContext();
            throw throwable;
        }
        return object;
    }

    private Object getTarget(MessageContext messageContext) {
        Container container = ContainerFactory.getContainer(messageContext);
        if (container != null) {
            return container.getTargetJWS();
        }
        return this.target;
    }

    public void registerOperation(String string, String string2, Class[] classArray) throws ComponentException {
        assert (string != null);
        assert (string2 != null);
        if (verbose) {
            Verbose.log("Register method:" + string2 + " operation: " + string);
        }
        for (Method method : this.targetClass.getMethods()) {
            if (!string2.equals(method.getName())) continue;
            if (classArray == null) {
                this.operations.put(string, method);
                return;
            }
            Class[] classArray2 = method.getParameterTypes();
            if (JavaClassComponent.isAssignable(classArray, classArray2)) {
                this.operations.put(string, method);
                return;
            }
            if (!verbose) continue;
            Verbose.log("Found method: " + method + ", but arguments " + "does not match: " + Verbose.expand(classArray));
        }
        throw new ComponentException("Unable to find method '" + string2 + "' " + "operation '" + string + "' in target class: " + this.targetClass);
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Object getTarget() {
        return this.target;
    }

    public String toString() {
        return this.targetClass.getName() + " (POJO)";
    }
}

