/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.component.pojo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.transaction.Transaction;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.jws.Transactional;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.UserTransaction;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsPort;

public class PojoTransactionHandler
extends GenericHandler
implements WLHandler {
    private static final String SAVEDTX = "weblogic.wsee.component.pojo.savedtx";
    private static final String TXBEGUN = "weblogic.wsee.component.pojo.txbegun";
    private static final String TXMETHOD = "weblogic.wsee.component.pojo.txmethod";
    private static boolean verbose = Verbose.isVerbose(PojoTransactionHandler.class);
    private static boolean debug = false;
    private UserTransaction utx = null;
    private ClientTransactionManager ctm = null;

    private Class[] toClassArray(Iterator iterator) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            arrayList.add(wsParameterType.getJavaType());
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private void handleStartTx(WlMessageContext wlMessageContext) throws Throwable {
        if (verbose) {
            Verbose.log("POJOTxnhandler: start tx");
        }
        WsPort wsPort = wlMessageContext.getDispatcher().getWsPort();
        if (debug) {
            Verbose.log("wsport = " + wsPort);
        }
        WsMethod wsMethod = wlMessageContext.getDispatcher().getWsMethod();
        if (debug) {
            Verbose.log("wsmethod = " + wsMethod);
        }
        this.ctm = TransactionHelper.getTransactionHelper().getTransactionManager();
        this.utx = (UserTransaction)TransactionHelper.getTransactionHelper().getUserTransaction();
        int n = 30;
        Class clazz = wsPort.getEndpoint().getJwsClass();
        if (debug) {
            Verbose.log("class = " + clazz);
        }
        Transactional transactional = clazz.getAnnotation(Transactional.class);
        Transactional transactional2 = null;
        boolean bl = false;
        if (transactional != null) {
            if (debug) {
                Verbose.log("class has transactional annotation");
            }
            transactional2 = transactional;
            n = transactional2.timeout();
            if (debug) {
                Verbose.log("transaction enabled = " + transactional2.value() + " timeout = " + n);
            }
            bl = transactional2.value();
        }
        Method method = clazz.getMethod(wsMethod.getMethodName(), this.toClassArray(wsMethod.getParameters()));
        if (debug) {
            Verbose.log("method = " + method);
        }
        if ((transactional = method.getAnnotation(Transactional.class)) != null) {
            if (debug) {
                Verbose.log("method has transactional annotation");
            }
            transactional2 = transactional;
            n = transactional2.timeout();
            if (debug) {
                Verbose.log("transaction enabled = " + transactional2.value() + " timeout = " + n);
            }
            bl = transactional2.value();
        }
        if (debug) {
            Verbose.log("transactional = " + bl);
        }
        wlMessageContext.setProperty(TXMETHOD, new Boolean(bl));
        weblogic.transaction.Transaction transaction = null;
        if (bl) {
            if (n < 0) {
                throw new IllegalArgumentException("Invalid transactional timeout value for operation " + wsMethod.getOperationName());
            }
            transaction = (weblogic.transaction.Transaction)TransactionHelper.getTransactionHelper().getTransaction();
            if (transaction == null) {
                if (debug) {
                    Verbose.log("No preexisting txn = ");
                }
                this.utx.setTransactionTimeout(n);
                this.utx.begin();
                if (debug) {
                    Verbose.log("Begun txn");
                }
                wlMessageContext.setProperty(TXBEGUN, new Boolean(true));
            } else {
                if (debug) {
                    Verbose.log("Preexisting txn " + transaction + " - new one not started");
                }
                wlMessageContext.setProperty(SAVEDTX, transaction);
            }
        } else {
            transaction = (weblogic.transaction.Transaction)this.ctm.forceSuspend();
            if (transaction != null) {
                if (verbose) {
                    Verbose.log("Suspending pre-existing txn " + transaction);
                }
                wlMessageContext.setProperty(SAVEDTX, transaction);
            }
        }
    }

    private void handleEndTx(WlMessageContext wlMessageContext) throws Throwable {
        Throwable throwable;
        boolean bl;
        boolean bl2 = wlMessageContext.containsProperty("weblogic.jws.wlw.rollback_on_checked_exception");
        this.ctm = TransactionHelper.getTransactionHelper().getTransactionManager();
        this.utx = (UserTransaction)TransactionHelper.getTransactionHelper().getUserTransaction();
        weblogic.transaction.Transaction transaction = (weblogic.transaction.Transaction)wlMessageContext.getProperty(SAVEDTX);
        Boolean bl3 = (Boolean)wlMessageContext.getProperty(TXBEGUN);
        Boolean bl4 = (Boolean)wlMessageContext.getProperty(TXMETHOD);
        wlMessageContext.removeProperty(SAVEDTX);
        wlMessageContext.removeProperty(TXBEGUN);
        wlMessageContext.removeProperty(TXMETHOD);
        boolean bl5 = wlMessageContext.hasFault();
        boolean bl6 = false;
        if (bl4 != null) {
            bl6 = bl4;
        }
        boolean bl7 = false;
        if (bl3 != null) {
            bl7 = bl3;
        }
        if (debug) {
            Verbose.log("hasFault = " + bl5 + " transactional = " + bl6 + " begun tx " + bl7);
        }
        boolean bl8 = bl = (throwable = (Throwable)wlMessageContext.getProperty("weblogic.wsee.service_specific_exception")) != null;
        if (debug) {
            Verbose.log("isAppException = " + bl);
            Verbose.log("rollbackTxOnCheckedException = " + bl2);
        }
        try {
            if (bl6) {
                if (bl5 || bl && bl2) {
                    if (bl7) {
                        if (verbose) {
                            Verbose.log("Rolling back");
                        }
                        this.utx.rollback();
                    } else if (transaction != null) {
                        if (verbose) {
                            Verbose.log("Setting rollback only");
                        }
                        transaction.setRollbackOnly("Failed to invoke method ", wlMessageContext.getFault());
                    }
                } else if (bl7 && !bl5) {
                    if (this.utx.getStatus() == 1) {
                        if (verbose) {
                            Verbose.log("Can't commit - marked rb");
                        }
                        this.utx.rollback();
                    } else {
                        if (verbose) {
                            Verbose.log("Commiting txn");
                        }
                        this.utx.commit();
                    }
                }
            } else if (transaction != null) {
                if (verbose) {
                    Verbose.log("resuming old txn " + transaction);
                }
                this.ctm.forceResume((Transaction)transaction);
            }
        }
        catch (Exception exception) {
            throw new JAXRPCException((Throwable)exception);
        }
    }

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        try {
            this.handleStartTx(wlMessageContext);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new JAXRPCException(throwable);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        try {
            this.handleEndTx(wlMessageContext);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new JAXRPCException(throwable);
        }
        return true;
    }

    public boolean handleClosure(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }

    public QName[] getHeaders() {
        return new QName[0];
    }
}

