/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection;

import java.util.HashMap;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.local.LocalConnection;
import weblogic.wsee.connection.soap.SoapClientConnection;
import weblogic.wsee.connection.soap.SoapServerConnection;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.connection.transport.http.HTTPClientTransport;
import weblogic.wsee.connection.transport.https.HTTPSClientTransport;
import weblogic.wsee.connection.transport.jms.JmsTransport;
import weblogic.wsee.connection.transport.local.LocalTransport;
import weblogic.wsee.util.ToStringWriter;

public class ConnectionFactory {
    private static ConnectionFactory instance = new ConnectionFactory();
    private HashMap serverConnectionTypes = new HashMap();
    private HashMap clientConnectionTypes = new HashMap();
    private HashMap clientTransportTypes = new HashMap();

    private ConnectionFactory() {
        this.clientConnectionTypes.put("SOAP11", SoapClientConnection.class);
        this.clientConnectionTypes.put("SOAP12", SoapClientConnection.class);
        this.clientConnectionTypes.put("local", LocalConnection.class);
        this.serverConnectionTypes.put("SOAP11", SoapServerConnection.class);
        this.serverConnectionTypes.put("SOAP12", SoapServerConnection.class);
        this.clientTransportTypes.put("http", HTTPClientTransport.class);
        this.clientTransportTypes.put("https", HTTPSClientTransport.class);
        this.clientTransportTypes.put("local", LocalTransport.class);
        this.clientTransportTypes.put("jms", JmsTransport.class);
    }

    public static ConnectionFactory instance() {
        return instance;
    }

    private Transport createClientTransport(String string) throws ConnectionException {
        Class clazz = (Class)this.clientTransportTypes.get(string);
        if (clazz == null) {
            throw new ConnectionException("Failed to find transport=" + string + ". This factory only knows how to handle: \n" + this.toString());
        }
        return (Transport)this.newInstance(clazz);
    }

    public Connection createClientConnection(String string, String string2) throws ConnectionException {
        Transport transport = this.createClientTransport(string);
        Class clazz = null;
        if ("local".equals(string)) {
            clazz = LocalConnection.class;
        }
        if (clazz == null) {
            clazz = (Class)this.clientConnectionTypes.get(string2);
        }
        if (clazz == null) {
            throw new ConnectionException("Failed to find connection for transport='" + transport + "' binding='" + string2 + "'. " + "This factory only knows how to handle: \n" + this.toString());
        }
        Connection connection = (Connection)this.newInstance(clazz);
        connection.setTransport(transport);
        return connection;
    }

    public Connection createServerConnection(Transport transport, String string) throws ConnectionException {
        Class clazz = (Class)this.serverConnectionTypes.get(string);
        if (clazz == null) {
            throw new ConnectionException("Failed to find connection for transport='" + transport + "' binding='" + string + "'. " + "This factory only knows how to handle: \n" + this.toString());
        }
        Connection connection = (Connection)this.newInstance(clazz);
        connection.setTransport(transport);
        return connection;
    }

    private Object newInstance(Class clazz) throws ConnectionException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ConnectionException("Failed to create an instance of '" + clazz.getName() + "' due to: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConnectionException("Failed to create an instance of '" + clazz.getName() + "' due to: " + illegalAccessException);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeMap("clientConnectionTypes", this.clientConnectionTypes);
        toStringWriter.writeMap("clientTransportTypes", this.clientTransportTypes);
        toStringWriter.writeMap("serverConnectionTypes", this.serverConnectionTypes);
        toStringWriter.end();
    }
}

