/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.local;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.local.LoopbackConnection;
import weblogic.wsee.connection.soap.SoapClientConnection;
import weblogic.wsee.connection.transport.ServerTransport;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.connection.transport.local.LocalDelegateServerTransport;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.WsSkel;

public class LocalConnection
implements Connection {
    public static final String INVOKE_REQUEST = "weblogic.wsee.local.invoke.request";
    public static final String INVOKE_RESPONSE = "weblogic.wsee.local.invoke.response";
    public static final String INVOKE_THROWABLE = "weblogic.wsee.local.invoke.throwable";
    public static final String PRIOR_CONTEXT = "weblogic.wsee.local.transport.prior.context";
    private static final boolean verbose = Verbose.isVerbose(LocalConnection.class);
    private Transport transport;
    private LoopbackConnection loopback;
    private SoapMessageContext loopbackCtx;
    private WlMessageContext incomingContext;

    public void setIncomingContext(MessageContext messageContext) {
        this.incomingContext = (WlMessageContext)messageContext;
    }

    public void send(MessageContext messageContext) throws IOException {
        String string = SoapClientConnection.getDestinationAddress(messageContext);
        if (verbose) {
            Verbose.log("address: " + string);
        }
        if (string == null) {
            throw new ConnectionException("Unable to find endpoint address");
        }
        WsPort wsPort = null;
        if (string.startsWith("local://")) {
            wsPort = this.getPort(string.substring("local://".length() - 1));
        } else {
            URI uRI = this.getUri(string);
            wsPort = this.getPort(uRI.getPath());
        }
        this.sendMessage(messageContext, wsPort);
    }

    private void sendMessage(MessageContext messageContext, WsPort wsPort) throws ConnectionException {
        SOAPMessage sOAPMessage = null;
        SoapMessageContext soapMessageContext = null;
        if (!(messageContext instanceof SoapMessageContext)) {
            throw new ConnectionException("Not a SOAP message context");
        }
        soapMessageContext = new SoapMessageContext(AsyncUtil.isSoap12(messageContext));
        Object object = (Map)messageContext.getProperty(INVOKE_REQUEST);
        this.populateContext((Map)object, soapMessageContext);
        sOAPMessage = ((SoapMessageContext)messageContext).getMessage();
        soapMessageContext.setProperty(PRIOR_CONTEXT, messageContext);
        if (verbose) {
            Verbose.log("message: " + sOAPMessage);
        }
        this.loopback = new LoopbackConnection(sOAPMessage);
        if (this.incomingContext != null) {
            this.loopback.setTransport(new LocalDelegateServerTransport((ServerTransport)this.incomingContext.getDispatcher().getConnection().getTransport()));
        } else {
            this.loopback.setTransport(this.transport);
        }
        this.loopbackCtx = soapMessageContext;
        object = (WsSkel)wsPort.getEndpoint();
        try {
            ((WsSkel)object).invoke(this.loopback, wsPort, soapMessageContext);
        }
        catch (WsException wsException) {
            throw new ConnectionException("Failed to send message to end component", wsException);
        }
    }

    private void populateContext(Map map, SOAPMessageContext sOAPMessageContext) throws ConnectionException {
        if (map != null) {
            for (Object k : map.keySet()) {
                if (!(k instanceof String)) {
                    throw new ConnectionException("Local invoke data object should be keyed by a String");
                }
                sOAPMessageContext.setProperty((String)k, map.get(k));
            }
        }
    }

    private WsPort getPort(String string) throws ConnectionException {
        String string2 = WsRegistry.getURL(string);
        String string3 = WsRegistry.getVersion(string);
        WsPort wsPort = WsRegistry.instance().lookup(string2, string3);
        if (wsPort == null) {
            throw new ConnectionException("Unable to find port at address: " + string);
        }
        return wsPort;
    }

    private URI getUri(String string) throws ConnectionException {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ConnectionException("Unable to find parse address: " + string, uRISyntaxException);
        }
        return uRI;
    }

    public void receive(MessageContext messageContext) throws IOException {
        SOAPMessage sOAPMessage = this.loopback.getMessage();
        if (messageContext instanceof SOAPMessageContext) {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            sOAPMessageContext.setMessage(sOAPMessage);
            Map map = (Map)this.loopbackCtx.getProperty(INVOKE_RESPONSE);
            this.populateContext(map, sOAPMessageContext);
            sOAPMessageContext.setProperty(INVOKE_THROWABLE, this.loopbackCtx.getProperty(INVOKE_THROWABLE));
        }
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }
}

