/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.local;

import java.io.IOException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.util.Verbose;

public class LoopbackConnection
implements Connection {
    private static final boolean verbose = Verbose.isVerbose(LoopbackConnection.class);
    private SOAPMessage message;
    private Transport transport;

    LoopbackConnection(SOAPMessage sOAPMessage) {
        if (sOAPMessage == null) {
            throw new IllegalArgumentException("message can not be null");
        }
        this.message = sOAPMessage;
    }

    SOAPMessage getMessage() {
        return this.message;
    }

    public void send(MessageContext messageContext) throws IOException {
        if (!(messageContext instanceof SOAPMessageContext)) {
            throw new ConnectionException("context is not a soap message context");
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        this.message = sOAPMessageContext.getMessage();
    }

    public void receive(MessageContext messageContext) throws IOException {
        if (!(messageContext instanceof SOAPMessageContext)) {
            throw new ConnectionException("context is not a soap message context");
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        sOAPMessageContext.setMessage(this.message);
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }
}

