/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.soap;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.connection.soap.SoapConnection;
import weblogic.wsee.connection.transport.ClientTransport;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.http.HttpTransportInfo;
import weblogic.wsee.connection.transport.https.HTTPSClientTransport;
import weblogic.wsee.connection.transport.https.SSLAdapter;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.EndpointAddressUtil;
import weblogic.wsee.util.Verbose;
import weblogic.xml.saaj.MessageFactoryImpl;

public class SoapClientConnection
extends SoapConnection {
    public static final String TRANSPORT_INFO_PROPERTY = "weblogic.wsee.connection.transportinfo";
    private static final boolean verbose = Verbose.isVerbose(SoapClientConnection.class);

    public void send(MessageContext messageContext) throws IOException {
        String string;
        Object object;
        TransportInfo transportInfo = (TransportInfo)messageContext.getProperty(TRANSPORT_INFO_PROPERTY);
        String string2 = SoapClientConnection.getDestinationAddress(messageContext);
        ClientTransport clientTransport = (ClientTransport)this.getTransport();
        SSLAdapter sSLAdapter = (SSLAdapter)messageContext.getProperty("weblogic.wsee.client.ssladapter");
        if (sSLAdapter != null && clientTransport instanceof HTTPSClientTransport) {
            ((HTTPSClientTransport)clientTransport).setSSLAdapter(sSLAdapter);
        }
        this.setTimeout(messageContext, clientTransport);
        clientTransport.connect(string2, transportInfo);
        SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        String string3 = (String)wlMessageContext.getProperty("weblogic.wsee.transport.jms.url");
        String string4 = (String)wlMessageContext.getProperty("javax.xml.rpc.security.auth.username");
        String string5 = (String)wlMessageContext.getProperty("javax.xml.rpc.security.auth.password");
        if (string4 == null && transportInfo instanceof HttpTransportInfo && ((HttpTransportInfo)(object = (HttpTransportInfo)transportInfo)).getUsername() != null) {
            assert (((HttpTransportInfo)object).getPassword() != null);
            string4 = new String(((HttpTransportInfo)object).getUsername());
            string5 = new String(((HttpTransportInfo)object).getPassword());
        }
        object = (String)wlMessageContext.getProperty("weblogic.wsee.transport.jms.messagetype");
        if (string3 != null) {
            if (verbose) {
                Verbose.say("Adding JMS JNDI URL to header " + string3);
            }
            mimeHeaders.addHeader("weblogic.wsee.transport.jms.url", string3);
        }
        if ((string = EndpointAddressUtil.getProtocolFromEndpointAddress(wlMessageContext)).equalsIgnoreCase("jms") && string4 != null) {
            mimeHeaders.addHeader("javax.xml.rpc.security.auth.username", string4);
            mimeHeaders.addHeader("javax.xml.rpc.security.auth.password", string5);
        }
        if (object != null) {
            if (verbose) {
                Verbose.say("Adding JMS Message Type to header " + (String)object);
            }
            mimeHeaders.addHeader("weblogic.wsee.transport.jms.messagetype", (String)object);
        }
        super.send(messageContext);
    }

    private void setTimeout(MessageContext messageContext, ClientTransport clientTransport) {
        Integer n = (Integer)messageContext.getProperty("weblogic.wsee.transport.read.timeout");
        if (verbose) {
            Verbose.log("Read timeout: " + n);
        }
        Integer n2 = (Integer)messageContext.getProperty("weblogic.wsee.transport.connection.timeout");
        if (verbose) {
            Verbose.log("Connection timeout: " + n2);
        }
        if (n != null) {
            clientTransport.setReadTimeout(n);
        }
        if (n2 != null) {
            clientTransport.setConnectionTimeout(n2);
        }
    }

    public static String getDestinationAddress(MessageContext messageContext) {
        return EndpointAddressUtil.getEndpointAddress(messageContext);
    }

    SOAPMessage createSOAPMessage(SoapMessageContext soapMessageContext, MimeHeaders mimeHeaders, InputStream inputStream, boolean bl) throws IOException, SOAPException {
        return ((MessageFactoryImpl)soapMessageContext.getMessageFactory()).createMessage(mimeHeaders, inputStream, false, bl);
    }
}

