/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.soap;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.kernel.KernelStatus;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.FromHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.addressing.ToHeader;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.handler.HandlerIterator;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.IOUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.xml.saaj.util.HeaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SoapConnection
implements Connection {
    private Transport transport;
    private static final boolean verbose = Verbose.isVerbose(SoapConnection.class);
    protected static final boolean soapMessageLogVerbose = Verbose.isVerbose(SoapConnection.class.getName() + "MessageLog");
    protected static final boolean soapMessageFileVerbose = Verbose.isVerbose(SoapConnection.class.getName() + "Message");
    protected static final boolean soapMessageVerbose = soapMessageFileVerbose || soapMessageLogVerbose;
    protected boolean isMTOMmessage = false;
    private boolean isStreamAttachments = false;
    protected InputStream input = null;

    @Override
    public void send(MessageContext messageContext) throws IOException {
        SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        this.addCustomHeaders(wlMessageContext, mimeHeaders);
        SoapConnection.dumpSoapMsg((SoapMessageContext)wlMessageContext, true);
        OutputStream outputStream = this.transport.send(mimeHeaders);
        IOException iOException = null;
        try {
            sOAPMessage.writeTo(outputStream);
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            IOException iOException2 = new IOException("Could not write SOAPMessage" + sOAPException.toString());
            iOException2.initCause(sOAPException);
            iOException = iOException2;
            throw iOException2;
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            throw iOException3;
        }
        finally {
            this.safeClose(outputStream, iOException);
            this.cleanUpCachedInputStream();
        }
        if (verbose) {
            Verbose.log("Message send ok");
        }
    }

    protected void safeClose(Closeable closeable, IOException iOException) throws IOException {
        try {
            closeable.close();
        }
        catch (IOException iOException2) {
            if (iOException != null) {
                if (verbose) {
                    Verbose.logException(iOException2);
                }
            }
            throw iOException2;
        }
    }

    public static void dumpSoapMsg(SoapMessageContext soapMessageContext, boolean bl) {
        SoapConnection.dumpSoapMsg(soapMessageContext, bl, soapMessageVerbose, soapMessageFileVerbose, soapMessageLogVerbose, Verbose.getOut());
    }

    public static String dumpSoapMsgToString(SoapMessageContext soapMessageContext, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SoapConnection.dumpSoapMsg(soapMessageContext, bl, true, false, true, byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public static void dumpSoapMsg(SoapMessageContext soapMessageContext, boolean bl, boolean bl2, boolean bl3, boolean bl4, OutputStream outputStream) {
        Object object;
        String string;
        String string2;
        String string3;
        if (!bl2) {
            return;
        }
        boolean bl5 = false;
        if (bl) {
            string3 = ">>>";
            string2 = "sent-";
            string = "SENDING";
        } else {
            string3 = "<<<";
            string2 = "recvd-";
            string = "RECEIVING";
            object = (Boolean)soapMessageContext.getProperty("weblogic.wsee.stream_attachments");
            if (object != null && ((Boolean)object).booleanValue()) {
                bl5 = true;
            }
        }
        Verbose.say(string3 + "#########################");
        try {
            String string4;
            object = SoapConnection.getAction(soapMessageContext);
            String string5 = SoapConnection.getCurrentParty(soapMessageContext, bl);
            String string6 = string4 = bl ? " To: " + SoapConnection.getTo(soapMessageContext) : "";
            if (object != null) {
                String string7 = SoapConnection.sanitizeUriForFilename((String)object);
                string7 = string2 + string7;
                if (string5 != null) {
                    string5 = SoapConnection.sanitizeUriForFilename(string5);
                    string7 = string5 + "-" + string7;
                }
                Verbose.say(string3 + "### " + string + " Action: " + (String)object + " Current party: " + string5 + string4);
                StringBuffer stringBuffer = HandlerIterator.getHandlerHistory(soapMessageContext);
                if (stringBuffer.length() > 0) {
                    Verbose.say(string3 + "### Handler history: " + stringBuffer);
                }
                if (!bl5) {
                    if (bl3) {
                        SoapConnection.writeSoapMsgToFile(soapMessageContext.getMessage(), new File("." + File.separatorChar + "soapMessages"), string7);
                    }
                    if (bl4) {
                        try {
                            soapMessageContext.getMessage().writeTo((OutputStream)Verbose.getOut());
                            Verbose.getOut().println();
                        }
                        catch (IOException iOException) {
                            Verbose.logException(iOException);
                        }
                        catch (SOAPException sOAPException) {
                            Verbose.logException(sOAPException);
                        }
                    }
                } else {
                    Verbose.say("Ignore the received attachment(s) message dump.");
                }
            }
        }
        catch (Exception exception) {
            Verbose.logException(exception);
        }
        Verbose.say(string3 + "#########################");
    }

    protected static void printSoapMsg(SOAPMessageContext sOAPMessageContext, boolean bl) {
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        Verbose.getOut().println("\n\n--------- " + (bl ? "SENDING" : "RECEIVING") + " ----------------------\n");
        if (sOAPMessageContext instanceof SoapMessageContext) {
            SoapMessageContext soapMessageContext = (SoapMessageContext)sOAPMessageContext;
            String string = "Unknown";
            String string2 = "Unknown";
            ActionHeader actionHeader = (ActionHeader)soapMessageContext.getHeaders().getHeader(ActionHeader.TYPE);
            if (actionHeader != null) {
                string = actionHeader.getActionURI();
            }
            Verbose.say("SOAP Action: " + string);
            if (bl) {
                ToHeader toHeader = (ToHeader)soapMessageContext.getHeaders().getHeader(ToHeader.TYPE);
                if (toHeader != null) {
                    string2 = toHeader.getAddress();
                }
                Verbose.say("To:          " + string2);
            } else {
                FromHeader fromHeader = (FromHeader)soapMessageContext.getHeaders().getHeader(FromHeader.TYPE);
                if (fromHeader != null) {
                    string2 = fromHeader.getReference().getAddress();
                }
                Verbose.say("From:        " + string2);
            }
        }
        try {
            sOAPMessage.writeTo((OutputStream)Verbose.getOut());
        }
        catch (IOException iOException) {
            Verbose.logException(iOException);
        }
        catch (SOAPException sOAPException) {
            Verbose.logException(sOAPException);
        }
        Verbose.getOut().println("\n\n-------------------------------\n\n\n");
    }

    public static String getCurrentParty(SoapMessageContext soapMessageContext, boolean bl) {
        String string = null;
        EndpointReference endpointReference = (EndpointReference)soapMessageContext.getProperty("weblogic.wsee.addressing.ServerEndpoint");
        if (endpointReference != null) {
            string = endpointReference.getAddress();
        }
        if (string != null) {
            return string;
        }
        string = (String)soapMessageContext.getProperty("weblogic.wsee.service_name");
        if (string != null) {
            return string;
        }
        if (!KernelStatus.isServer()) {
            return "client";
        }
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getCurrentApplicationContext();
        if (applicationContextInternal != null) {
            GenericClassLoader genericClassLoader = applicationContextInternal.getAppClassLoader();
            string = genericClassLoader.getAnnotation() != null ? genericClassLoader.getAnnotation().toString() : applicationContextInternal.getApplicationId();
        } else if (bl) {
            string = SoapConnection.getFrom(soapMessageContext);
            if (string == null) {
                string = SoapConnection.getReplyTo(soapMessageContext);
            }
        } else {
            string = SoapConnection.getTo(soapMessageContext);
        }
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    private static String getTo(SoapMessageContext soapMessageContext) {
        ToHeader toHeader = (ToHeader)soapMessageContext.getHeaders().getHeader(ToHeader.TYPE);
        if (toHeader != null) {
            return toHeader.getAddress();
        }
        String string = (String)soapMessageContext.getProperty("weblogic.wsee.addressing.To");
        if (string != null) {
            return string;
        }
        return null;
    }

    private static String getFrom(SoapMessageContext soapMessageContext) {
        FromHeader fromHeader = (FromHeader)soapMessageContext.getHeaders().getHeader(FromHeader.TYPE);
        if (fromHeader != null) {
            return fromHeader.getReference().getAddress();
        }
        EndpointReference endpointReference = (EndpointReference)soapMessageContext.getProperty("weblogic.wsee.addressing.From");
        if (endpointReference != null) {
            return endpointReference.getAddress();
        }
        return null;
    }

    private static String getReplyTo(SoapMessageContext soapMessageContext) {
        ReplyToHeader replyToHeader = (ReplyToHeader)soapMessageContext.getHeaders().getHeader(ReplyToHeader.TYPE);
        if (replyToHeader != null) {
            return replyToHeader.getReference().getAddress();
        }
        EndpointReference endpointReference = (EndpointReference)soapMessageContext.getProperty("weblogic.wsee.addressing.From");
        if (endpointReference != null) {
            return endpointReference.getAddress();
        }
        return null;
    }

    public static String getAction(SoapMessageContext soapMessageContext) {
        String string;
        String string2 = null;
        ActionHeader actionHeader = (ActionHeader)soapMessageContext.getHeaders().getHeader(ActionHeader.TYPE);
        if (actionHeader != null && (string = actionHeader.getActionURI()) != null) {
            string2 = SoapConnection.sanitizeUriForFilename(string);
        }
        if (string2 == null) {
            string = soapMessageContext.getMessage();
            try {
                SOAPBody sOAPBody = string.getSOAPBody();
                if (sOAPBody != null) {
                    String string3 = null;
                    Iterator iterator = sOAPBody.getChildElements();
                    if (iterator.hasNext()) {
                        Node node = (Node)iterator.next();
                        string3 = node.getNodeName();
                    }
                    if (string3 == null) {
                        string3 = "UnknownBodyElem";
                    }
                    string2 = string3;
                }
            }
            catch (SOAPException sOAPException) {
                sOAPException.printStackTrace();
            }
        }
        return string2;
    }

    private static String sanitizeUriForFilename(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("http://")) {
            string = string.substring("http://".length());
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierStart(c) && !Character.isJavaIdentifierPart(c)) {
                stringBuffer.append("_");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSoapMsgToFile(SOAPMessage sOAPMessage, File file, String string) {
        file = file.getAbsoluteFile();
        file.mkdirs();
        FileOutputStream fileOutputStream = null;
        int n = 2;
        File file2 = SoapConnection.computeMessageFilename(file, string, -1);
        while (file2.exists()) {
            file2 = SoapConnection.computeMessageFilename(file, string, n++);
        }
        try {
            fileOutputStream = new FileOutputStream(file2);
            sOAPMessage.writeTo((OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            Verbose.logException(exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static File computeMessageFilename(File file, String string, int n) {
        File file2 = n <= 0 ? new File(file, string + ".soap") : new File(file, string + "_" + n + ".soap");
        return file2;
    }

    @Override
    public void receive(MessageContext messageContext) throws IOException {
        MimeHeaders mimeHeaders = new MimeHeaders();
        InputStream inputStream = this.transport.receive(mimeHeaders);
        String string = this.getContentType(mimeHeaders);
        boolean bl = this.isMtom(string);
        if (bl) {
            messageContext.setProperty("weblogic.wsee.mtom_message_recvd", (Object)"true");
        } else {
            messageContext.removeProperty("weblogic.wsee.mtom_message_recvd");
        }
        if (messageContext.getProperty("weblogic.wsee.transport.headers") != null) {
            messageContext.setProperty("weblogic.wsee.transport.headers", (Object)mimeHeaders);
        }
        this.setSessionCookies(messageContext, mimeHeaders);
        IOException iOException = null;
        SoapMessageContext soapMessageContext = (SoapMessageContext)messageContext;
        try {
            if (soapMessageContext.getProperty("weblogic.wsee.stream_attachments") != null) {
                this.isStreamAttachments = (Boolean)soapMessageContext.getProperty("weblogic.wsee.stream_attachments");
            }
            SOAPMessage sOAPMessage = this.createSOAPMessage(soapMessageContext, mimeHeaders, inputStream, bl);
            soapMessageContext.setMessage(sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            IOException iOException2 = new IOException("Could not parse SOAP message. Remaining stream ... " + IOUtil.toString(inputStream));
            iOException2.initCause(sOAPException);
            iOException = iOException2;
            throw iOException2;
        }
        finally {
            this.cleanUpInputStream(inputStream, mimeHeaders, iOException);
        }
        SoapConnection.dumpSoapMsg(soapMessageContext, false);
    }

    private void setSessionCookies(MessageContext messageContext, MimeHeaders mimeHeaders) {
        Object object = messageContext.getProperty("javax.xml.rpc.session.maintain");
        if (object != null) {
            if (object instanceof Boolean) {
                String[] stringArray;
                if (((Boolean)object).booleanValue() && (stringArray = mimeHeaders.getHeader("Set-Cookie")) != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (String string : stringArray) {
                        this.addCookies(this.cleanupCookie(string), hashMap);
                    }
                    boolean bl = !hashMap.isEmpty();
                    MimeHeaders mimeHeaders2 = this.mergeMimeHeaderCookies(hashMap, messageContext);
                    if (!hashMap.isEmpty() || bl) {
                        for (String string : hashMap.keySet()) {
                            String string2 = (String)hashMap.get(string);
                            mimeHeaders2.addHeader("Cookie", string + "=" + string2);
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Value of javax.xml.rpc.session.maintain must be java.lang.Boolean");
            }
        }
    }

    private boolean isMtom(String string) throws IOException {
        ContentType contentType;
        if (string.indexOf("application/xop+xml") < 0) {
            return false;
        }
        try {
            contentType = new ContentType(string);
        }
        catch (ParseException parseException) {
            throw new IOException(" could not parse MIME contentType '" + string + "'. " + parseException.getMessage());
        }
        String string2 = contentType.getParameter("type");
        return string2 != null && string2.toLowerCase(Locale.ENGLISH).equals("application/xop+xml");
    }

    private String getContentType(MimeHeaders mimeHeaders) throws IOException {
        String string;
        String string2 = HeaderUtils.getContentType((MimeHeaders)mimeHeaders);
        if (string2 == null) {
            throw new IOException("Null content type");
        }
        if (verbose) {
            Verbose.log("Content type = " + string2);
        }
        if (!((string = string2.toLowerCase(Locale.ENGLISH)).startsWith("text/xml") || string.startsWith("application/soap+xml") || string2.toLowerCase(Locale.ENGLISH).startsWith("multipart/related"))) {
            throw new IOException("Wrong content type '" + string2 + "'. It " + "must be '" + "application/soap+xml" + "', '" + string.startsWith("text/xml") + "', multipart/related' or 'application/xop+xml'");
        }
        return string2;
    }

    protected void addCustomHeaders(WlMessageContext wlMessageContext, MimeHeaders mimeHeaders) {
        MimeHeaders mimeHeaders2 = (MimeHeaders)wlMessageContext.getProperty("weblogic.wsee.transport.headers");
        if (mimeHeaders2 != null) {
            Iterator iterator = mimeHeaders2.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                mimeHeaders.addHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
        }
    }

    @Override
    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("transport", this.transport);
        toStringWriter.end();
    }

    private void addCookies(String string, Map<String, String> map) {
        String[] stringArray;
        for (String string2 : stringArray = StringUtils.splitCompletely((String)string, (String)";")) {
            int n = string2.indexOf("=");
            if (n == -1 || n >= string2.length() - 1) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1, string2.length()).trim();
            map.put(string3, string4);
        }
    }

    private String cleanupCookie(String string) {
        int n = (string = string.trim()).indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private MimeHeaders mergeMimeHeaderCookies(Map<String, String> map, MessageContext messageContext) {
        MimeHeaders mimeHeaders;
        HashMap<String, MimeHeaders> hashMap = (HashMap<String, MimeHeaders>)messageContext.getProperty("weblogic.wsee.invoke_properties");
        if (hashMap == null) {
            hashMap = new HashMap<String, MimeHeaders>();
            messageContext.setProperty("weblogic.wsee.invoke_properties", hashMap);
        }
        if ((mimeHeaders = (MimeHeaders)hashMap.get("weblogic.wsee.transport.headers")) == null) {
            mimeHeaders = new MimeHeaders();
            hashMap.put("weblogic.wsee.transport.headers", mimeHeaders);
        } else {
            String[] stringArray = mimeHeaders.getHeader("Cookie");
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.addCookies(string, map);
                }
                mimeHeaders.removeHeader("Cookie");
            }
        }
        return mimeHeaders;
    }

    abstract SOAPMessage createSOAPMessage(SoapMessageContext var1, MimeHeaders var2, InputStream var3, boolean var4) throws IOException, SOAPException;

    private void cleanUpInputStream(InputStream inputStream, MimeHeaders mimeHeaders, IOException iOException) throws IOException {
        if (!this.isStreamAttachments) {
            this.safeClose(inputStream, iOException);
        } else {
            String[] stringArray = mimeHeaders.getHeader("Transfer-Encoding");
            if (stringArray != null && stringArray.length == 1) {
                if (!"Chunked".equalsIgnoreCase(stringArray[0])) {
                    inputStream.close();
                    this.input = null;
                } else {
                    this.input = inputStream;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpCachedInputStream() throws IOException {
        if (this.input != null) {
            try {
                this.input.read();
                this.input.close();
            }
            finally {
                this.input = null;
            }
        }
    }
}

