/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.connection.soap.SoapConnection;
import weblogic.wsee.connection.transport.ServerTransport;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.xml.saaj.MessageFactoryImpl;

public class SoapServerConnection
extends SoapConnection {
    private static final boolean verbose = Verbose.isVerbose(SoapServerConnection.class);

    public void send(MessageContext messageContext) throws IOException {
        String string;
        String string2;
        String string3;
        SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        this.addCustomHeaders(wlMessageContext, mimeHeaders);
        String string4 = (String)wlMessageContext.getProperty("weblogic.wsee.transport.jms.url");
        if (string4 != null) {
            if (verbose) {
                Verbose.say("Adding JMS JNDI URL to header " + string4);
            }
            mimeHeaders.addHeader("weblogic.wsee.transport.jms.url", string4);
        }
        if ((string3 = (String)wlMessageContext.getProperty("javax.xml.rpc.security.auth.username")) != null) {
            if (verbose) {
                Verbose.say("Adding JMS username/passwrod to header " + string3);
            }
            mimeHeaders.addHeader("javax.xml.rpc.security.auth.username", string3);
        }
        if ((string2 = (String)wlMessageContext.getProperty("javax.xml.rpc.security.auth.password")) != null) {
            mimeHeaders.addHeader("javax.xml.rpc.security.auth.password", string2);
        }
        if ((string = (String)wlMessageContext.getProperty("weblogic.wsee.transport.jms.messagetype")) != null) {
            if (verbose) {
                Verbose.say("Adding JMS JNDI URL to header " + string);
            }
            mimeHeaders.addHeader("weblogic.wsee.transport.jms.messagetype", string);
        }
        SoapServerConnection.dumpSoapMsg((SoapMessageContext)wlMessageContext, true);
        ServerTransport serverTransport = (ServerTransport)this.getTransport();
        OutputStream outputStream = wlMessageContext.hasFault() ? ("true".equals(wlMessageContext.getProperty("weblogic.wsee.AuthRequired")) ? serverTransport.sendAuthorizationRequiredFault(mimeHeaders) : (this.isAuthError(sOAPMessage) ? serverTransport.sendAuthorizationFault(mimeHeaders) : serverTransport.sendGeneralFault(mimeHeaders))) : serverTransport.send(mimeHeaders);
        IOException iOException = null;
        try {
            sOAPMessage.writeTo(outputStream);
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            IOException iOException2 = new IOException("Could not write SOAPMessage" + sOAPException.toString());
            iOException2.initCause(sOAPException);
            iOException = iOException2;
            throw iOException2;
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            throw iOException3;
        }
        finally {
            this.safeClose(outputStream, iOException);
            this.cleanUpCachedInputStream();
        }
        if (verbose) {
            Verbose.log("Message send ok");
        }
    }

    private boolean isAuthError(SOAPMessage sOAPMessage) {
        try {
            Name name;
            SOAPFault sOAPFault = sOAPMessage.getSOAPBody().getFault();
            if (sOAPFault != null && "http://schemas.xmlsoap.org/soap/envelope/".equals((name = sOAPFault.getFaultCodeAsName()).getURI()) && "Client.Authentication".equals(name.getLocalName())) {
                return true;
            }
        }
        catch (SOAPException sOAPException) {
            return false;
        }
        return false;
    }

    SOAPMessage createSOAPMessage(SoapMessageContext soapMessageContext, MimeHeaders mimeHeaders, InputStream inputStream, boolean bl) throws IOException, SOAPException {
        Boolean bl2 = (Boolean)soapMessageContext.getProperty("weblogic.wsee.stream_attachments");
        if (bl2 != null && bl2.booleanValue()) {
            return WLMessageFactory.createMessageWithStreamingAttachments(mimeHeaders, inputStream, soapMessageContext.isSoap12());
        }
        if (bl) {
            return ((MessageFactoryImpl)soapMessageContext.getMessageFactory()).createMessage(mimeHeaders, inputStream, false, true);
        }
        return soapMessageContext.getMessageFactory().createMessage(mimeHeaders, inputStream);
    }
}

