/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import weblogic.deployment.jms.ForeignOpaqueReference;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.VerboseInputStream;
import weblogic.xml.saaj.util.CopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportUtil {
    public static InputStream dumpHttpInput(HttpURLConnection httpURLConnection) throws IOException {
        Verbose.say("   ** S T A R T   R E S P O N S E **");
        Verbose.say(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
        TransportUtil.dumpHeaders(httpURLConnection.getHeaderFields());
        InputStream inputStream = null;
        try {
            inputStream = TransportUtil.getInputStream(httpURLConnection);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream != null) {
            try {
                inputStream = TransportUtil.dumpInput(inputStream);
            }
            catch (IOException iOException) {
                Verbose.log("IOException during dump http input " + iOException);
                Verbose.logException(iOException);
            }
        }
        Verbose.say("");
        Verbose.say("   ** E N D   R E S P O N S E **");
        return inputStream;
    }

    static void dumpHeaders(Map<String, List<String>> map) {
        for (String string : map.keySet()) {
            List<String> list = map.get(string);
            for (String string2 : list) {
                Verbose.say(string + ": " + string2);
            }
        }
        Verbose.say("");
    }

    public static InputStream dumpInput(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        VerboseInputStream verboseInputStream = new VerboseInputStream(inputStream);
        CopyUtils.copy((InputStream)verboseInputStream, (OutputStream)byteArrayOutputStream);
        verboseInputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static InputStream getInputStream(HttpURLConnection httpURLConnection) throws IOException {
        try {
            return httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            InputStream inputStream = httpURLConnection.getErrorStream();
            if (inputStream == null) {
                throw iOException;
            }
            return inputStream;
        }
    }

    public static boolean getForeignCredentials(String string, InitialContext initialContext, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        boolean bl = false;
        try {
            ForeignOpaqueReference foreignOpaqueReference;
            boolean bl2;
            Object object = initialContext.lookupLink(string);
            if (object instanceof ForeignOpaqueReference && (bl2 = (foreignOpaqueReference = (ForeignOpaqueReference)object).isFactory())) {
                String string2 = foreignOpaqueReference.getUsername();
                String string3 = foreignOpaqueReference.getPassword();
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(string2);
                    bl = true;
                }
                if (string3 != null && string3.length() > 0) {
                    bl = true;
                    stringBuffer2.append(string3);
                }
                if (!bl) {
                    Object v;
                    Hashtable hashtable = foreignOpaqueReference.getJNDIEnvironment();
                    Object v2 = hashtable.get("java.naming.security.principal");
                    if (v2 != null && ((String)v2).length() > 0) {
                        bl = true;
                        stringBuffer.append((String)v2);
                    }
                    if ((v = hashtable.get("java.naming.security.credentials")) != null && ((String)v).length() > 0) {
                        bl = true;
                        stringBuffer2.append((String)v);
                    }
                }
            }
        }
        catch (Exception exception) {
            Verbose.log("Can't get credentials associated with foreign jmsconnection factory: " + exception);
        }
        return bl;
    }
}

