/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Locale;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.net.ssl.SSLSession;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import weblogic.net.http.HttpsURLConnection;
import weblogic.utils.io.Chunk;
import weblogic.wsee.connection.ResponseListener;
import weblogic.wsee.connection.transport.ClientTransport;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.TransportUtil;
import weblogic.wsee.connection.transport.http.HttpTransportInfo;
import weblogic.wsee.util.AccessException;
import weblogic.wsee.util.MimeHeadersUtil;
import weblogic.wsee.util.MultiByteConverterUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public class HTTPClientTransport
implements ClientTransport {
    private static final String JAXRPC_USER_AGENT = "Oracle JAX-RPC 1.1";
    private URL url;
    private HttpURLConnection connection;
    private static final boolean verbose = Verbose.isVerbose(HTTPClientTransport.class);
    private int readTimeout = -1;
    private int connectionTimeout = -1;

    public String getName() {
        return "http";
    }

    public String getServiceURI() {
        return this.connection.getURL().getPath();
    }

    public String getEndpointAddress() {
        return this.connection.getURL().toExternalForm();
    }

    public byte[] getSSLSessionId() {
        if (!(this.connection instanceof HttpsURLConnection)) {
            return null;
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.connection;
        SSLSession sSLSession = httpsURLConnection.getSSLSession();
        if (sSLSession == null) {
            return null;
        }
        return sSLSession.getId();
    }

    public void connect(String string, TransportInfo transportInfo) throws IOException {
        int n;
        Object object;
        if (MultiByteConverterUtil.hasNonAsciiOrSpace(string)) {
            if (!MultiByteConverterUtil.isEncodedUrl(string)) {
                object = MultiByteConverterUtil.encodeMultiByteURL(string);
                this.url = new URL((String)object);
            } else {
                this.url = new URL(string);
            }
        } else {
            this.url = new URL(string);
        }
        object = this.getProxy(transportInfo);
        this.connection = this.openConnection(this.url, (Proxy)object, transportInfo);
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setRequestMethod("POST");
        if (this.connectionTimeout != -1) {
            this.connection.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout != -1) {
            this.connection.setReadTimeout(this.readTimeout);
        }
        if (transportInfo instanceof HttpTransportInfo && (n = ((HttpTransportInfo)transportInfo).getChunkedStreamingMode()) > 0) {
            this.connection.setChunkedStreamingMode(n);
        }
        this.connection.setRequestProperty("User-Agent", JAXRPC_USER_AGENT);
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private Proxy getProxy(TransportInfo transportInfo) {
        Proxy proxy = transportInfo != null && transportInfo instanceof HttpTransportInfo ? ((HttpTransportInfo)transportInfo).getProxy() : MimeHeadersUtil.getProxyFromSysProps();
        if (proxy == null && System.getProperty("proxySet") == null) {
            try {
                proxy = this.chooseProxy(this.url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return proxy;
    }

    private Proxy chooseProxy(URI uRI) {
        ProxySelector proxySelector = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

            @Override
            public ProxySelector run() {
                return ProxySelector.getDefault();
            }
        });
        if (proxySelector == null) {
            return Proxy.NO_PROXY;
        }
        if (!proxySelector.getClass().getName().equals("sun.net.spi.DefaultProxySelector")) {
            return null;
        }
        Iterator<Proxy> iterator = proxySelector.select(uRI).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return Proxy.NO_PROXY;
    }

    protected HttpURLConnection openConnection(URL uRL, Proxy proxy, TransportInfo transportInfo) throws IOException {
        if (proxy == null) {
            return (HttpURLConnection)uRL.openConnection();
        }
        return (HttpURLConnection)uRL.openConnection(proxy);
    }

    public OutputStream send(MimeHeaders mimeHeaders) throws IOException {
        Object object;
        if (verbose) {
            Verbose.say("   ** S T A R T   R E Q U E S T **");
            Verbose.say("POST " + this.url);
        }
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            object = (MimeHeader)iterator.next();
            if (verbose) {
                Verbose.say(object.getName() + ": " + object.getValue());
            }
            if (object.getName().equalsIgnoreCase("User-Agent")) {
                this.connection.setRequestProperty(object.getName(), JAXRPC_USER_AGENT);
                continue;
            }
            this.connection.addRequestProperty(object.getName(), object.getValue());
        }
        object = this.connection.getOutputStream();
        return verbose ? new TeeOutputStream((OutputStream)object, Chunk.CHUNK_SIZE) : object;
    }

    public OutputStream sendFault(MimeHeaders mimeHeaders) throws IOException {
        return this.send(mimeHeaders);
    }

    public InputStream receive(MimeHeaders mimeHeaders) throws IOException {
        InputStream inputStream = verbose ? TransportUtil.dumpHttpInput(this.connection) : TransportUtil.getInputStream(this.connection);
        if (!this.validContentType(this.connection.getContentType())) {
            this.handleErrorResponse(false);
        }
        this.readMimeHeaders(mimeHeaders);
        return inputStream;
    }

    private boolean validContentType(String string) {
        if (string == null) {
            return false;
        }
        try {
            string = new ContentType(string).getBaseType();
        }
        catch (ParseException parseException) {
            return false;
        }
        string = string.trim().toLowerCase(Locale.ENGLISH);
        return "text/xml".startsWith(string) || "application/soap+xml".startsWith(string) || "multipart/related".startsWith(string);
    }

    private void readMimeHeaders(MimeHeaders mimeHeaders) {
        String string;
        int n = 1;
        while ((string = this.connection.getHeaderFieldKey(n)) != null) {
            String string2;
            if ((string2 = this.connection.getHeaderField(n++)) == null || string2.length() == 0) continue;
            mimeHeaders.addHeader(string, string2);
        }
    }

    private void handleErrorResponse(boolean bl) throws IOException {
        int n = this.connection.getResponseCode();
        if (!bl) {
            this.dumpErrorStream(n);
            this.disconnect();
        }
        String string = " Set -Dweblogic.wsee.verbose=weblogic.wsee.connection.transport.http.HttpClientTransport to see the full response stream.";
        switch (n) {
            case 500: {
                throw new IOException("The server at " + this.connection.getURL() + " returned a 500 error code (Internal Server Error).  Please ensure" + " that your URL is correct, and the web service has deployed." + string);
            }
            case 400: {
                throw new IOException("The server at url: " + this.connection.getURL() + " returned a 400 error code (received a bad " + "request with malformed syntax)." + string);
            }
            case 404: {
                throw new IOException("The server at " + this.connection.getURL() + " returned a 404 error code (Not Found).  Please ensure that your" + " URL is correct, and the web service has deployed " + "without error.");
            }
            case 403: {
                throw new AccessException("The server at " + this.connection.getURL() + " returned a 403 error code (Forbidden).  Please ensure that your " + "URL is correct and that the correct protocol is in use.");
            }
            case 401: {
                throw new AccessException("The server at " + this.connection.getURL() + " returned a 401 error code (Unauthorized).  Please check that" + " username and password are set correctly and that you have" + " permission to access the requested method.");
            }
            case 301: 
            case 302: {
                throw new IOException("Redirection not supported: The server at " + this.connection.getURL() + " returned a " + n + " response code indicating this resource has moved.");
            }
            case 407: {
                throw new AccessException("The server at " + this.connection.getURL() + " returned a 407 error code (Proxy Authentication Required).  Please ensure that you provide valid " + ".");
            }
        }
        throw new IOException("Received a response from url: " + this.connection.getURL() + " with HTTP status " + n + " and SOAP " + "content-type: " + this.connection.getContentType() + "." + string);
    }

    private void dumpErrorStream(int n) throws IOException {
        InputStream inputStream = this.connection.getErrorStream();
        byte[] byArray = new byte[200];
        if (verbose) {
            Verbose.log("Error stream with status code " + n);
        }
        if (inputStream != null) {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                if (!verbose) continue;
                for (int i = 0; i < n2; ++i) {
                    Verbose.getOut().print((char)byArray[i]);
                }
            }
            if (verbose) {
                Verbose.getOut().println();
            }
        }
    }

    public boolean isBlocking() {
        return true;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setResponseListener(ResponseListener responseListener) {
        throw new UnsupportedOperationException("Blocking transports do not support setResponseListener()");
    }

    public void confirmOneway() throws IOException {
        this.confirmOneway(false);
    }

    public void confirmOneway(boolean bl) throws IOException {
        if (verbose) {
            Verbose.log("confirming status of oneway with code " + this.connection.getResponseCode());
        }
        if (this.connection.getResponseCode() != 202 && this.connection.getResponseCode() != 200) {
            this.handleErrorResponse(bl);
        }
        if (this.connection.getResponseCode() == 202 || this.connection.getResponseCode() == 200 && this.connection.getContentLength() == 0) {
            this.disconnect();
        }
        if (bl) {
            return;
        }
        if (this.connection.getResponseCode() == 200 && this.connection.getContentLength() == -1) {
            InputStream inputStream = null;
            try {
                inputStream = this.connection.getInputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream == null || inputStream.read() == -1) {
                this.disconnect();
            }
        }
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("url", this.url);
        toStringWriter.end();
    }

    private static class TeeOutputStream
    extends BufferedOutputStream {
        public TeeOutputStream(OutputStream outputStream, int n) {
            super(outputStream, n);
            if (verbose) {
                Verbose.say("");
            }
        }

        public void write(int n) throws IOException {
            Verbose.getOut().write(n);
            super.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            Verbose.getOut().write(byArray, n, n2);
            super.write(byArray, n, n2);
        }

        public void close() throws IOException {
            super.close();
            if (verbose) {
                Verbose.say("\n   ** E N D   R E Q U E S T **");
            }
        }
    }
}

