/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.connection.transport.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Proxy;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.server.EncryptionUtil;
import weblogic.wsee.util.MimeHeadersUtil;

public class HttpTransportInfo
implements TransportInfo,
Serializable {
    private static final long serialVersionUID = 5812892933940605683L;
    private byte[] username = null;
    private byte[] password = null;
    private byte[] proxyUsername = null;
    private byte[] proxyPassword = null;
    private transient Proxy proxy = null;
    private int chunkLen = -1;
    private boolean passwordsEncrypted = false;

    public byte[] getUsername() {
        return this.username;
    }

    public void setUsername(byte[] byArray) {
        this.username = byArray;
    }

    public byte[] getPassword() {
        if (this.passwordsEncrypted) {
            this.decryptPasswords();
        }
        return this.password;
    }

    public void setPassword(byte[] byArray) {
        if (this.passwordsEncrypted) {
            this.decryptPasswords();
        }
        this.password = byArray;
    }

    public byte[] getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(byte[] byArray) {
        this.proxyUsername = byArray;
    }

    public byte[] getProxyPassword() {
        if (this.passwordsEncrypted) {
            this.decryptPasswords();
        }
        return this.proxyPassword;
    }

    public void setProxyPassword(byte[] byArray) {
        if (this.passwordsEncrypted) {
            this.decryptPasswords();
        }
        this.proxyPassword = byArray;
    }

    public Proxy getProxy() {
        if (this.proxy == null) {
            this.proxy = MimeHeadersUtil.getProxyFromSysProps();
        }
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setChunkedStreamingMode(int n) {
        this.chunkLen = n;
    }

    int getChunkedStreamingMode() {
        return this.chunkLen;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.passwordsEncrypted) {
            this.encryptPasswords();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.passwordsEncrypted) {
            this.decryptPasswords();
        }
    }

    private void encryptPasswords() {
        if (this.passwordsEncrypted) {
            return;
        }
        if (this.password != null) {
            this.password = EncryptionUtil.encrypt(this.password);
        }
        if (this.proxyPassword != null) {
            this.proxyPassword = EncryptionUtil.encrypt(this.proxyPassword);
        }
        this.passwordsEncrypted = true;
    }

    private void decryptPasswords() {
        if (!this.passwordsEncrypted) {
            return;
        }
        if (this.password != null) {
            this.password = EncryptionUtil.decrypt(this.password);
        }
        if (this.proxyPassword != null) {
            this.proxyPassword = EncryptionUtil.decrypt(this.proxyPassword);
        }
        this.passwordsEncrypted = false;
    }
}

